/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.InvalidConfigException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseLocalConfig {
    public static final String CONFIG_ELEMENT_PROJECT_INFO = "project_info";
    public static final String CONFIG_ELEMENT_PROJECT_NUMBER = "project_number";
    public static final String CONFIG_ELEMENT_PROJECT_ID = "project_id";
    @Nullable
    private File myConfigFile;
    @Nullable
    private String myProjectNumber;
    @Nullable
    private String myProjectId;
    @Nullable
    private JsonElement myJsonConfig;
    @Nullable
    private ImmutableList<InvalidConfigException> myInvalidConfigErrors;

    @VisibleForTesting
    FirebaseLocalConfig(@NotNull File configFile) {
        if (configFile == null) {
            FirebaseLocalConfig.$$$reportNull$$$0(0);
        }
        FirebaseLocalConfig.getLog().info("Config file being inspected: " + configFile);
        try {
            this.myJsonConfig = new JsonParser().parse((Reader)Files.newReader((File)configFile, (Charset)Charsets.UTF_8));
            this.myConfigFile = configFile;
            FirebaseLocalConfig.getLog().info("Config file loaded: " + this.myConfigFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (JsonIOException | JsonSyntaxException jsonException) {
            this.myInvalidConfigErrors = ImmutableList.of((Object)((Object)new InvalidLocalConfigException((Throwable)new InvalidDataException("Malformed json"), "firebaseService.internalError.invalidConfigFileFormat", new Object[]{this.myConfigFile.getAbsolutePath()})));
            return;
        }
        if (!this.isLocalConfigPresent()) {
            return;
        }
        FirebaseLocalConfig.getLog().info("Loading existing Firebase config from file: " + this.myConfigFile.getAbsolutePath());
        try {
            this.loadLocalFirebaseConfig();
        }
        catch (InvalidLocalConfigException exception) {
            this.myInvalidConfigErrors = ImmutableList.of((Object)((Object)exception));
        }
    }

    @Nullable
    public static FirebaseLocalConfig fromModule(@NotNull Module module) {
        File configFile;
        if (module == null) {
            FirebaseLocalConfig.$$$reportNull$$$0(1);
        }
        if ((configFile = FirebaseLocalConfig.locateLocalFirebaseConfig(module)) == null) {
            return null;
        }
        FirebaseLocalConfig config = new FirebaseLocalConfig(configFile);
        if (config.isLocalConfigPresent()) {
            return config;
        }
        return null;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(FirebaseLocalConfig.class);
        if (logger == null) {
            FirebaseLocalConfig.$$$reportNull$$$0(2);
        }
        return logger;
    }

    @Nullable
    public File getConfigFile() {
        return this.myConfigFile;
    }

    @Nullable
    public String getProjectNumber() {
        return this.myProjectNumber;
    }

    @Nullable
    public String getProjectId() {
        return this.myProjectId;
    }

    private boolean isLocalConfigPresent() {
        return this.myConfigFile != null && this.myJsonConfig != null;
    }

    @Nullable
    public List<InvalidConfigException> getConfigErrors() {
        return this.myInvalidConfigErrors;
    }

    private void loadLocalFirebaseConfig() throws InvalidLocalConfigException {
        String projectId;
        String projectNumber;
        assert (this.myConfigFile != null);
        assert (this.myJsonConfig != null);
        if (!this.myJsonConfig.isJsonObject()) {
            throw new InvalidLocalConfigException((Throwable)new InvalidDataException("Malformed json, couldn't find a root json object"), "firebaseService.internalError.invalidConfigFileFormat", new Object[]{this.myConfigFile.getAbsolutePath()});
        }
        JsonObject rootObject = this.myJsonConfig.getAsJsonObject();
        JsonObject projectInfoElement = rootObject.getAsJsonObject(CONFIG_ELEMENT_PROJECT_INFO);
        if (projectInfoElement == null) {
            throw new InvalidLocalConfigException((Throwable)new InvalidDataException("project_info couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", new Object[]{this.myConfigFile.getAbsolutePath()});
        }
        JsonElement projectNumberElement = projectInfoElement.get(CONFIG_ELEMENT_PROJECT_NUMBER);
        if (projectNumberElement == null || Strings.isNullOrEmpty((String)(projectNumber = projectNumberElement.getAsString()))) {
            throw new InvalidLocalConfigException((Throwable)new InvalidDataException("project_number couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", new Object[]{this.myConfigFile.getAbsolutePath()});
        }
        JsonElement projectIdElement = projectInfoElement.get(CONFIG_ELEMENT_PROJECT_ID);
        if (projectIdElement == null || Strings.isNullOrEmpty((String)(projectId = projectIdElement.getAsString()))) {
            throw new InvalidLocalConfigException((Throwable)new InvalidDataException("project_id couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", new Object[]{this.myConfigFile.getAbsolutePath()});
        }
        FirebaseLocalConfig.getLog().info("Found existing project number in local config: " + projectNumber + " - " + projectId);
        this.myProjectNumber = projectNumber;
        this.myProjectId = projectId;
    }

    private static File locateLocalFirebaseConfig(@NotNull Module module) {
        VirtualFile imlFile;
        if (module == null) {
            FirebaseLocalConfig.$$$reportNull$$$0(3);
        }
        if ((imlFile = module.getModuleFile()) == null) {
            return null;
        }
        File configFile = new File(imlFile.getParent().getCanonicalPath(), "google-services.json");
        if (!configFile.exists()) {
            return null;
        }
        return configFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/config/FirebaseLocalConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/config/FirebaseLocalConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromModule";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "locateLocalFirebaseConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidLocalConfigException
    extends InvalidConfigException {
        private InvalidLocalConfigException(@NotNull Throwable cause, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
            if (cause == null) {
                InvalidLocalConfigException.$$$reportNull$$$0(0);
            }
            if (messageKey == null) {
                InvalidLocalConfigException.$$$reportNull$$$0(1);
            }
            if (messageArguments == null) {
                InvalidLocalConfigException.$$$reportNull$$$0(2);
            }
            super(FirebaseBundle.message(messageKey, messageArguments), cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageArguments";
                    break;
                }
            }
            objectArray[1] = "com/google/services/firebase/config/FirebaseLocalConfig$InvalidLocalConfigException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

