/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.services.mobilesdk_pa.v1.model.FirebaseClientSummary;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseOnlineConfig {
    private final Map<AndroidClient, OnlineProject> myClientToProjectMap;
    private final Set<OnlineProject> myProjects;

    FirebaseOnlineConfig(@NotNull Collection<OnlineProject> userAccessibleProjects) {
        if (userAccessibleProjects == null) {
            FirebaseOnlineConfig.$$$reportNull$$$0(0);
        }
        this.myProjects = ImmutableSet.copyOf(userAccessibleProjects);
        ImmutableMap.Builder clientMapBuilder = new ImmutableMap.Builder();
        HashSet seenClients = new HashSet();
        this.myProjects.forEach(arg_0 -> FirebaseOnlineConfig.lambda$new$3((Set)seenClients, clientMapBuilder, arg_0));
        this.myClientToProjectMap = clientMapBuilder.build();
    }

    @NotNull
    public Map<AndroidClient, OnlineProject> getClientToProjectMap() {
        Map<AndroidClient, OnlineProject> map = this.myClientToProjectMap;
        if (map == null) {
            FirebaseOnlineConfig.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Nullable
    public OnlineProject getProject(@NotNull String projectNumber) {
        if (projectNumber == null) {
            FirebaseOnlineConfig.$$$reportNull$$$0(2);
        }
        for (OnlineProject project : this.myProjects) {
            if (project == null || !projectNumber.equals(project.getProjectNumber())) continue;
            return project;
        }
        return null;
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseOnlineConfig.class);
    }

    private static /* synthetic */ void lambda$new$3(Set seenClients, ImmutableMap.Builder clientMapBuilder, OnlineProject onlineProject) {
        onlineProject.getAndroidFirebaseClientSummaries().stream().filter(Objects::nonNull).map(FirebaseClientSummary::getAndroidClientSummary).filter(Objects::nonNull).filter(androidClientSummary -> androidClientSummary.getCertificateHash() != null).forEach(androidClientSummary -> {
            String packageName = androidClientSummary.getPackageName();
            androidClientSummary.getCertificateHash().stream().filter(Objects::nonNull).forEach(sha1 -> {
                AndroidClient client = AndroidClient.createClient(packageName, sha1, false);
                if (seenClients.contains(client)) {
                    FirebaseOnlineConfig.getLog().warn("Client (" + client.toString() + ") found on multiple Firebase projects, ignoring.");
                } else if (client != null) {
                    FirebaseOnlineConfig.getLog().info("Client (" + client.toString() + ") registered with project " + onlineProject.getDisplayName() + "(" + onlineProject.getProjectNumber() + ")");
                    seenClients.add(client);
                    clientMapBuilder.put((Object)client, (Object)onlineProject);
                } else {
                    FirebaseOnlineConfig.getLog().info("Ignoring package and sha1: " + packageName + ":" + sha1);
                }
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAccessibleProjects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/config/FirebaseOnlineConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/config/FirebaseOnlineConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientToProjectMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

