/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.android.builder.model.SigningConfig;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.templates.KeystoreUtils;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.client.util.Maps;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleConfig {
    public static final String RELEASE_BUILD_TYPE = "release";
    private final List<AndroidClient> myVariants;

    public static GradleConfig fromModule(@NotNull Module androidModule) {
        AndroidModuleModel gradleModel;
        if (androidModule == null) {
            GradleConfig.$$$reportNull$$$0(0);
        }
        if ((gradleModel = AndroidModuleModel.get((Module)androidModule)) == null) {
            throw new IllegalStateException("Couldn't retrieve Android gradle model for current Android model");
        }
        AndroidFacet appAndroidFacet = AndroidFacet.getInstance((Module)androidModule);
        if (appAndroidFacet == null) {
            throw new IllegalStateException("Could not find Android Facet associated with the Android module");
        }
        Collection variants = gradleModel.getAndroidProject().getVariants();
        HashMap signingConfigMap = Maps.newHashMap();
        gradleModel.getAndroidProject().getSigningConfigs().forEach(signingConfig -> signingConfigMap.put(signingConfig.getName(), signingConfig));
        ImmutableList.Builder variantListBuilder = ImmutableList.builder();
        for (Variant variant : variants) {
            GradleConfig.getLog().debug("Found variant to inspect: " + variant);
            String packageName = variant.getMainArtifact().getApplicationId();
            String sha1 = GradleConfig.getSigningCertSha1(androidModule, appAndroidFacet, signingConfigMap, variant);
            GradleConfig.getLog().debug("Sha1 - " + sha1);
            if (Strings.isNullOrEmpty((String)packageName) || Strings.isNullOrEmpty((String)sha1)) {
                GradleConfig.getLog().warn("Ignoring variant because signing config couldn't be found, applicationId: " + packageName + ", buildType: " + variant.getBuildType());
                continue;
            }
            boolean allowVariantRegistration = true;
            if (RELEASE_BUILD_TYPE.equalsIgnoreCase(variant.getBuildType())) {
                GradleConfig.getLog().info("Release variants aren't eligible to be auto-registered, applicationId: " + packageName + ", buildType: " + variant.getBuildType());
                allowVariantRegistration = false;
            }
            GradleConfig.getLog().info("Found variant: package=" + packageName + ", sha1=" + sha1 + ", attemptRegistry=" + allowVariantRegistration);
            try {
                AndroidClient client = new AndroidClient(packageName, sha1, allowVariantRegistration);
                variantListBuilder.add((Object)client);
            }
            catch (InvalidDataException | IllegalArgumentException exception) {
                GradleConfig.getLog().info("Ignoring variant with '" + packageName + "' and cert sha1 '" + sha1 + "'");
            }
        }
        return new GradleConfig((ImmutableList<AndroidClient>)variantListBuilder.build());
    }

    @VisibleForTesting
    GradleConfig(@NotNull ImmutableList<AndroidClient> variants) {
        if (variants == null) {
            GradleConfig.$$$reportNull$$$0(1);
        }
        this.myVariants = variants;
    }

    @Nullable
    private static String getSigningCertSha1(@NotNull Module androidModule, @NotNull AndroidFacet appAndroidFacet, @NotNull Map<String, SigningConfig> signingConfigMap, @NotNull Variant variant) {
        if (androidModule == null) {
            GradleConfig.$$$reportNull$$$0(2);
        }
        if (appAndroidFacet == null) {
            GradleConfig.$$$reportNull$$$0(3);
        }
        if (signingConfigMap == null) {
            GradleConfig.$$$reportNull$$$0(4);
        }
        if (variant == null) {
            GradleConfig.$$$reportNull$$$0(5);
        }
        SigningConfig signingConfig = null;
        File storeFile = null;
        String signingConfigName = variant.getMainArtifact().getSigningConfigName();
        if (!Strings.isNullOrEmpty((String)signingConfigName)) {
            signingConfig = signingConfigMap.get(signingConfigName);
            if (signingConfig != null) {
                storeFile = signingConfig.getStoreFile();
            }
        } else if ("debug".equals(variant.getBuildType())) {
            try {
                storeFile = KeystoreUtils.getDebugKeystore((AndroidFacet)appAndroidFacet);
            }
            catch (Exception e) {
                FirebaseUiUtils.showWarningBalloon(androidModule.getProject(), FirebaseBundle.message("firebaseConnectAction.userError.couldNotFindDefaultDebugKeystore", new Object[0]), e);
            }
        }
        if (storeFile == null) {
            return null;
        }
        if (!storeFile.exists()) {
            FirebaseUiUtils.showWarningBalloon(androidModule.getProject(), FirebaseBundle.message("firebaseConnectAction.userError.keystoreNotPresent", storeFile.getAbsoluteFile(), variant.getBuildType(), ""), null);
            return null;
        }
        try {
            if (signingConfig != null && !Strings.isNullOrEmpty((String)signingConfig.getKeyAlias())) {
                if (!signingConfig.getStoreFile().exists()) {
                    FirebaseUiUtils.showWarningBalloon(androidModule.getProject(), FirebaseBundle.message("firebaseConnectAction.userError.couldNotFindDefaultKeystore", variant.getBuildType(), signingConfig.getStoreFile()), null);
                    return null;
                }
                return KeystoreUtils.sha1((File)signingConfig.getStoreFile(), (String)signingConfig.getKeyAlias(), (String)signingConfig.getStorePassword());
            }
            return KeystoreUtils.sha1((File)storeFile);
        }
        catch (Exception exception) {
            GradleConfig.getLog().warn("Skipping variant; unable to calculate SHA1 of certificate in " + storeFile.getAbsolutePath());
            return null;
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(GradleConfig.class);
        if (logger == null) {
            GradleConfig.$$$reportNull$$$0(6);
        }
        return logger;
    }

    public List<AndroidClient> getVariants() {
        return this.myVariants;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appAndroidFacet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signingConfigMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/config/GradleConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/config/GradleConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromModule";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSigningCertSha1";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

