/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.logs;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FirebaseLogTask
implements LaunchTask {
    private final FirebaseLogcatListener myLogLineListener;
    private final String myApplicationId;
    public static final List<String> FIREBASE_TAGS = ImmutableList.of((Object)"FirebaseApp", (Object)"GoogleAuthUtil", (Object)"InstanceID/Store", (Object)"FirebaseRemoteConfig");

    FirebaseLogTask(@NotNull String applicationId) {
        if (applicationId == null) {
            FirebaseLogTask.$$$reportNull$$$0(0);
        }
        this.myLogLineListener = new FirebaseLogcatListener();
        this.myApplicationId = applicationId;
    }

    @NotNull
    public String getDescription() {
        if ("Setting Firebase Log Properties on the device" == null) {
            FirebaseLogTask.$$$reportNull$$$0(1);
        }
        return "Setting Firebase Log Properties on the device";
    }

    public int getDuration() {
        return 1;
    }

    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            FirebaseLogTask.$$$reportNull$$$0(2);
        }
        if (launchStatus == null) {
            FirebaseLogTask.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            FirebaseLogTask.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (device == null) {
                FirebaseLogTask.$$$reportNull$$$0(5);
            }
            try {
                NullOutputReceiver receiver = new NullOutputReceiver();
                device.executeShellCommand("setprop log.tag.FA VERBOSE", (IShellOutputReceiver)receiver);
                device.executeShellCommand("setprop log.tag.FA-SVC VERBOSE", (IShellOutputReceiver)receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        AndroidLogcatService.getInstance().addListener(device, (AndroidLogcatService.LogcatListener)this.myLogLineListener);
        return true;
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseLogTask.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/logs/FirebaseLogTask";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/logs/FirebaseLogTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$perform$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FirebaseLogcatListener
    implements AndroidLogcatService.LogcatListener {
        private FirebaseLogcatListener() {
        }

        public void onLogLineReceived(@NotNull LogCatMessage line) {
            String tag;
            if (line == null) {
                FirebaseLogcatListener.$$$reportNull$$$0(0);
            }
            if (!FIREBASE_TAGS.contains(tag = line.getTag())) {
                return;
            }
            FirebaseLogTask.getLog().info("Processing Firebase log with tag " + tag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/google/services/firebase/logs/FirebaseLogTask$FirebaseLogcatListener", "onLogLineReceived"));
        }
    }
}

