/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.mobilesdk;

import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.MobileSdkWrapperImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MobileSdkUtil {
    static final String DEFAULT_PROJECT_NAME = "FirebaseProject";
    private static final String VALID_PACKAGE_NAME_REGEX = "^[a-zA-Z]{1}[a-zA-Z0-9_]*(\\.[a-zA-Z]{1}[a-zA-Z0-9_]*)+$";
    private static final String VALID_SHA1_FINGERPRINT_REGEX = "^(([0-9a-fA-F]{2}:){19}|([0-9a-fA-F]{2}){19})([0-9a-fA-F]){2}$";
    private static final String VALID_PROJECT_NAME_VALID_CHARS_REGEX = "[0-9a-zA-Z\\-'\" !]";
    private static final String VALID_PROJECT_NAME_REGEX = "^[0-9a-zA-Z\\-'\" !]{4,30}$";
    private static final String VALID_PROJECT_NAME_VALID_CHAR_REGEX_WITH_CAPTURE_GROUP = "([0-9a-zA-Z\\-'\" !]+)+";
    static final Pattern PROJECT_NAME_PATTERN_CAPTURING_VALID_CHARS = Pattern.compile("([0-9a-zA-Z\\-'\" !]+)+");
    private static final Pattern VALID_PROJECT_NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z\\-'\" !]{4,30}$");
    private static final Pattern VALID_SHA1_FINGERPRINT_PATTERN = Pattern.compile("^(([0-9a-fA-F]{2}:){19}|([0-9a-fA-F]{2}){19})([0-9a-fA-F]){2}$");
    private static final Pattern VALID_PACKAGE_NAME_PATTERN = Pattern.compile("^[a-zA-Z]{1}[a-zA-Z0-9_]*(\\.[a-zA-Z]{1}[a-zA-Z0-9_]*)+$");
    private static final int MILLIS_IN_DAY = 3600000;
    private static volatile MobileSdkWrapper ourOverrideSdkWrapper = null;

    public static boolean isValidPackageName(@NotNull String packageName) {
        if (packageName == null) {
            MobileSdkUtil.$$$reportNull$$$0(0);
        }
        return VALID_PACKAGE_NAME_PATTERN.matcher(packageName).matches();
    }

    public static boolean isValidSha1Fingerprint(@NotNull String sha1) {
        if (sha1 == null) {
            MobileSdkUtil.$$$reportNull$$$0(1);
        }
        return VALID_SHA1_FINGERPRINT_PATTERN.matcher(sha1).matches();
    }

    public static boolean isValidProjectName(@NotNull String projectName) {
        if (projectName == null) {
            MobileSdkUtil.$$$reportNull$$$0(2);
        }
        return VALID_PROJECT_NAME_PATTERN.matcher(projectName).matches();
    }

    public static String getValidProjectName(@NotNull String projectName) {
        if (projectName == null) {
            MobileSdkUtil.$$$reportNull$$$0(3);
        }
        if (MobileSdkUtil.isValidProjectName(projectName)) {
            return projectName;
        }
        Matcher matcher = PROJECT_NAME_PATTERN_CAPTURING_VALID_CHARS.matcher(projectName);
        StringBuilder newString = new StringBuilder();
        if (matcher.find()) {
            do {
                newString.append(matcher.group());
            } while (matcher.find());
        } else {
            String newProjectName = DEFAULT_PROJECT_NAME;
            MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
            return newProjectName;
        }
        String newProjectName = newString.toString();
        if (MobileSdkUtil.isValidProjectName(newProjectName)) {
            MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
            return newProjectName;
        }
        newString.append(DEFAULT_PROJECT_NAME);
        newProjectName = newString.toString();
        if (MobileSdkUtil.isValidProjectName(newProjectName)) {
            MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
            return newProjectName;
        }
        newProjectName = newProjectName.substring(0, 30);
        MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
        return newProjectName;
    }

    public static MobileSdkWrapper getNewMobileSdkWrapper(@NotNull GoogleLogin googleLogin) throws MobileSdkCommException {
        if (googleLogin == null) {
            MobileSdkUtil.$$$reportNull$$$0(4);
        }
        if (ourOverrideSdkWrapper != null) {
            return ourOverrideSdkWrapper;
        }
        MobileSdkWrapperImpl.Builder builder = new MobileSdkWrapperImpl.Builder(googleLogin);
        return builder.build();
    }

    static void setMobileSdkWrapperOverride(MobileSdkWrapper wrapper) {
        ourOverrideSdkWrapper = wrapper;
    }

    private static Logger getLog() {
        return Logger.getInstance(MobileSdkUtil.class);
    }

    @NotNull
    public static String getRegionCode() {
        String string = Locale.getDefault().getCountry();
        if (string == null) {
            MobileSdkUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    static int getTimeZoneId(int utcOffsetInHours) {
        return 406 - utcOffsetInHours;
    }

    private static int getCurrentUTCTimeZoneOffsetMillis() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getOffset(new Date().getTime());
    }

    public static int getCurrentTimeZoneId() {
        int hourOffset = MobileSdkUtil.getCurrentUTCTimeZoneOffsetMillis() / 3600000;
        int timeZoneId = MobileSdkUtil.getTimeZoneId(hourOffset);
        MobileSdkUtil.getLog().debug("TimeZoneID returned: " + timeZoneId);
        return timeZoneId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sha1";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "googleLogin";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/mobilesdk/MobileSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/mobilesdk/MobileSdkUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegionCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidPackageName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidSha1Fingerprint";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidProjectName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValidProjectName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNewMobileSdkWrapper";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

