/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.mobilesdk;

import com.google.api.client.util.Lists;
import com.google.api.services.mobilesdk_pa.v1.model.AndroidClientSummary;
import com.google.api.services.mobilesdk_pa.v1.model.ConsoleProject;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseClientSummary;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseProject;
import com.google.api.services.mobilesdk_pa.v1.model.IosClientSummary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.services.firebase.FirebaseBundle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnlineProject {
    private static final String LEGACY_PROJECT_SUFFIX = FirebaseBundle.message("mobileSdkService.displayString.legacyProjectDisplaySuffix", new Object[0]);
    private final List<String> myWarningMessages;
    private final boolean myRequiredFirebaseMigration;
    private final boolean myAnalyticsEnabled;
    private final boolean myUserEditable;
    @NotNull
    private final Map<String, FirebaseClientSummary> myFirebaseClientsByAndroidPackageName;
    private final int myNumAndroidOAuth2Clients;
    private int myNumIosApps;
    @NotNull
    private final String myDisplayName;
    @NotNull
    private DataSharingOption myProjectDataSharingOption;
    @NotNull
    private final String myProjectNumber;
    @Nullable
    private String myProjectId;

    @VisibleForTesting
    public OnlineProject(@NotNull String projectNumber, @Nullable String projectId, @NotNull String displayName, boolean requiredFirebaseMigration, boolean analyticsEnabled, boolean userEditable, @NotNull Collection<FirebaseClientSummary> firebaseClients) {
        if (projectNumber == null) {
            OnlineProject.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            OnlineProject.$$$reportNull$$$0(1);
        }
        if (firebaseClients == null) {
            OnlineProject.$$$reportNull$$$0(2);
        }
        this.myWarningMessages = Lists.newArrayList();
        this.myNumIosApps = 0;
        this.myProjectDataSharingOption = DataSharingOption.DATA_NOT_LOADED;
        this.myProjectNumber = projectNumber;
        this.myProjectId = projectId;
        this.myDisplayName = displayName;
        this.myRequiredFirebaseMigration = requiredFirebaseMigration;
        ImmutableMap.Builder clientBuilder = new ImmutableMap.Builder();
        firebaseClients.forEach(firebaseClientSummary -> {
            IosClientSummary iosClientSummary;
            AndroidClientSummary androidClientSummary = firebaseClientSummary.getAndroidClientSummary();
            if (androidClientSummary != null && !Strings.isNullOrEmpty((String)androidClientSummary.getPackageName())) {
                clientBuilder.put((Object)androidClientSummary.getPackageName(), firebaseClientSummary);
            }
            if ((iosClientSummary = firebaseClientSummary.getIosClientSummary()) != null && !Strings.isNullOrEmpty((String)iosClientSummary.getBundleId())) {
                ++this.myNumIosApps;
            }
        });
        this.myFirebaseClientsByAndroidPackageName = clientBuilder.build();
        this.myNumAndroidOAuth2Clients = this.myFirebaseClientsByAndroidPackageName.values().stream().map(FirebaseClientSummary::getAndroidClientSummary).filter(Objects::nonNull).map(AndroidClientSummary::getCertificateHash).filter(Objects::nonNull).mapToInt(List::size).sum();
        this.myAnalyticsEnabled = analyticsEnabled;
        this.myUserEditable = userEditable;
    }

    @NotNull
    public static OnlineProject fromFirebaseProject(@NotNull FirebaseProject firebaseProject) {
        if (firebaseProject == null) {
            OnlineProject.$$$reportNull$$$0(3);
        }
        boolean hasEditRights = OnlineProject.hasEditRights(firebaseProject);
        List clientSummary = firebaseProject.getClientSummary();
        if (clientSummary == null) {
            clientSummary = ImmutableList.of();
        }
        OnlineProject onlineProject = new OnlineProject(firebaseProject.getProjectNumber(), firebaseProject.getProjectId(), firebaseProject.getDisplayName(), false, true, hasEditRights, clientSummary);
        if (onlineProject == null) {
            OnlineProject.$$$reportNull$$$0(4);
        }
        return onlineProject;
    }

    private static boolean hasEditRights(@NotNull FirebaseProject firebaseProject) {
        if (firebaseProject == null) {
            OnlineProject.$$$reportNull$$$0(5);
        }
        if (firebaseProject.getRole() == null) {
            return false;
        }
        Role role = Role.valueOf(firebaseProject.getRole());
        return role == Role.EDITOR || role == Role.OWNER;
    }

    @NotNull
    public static OnlineProject fromConsoleProject(@NotNull ConsoleProject consoleProject) {
        if (consoleProject == null) {
            OnlineProject.$$$reportNull$$$0(6);
        }
        boolean hasAnalytics = consoleProject.getHasScion() != null ? consoleProject.getHasScion() : false;
        OnlineProject onlineProject = new OnlineProject(consoleProject.getProjectNumber(), null, consoleProject.getProjectDisplayName() + " " + LEGACY_PROJECT_SUFFIX, true, hasAnalytics, true, (Collection<FirebaseClientSummary>)ImmutableList.of());
        if (onlineProject == null) {
            OnlineProject.$$$reportNull$$$0(7);
        }
        return onlineProject;
    }

    public boolean isEditable() {
        return this.myUserEditable;
    }

    @Nullable
    public FirebaseClientSummary getFirebaseClientSummary(@NotNull String packageName) {
        if (packageName == null) {
            OnlineProject.$$$reportNull$$$0(8);
        }
        return this.myFirebaseClientsByAndroidPackageName.get(packageName);
    }

    @NotNull
    public String getProjectNumber() {
        String string = this.myProjectNumber;
        if (string == null) {
            OnlineProject.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public String getProjectId() {
        return this.myProjectId;
    }

    public int getNumAndroidOAuth2Clients() {
        return this.myNumAndroidOAuth2Clients;
    }

    public int getNumIosApps() {
        return this.myNumIosApps;
    }

    @NotNull
    public Collection<FirebaseClientSummary> getAndroidFirebaseClientSummaries() {
        Collection<FirebaseClientSummary> collection = this.myFirebaseClientsByAndroidPackageName.values();
        if (collection == null) {
            OnlineProject.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            OnlineProject.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isAnalyticsEnabled() {
        return this.myAnalyticsEnabled;
    }

    @NotNull
    public Collection<String> getWarningMessages() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myWarningMessages);
        if (immutableList == null) {
            OnlineProject.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    public void addWarningMessages(@NotNull Collection<String> warningMessages) {
        if (warningMessages == null) {
            OnlineProject.$$$reportNull$$$0(13);
        }
        this.myWarningMessages.addAll(warningMessages);
    }

    public boolean isRequiredFirebaseMigration() {
        return this.myRequiredFirebaseMigration;
    }

    public boolean shouldShowProjectDataSharingSetting() {
        this.assertDataSharingDataLoaded();
        return this.isRequiredFirebaseMigration() && this.isAnalyticsEnabled() && DataSharingOption.MANAGED_AT_PROJECT != this.myProjectDataSharingOption;
    }

    void setProjectDataSharingOption(@NotNull DataSharingOption dataSharingOption) {
        if (dataSharingOption == null) {
            OnlineProject.$$$reportNull$$$0(14);
        }
        this.myProjectDataSharingOption = dataSharingOption;
    }

    public boolean isProjectDataSharingEnabled() throws IllegalStateException {
        this.assertDataSharingDataLoaded();
        return DataSharingOption.MANAGED_AT_PROJECT == this.myProjectDataSharingOption;
    }

    private void assertDataSharingDataLoaded() {
        if (DataSharingOption.DATA_NOT_LOADED == this.myProjectDataSharingOption) {
            throw new IllegalStateException("Data sharing information not loaded");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnlineProject that = (OnlineProject)o;
        return this.myProjectNumber.equals(that.myProjectNumber);
    }

    public int hashCode() {
        return this.myProjectNumber.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectNumber";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firebaseClients";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firebaseProject";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/mobilesdk/OnlineProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProject";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningMessages";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSharingOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/mobilesdk/OnlineProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromFirebaseProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromConsoleProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNumber";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidFirebaseClientSummaries";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromFirebaseProject";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasEditRights";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromConsoleProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFirebaseClientSummary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addWarningMessages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setProjectDataSharingOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Role {
        ROLE_UNKNOWN,
        OWNER,
        EDITOR,
        VIEWER;

    }

    public static enum DataSharingOption {
        UNKNOWN_SETTING,
        MANAGED_PER_APP,
        MANAGED_AT_PROJECT,
        DATA_NOT_LOADED;

    }
}

