/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.google.services.firebase.ConnectFirebaseTask;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.ConnectToOnlineProjectPanel;
import com.google.services.firebase.view.FirebaseDialog;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import java.net.URL;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectToOnlineProjectDialog
extends FirebaseDialog {
    private static final int SUCCESS_RETURN_CODE = 0;
    private final boolean isAcceptTos;
    @NotNull
    private final ConnectToOnlineProjectPanel myConnectPanel;
    @NotNull
    private final FirebaseConfig myFirebaseConfig;

    public ConnectToOnlineProjectDialog(@NotNull Module androidLibraryModule, @NotNull FirebaseConfig firebaseConfig, @NotNull Collection<OnlineProject> existingProjects, @Nullable URL tosUrl) {
        if (androidLibraryModule == null) {
            ConnectToOnlineProjectDialog.$$$reportNull$$$0(0);
        }
        if (firebaseConfig == null) {
            ConnectToOnlineProjectDialog.$$$reportNull$$$0(1);
        }
        if (existingProjects == null) {
            ConnectToOnlineProjectDialog.$$$reportNull$$$0(2);
        }
        super(androidLibraryModule.getProject());
        this.setOkLabel(FirebaseBundle.message("ui.connect.dialog.action.button.connect.to.firebase", new Object[0]));
        this.setTitle(FirebaseBundle.message("ui.connect.input.panel.title", new Object[0]));
        this.myConnectPanel = new ConnectToOnlineProjectPanel(androidLibraryModule, firebaseConfig, existingProjects, tosUrl);
        this.addContentPanel((JComponent)((Object)this.myConnectPanel));
        this.isAcceptTos = tosUrl != null;
        this.myFirebaseConfig = firebaseConfig;
        this.init();
        this.pack();
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_CONNECT_DIALOG_OPENED).withProject(androidLibraryModule.getProject()).log();
    }

    private static Logger getLog() {
        return Logger.getInstance(ConnectToOnlineProjectPanel.class);
    }

    protected void doOKAction() {
        this.close(0);
        Project project = this.myConnectPanel.getAndroidModule().getProject();
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_CONNECT_DIALOG_SYNC).withProject(project).log();
        ConnectFirebaseTask task = this.myConnectPanel.isCreateMode() ? new ConnectFirebaseTask(this.myConnectPanel.getAndroidModule(), this.myFirebaseConfig, this.myConnectPanel.getNewProjectDisplayName(), this.myConnectPanel.getNewProjectCountryCode(), MobileSdkUtil.getCurrentTimeZoneId(), this.isAcceptTos) : new ConnectFirebaseTask(this.myConnectPanel.getAndroidModule(), this.myFirebaseConfig, this.myConnectPanel.getExistingProjectToConnect(), this.myConnectPanel.getNewProjectCountryCode(), MobileSdkUtil.getCurrentTimeZoneId(), this.isAcceptTos, this.myConnectPanel.getProjectDataSharingEnabled());
        FirebaseUiUtils.showInfoBalloon(project, FirebaseBundle.message("firebase.service.notification.connect.process.started", new Object[0]), null);
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        super.doValidate();
        ValidationInfo validateInfo = this.myConnectPanel.doValidate();
        if (validateInfo != null) {
            ConnectToOnlineProjectDialog.getLog().debug("Component didn't validate: " + validateInfo.component.getName());
        }
        return validateInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "androidLibraryModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "firebaseConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "existingProjects";
                break;
            }
        }
        objectArray[1] = "com/google/services/firebase/view/ConnectToOnlineProjectDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

