/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.android.tools.idea.assistant.view.UIUtils;
import com.google.api.client.util.Lists;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.DataSharingSetting;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.mobilesdk.CountryConstants;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.FirebaseDialog;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.services.firebase.view.LinkButton;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectToOnlineProjectPanel
extends JBPanel {
    private static final int PAD = 10;
    private static final int MAX_COPY_WIDTH = 500;
    private JBRadioButton myExistingProjectSelector;
    private JBRadioButton myCreateNewProjectSelector;
    private JBLabel myProjectCountryLabel;
    private JBList myExistingProjectSelectList;
    private JFormattedTextField myCreateProjectName;
    private GoogleLogin myGoogleLogin;
    private boolean myCreateMode;
    private Module myAndroidModule;
    private ComboBox myProjectCountry;
    private JPanel myDataSharingSmallPrintPanel;
    private JPanel myDataSharingCheckboxPanel;
    private JBCheckBox myProjectDataSharingSetting;
    private FirebaseConfig myFirebaseConfig;
    private static int myAppsDisplayOffset = 0;

    public ConnectToOnlineProjectPanel(@NotNull Module androidModule, @NotNull FirebaseConfig firebaseConfig, @NotNull Collection<OnlineProject> existingProjects, @Nullable URL tosUrl) throws IllegalStateException {
        if (androidModule == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(0);
        }
        if (firebaseConfig == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(1);
        }
        if (existingProjects == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(2);
        }
        this(GoogleLogin.getInstance(), androidModule, firebaseConfig, existingProjects, tosUrl);
    }

    ConnectToOnlineProjectPanel(@NotNull GoogleLogin googleLogin, @NotNull Module androidModule, @NotNull FirebaseConfig firebaseConfig, @NotNull Collection<OnlineProject> existingProjects, @Nullable URL tosUrl) throws IllegalStateException {
        if (googleLogin == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(3);
        }
        if (androidModule == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(4);
        }
        if (firebaseConfig == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(5);
        }
        if (existingProjects == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(6);
        }
        this.myCreateMode = true;
        this.setName(FirebaseBundle.message("ui.connect.input.panel.title", new Object[0]));
        if (!googleLogin.isConnected() || googleLogin.getActiveUser() == null) {
            throw new IllegalStateException(FirebaseBundle.message("firebaseService.userError.googleSignInRequired", new Object[0]));
        }
        this.myGoogleLogin = googleLogin;
        this.myAndroidModule = androidModule;
        this.myFirebaseConfig = firebaseConfig;
        Project project = androidModule.getProject();
        String projectName = MobileSdkUtil.getValidProjectName(project.getName());
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        ButtonGroup group = new ButtonGroup();
        JBPanel createLine = new JBPanel();
        createLine.setLayout((LayoutManager)new BoxLayout((Container)createLine, 0));
        createLine.setAlignmentX(0.0f);
        this.add((Component)createLine);
        createLine.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myCreateNewProjectSelector = new JBRadioButton(FirebaseBundle.message("ui.connect.input.panel.label.create.new.project.selector", new Object[0]));
        group.add((AbstractButton)this.myCreateNewProjectSelector);
        createLine.add((Component)this.myCreateNewProjectSelector);
        String standardBG = UIUtils.getCssColor((Color)UIUtils.getAsStandardBackgroundColor());
        int contentOffset = this.myCreateNewProjectSelector.getIconTextGap() + UIUtil.getRadioButtonIcon().getIconWidth() + FirebaseDialog.SIDE_INSET + 8;
        JEditorPane whatsThisLink = new JEditorPane();
        UIUtils.setHtml((JEditorPane)whatsThisLink, (String)FirebaseBundle.message("ui.connect.input.panel.action.buttons.more.info", new Object[0]), (String)("body { background-color: " + standardBG + "; margin: 0px 20px 0 5px; }"));
        whatsThisLink.setMaximumSize(new Dimension(Integer.MAX_VALUE, whatsThisLink.getFontMetrics(whatsThisLink.getFont()).getHeight()));
        createLine.add((Component)whatsThisLink);
        createLine.add(Box.createHorizontalGlue());
        JBLabel signinState = new JBLabel("<html>" + FirebaseBundle.message("ui.connect.input.panel.label.signed.in", googleLogin.getEmail() + "</html>"));
        signinState.setForeground(UIUtils.getSecondaryColor());
        signinState.setAlignmentX(1.0f);
        createLine.add((Component)signinState);
        LinkButton mySignOutButton = new LinkButton(FirebaseBundle.message("ui.connect.input.panel.action.buttons.sign.out", new Object[0]));
        mySignOutButton.setFont(mySignOutButton.getFont().deriveFont(11.0f));
        mySignOutButton.setAlignmentX(1.0f);
        createLine.add((Component)mySignOutButton);
        mySignOutButton.addActionListener(e -> this.myGoogleLogin.logOut(true));
        JPanel projectNameWrapper = new JPanel(new BorderLayout(0, 0));
        projectNameWrapper.setBorder(BorderFactory.createEmptyBorder(0, contentOffset, 10, FirebaseDialog.SIDE_INSET));
        this.myCreateProjectName = new JFormattedTextField();
        this.myCreateProjectName.setText(projectName);
        this.myCreateProjectName.setInputVerifier(new ProjectNameInputVerifier());
        projectNameWrapper.add(this.myCreateProjectName);
        projectNameWrapper.setAlignmentX(0.0f);
        this.add(projectNameWrapper);
        JPanel existingProjectWrapper = new JPanel(new BorderLayout(0, 0));
        existingProjectWrapper.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myExistingProjectSelector = new JBRadioButton(FirebaseBundle.message("ui.connect.input.panel.label.choose.existing.project.selector", new Object[0]));
        group.add((AbstractButton)this.myExistingProjectSelector);
        this.myCreateNewProjectSelector.setSelected(true);
        existingProjectWrapper.add((Component)this.myExistingProjectSelector);
        existingProjectWrapper.setAlignmentX(0.0f);
        this.add(existingProjectWrapper);
        myAppsDisplayOffset = existingProjects.stream().map(OnlineProject::getDisplayName).map(String::length).max(Integer::compare).orElse(0) + 5;
        JPanel existingProjectListWrapper = new JPanel(new BorderLayout(0, 0));
        existingProjectListWrapper.setBorder(BorderFactory.createEmptyBorder(0, contentOffset, 10, FirebaseDialog.SIDE_INSET));
        existingProjectListWrapper.setAlignmentX(0.0f);
        this.myExistingProjectSelectList = new JBList((ListModel)((Object)new OnlineProjectModel(existingProjects)));
        this.myExistingProjectSelectList.setCellRenderer((ListCellRenderer)new OnlineProjectRenderer());
        this.myExistingProjectSelectList.setEmptyText(FirebaseBundle.message("ui.connect.input.panel.validation.project.not.selected", new Object[0]));
        this.myExistingProjectSelectList.addListSelectionListener(e -> {
            this.updateCountryDisplay();
            this.updateProjectSharingDisplay();
        });
        JBScrollPane projectScroller = new JBScrollPane((Component)this.myExistingProjectSelectList);
        existingProjectListWrapper.add((Component)projectScroller);
        this.add(existingProjectListWrapper);
        JBPanel countryLine = new JBPanel();
        countryLine.setLayout((LayoutManager)new BoxLayout((Container)countryLine, 0));
        this.add((Component)countryLine);
        countryLine.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myProjectCountryLabel = new JBLabel(FirebaseBundle.message("ui.connect.input.panel.label.country", new Object[0]));
        countryLine.add((Component)this.myProjectCountryLabel);
        JEditorPane whyCountryLink = new JEditorPane();
        UIUtils.setHtml((JEditorPane)whyCountryLink, (String)FirebaseBundle.message("ui.connect.input.panel.label.country.moreInfo", new Object[0]), (String)("body { background-color: " + standardBG + "; margin: 0 0 0 13px; }"));
        whyCountryLink.setMaximumSize(new Dimension(Integer.MAX_VALUE, whyCountryLink.getFontMetrics(whyCountryLink.getFont()).getHeight()));
        countryLine.add((Component)whyCountryLink);
        JPanel countryWrapper = new JPanel(new BorderLayout(0, 0));
        countryWrapper.setBorder(BorderFactory.createEmptyBorder(0, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myProjectCountry = ConnectToOnlineProjectPanel.createCountryComboBox();
        countryWrapper.add((Component)this.myProjectCountry);
        countryWrapper.setAlignmentX(0.0f);
        this.add(countryWrapper);
        this.myDataSharingCheckboxPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        this.myDataSharingCheckboxPanel.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        JPanel subPanel = new JPanel((LayoutManager)new HorizontalLayout(0, 0));
        this.myProjectDataSharingSetting = new JBCheckBox();
        this.myProjectDataSharingSetting.setEnabled(true);
        JEditorPane checkboxLabel = new JEditorPane();
        UIUtils.setHtml((JEditorPane)checkboxLabel, (String)FirebaseBundle.message("ui.connect.dialog.dataSharing", new Object[0]), (String)("body { background-color: " + standardBG + "; padding-top: 15px; font-size: 11px; color: " + UIUtils.getCssColor((Color)UIUtils.getSecondaryColor()) + "; width: " + 500 + "px; }"));
        checkboxLabel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        checkboxLabel.setOpaque(true);
        checkboxLabel.setBackground(UIUtils.getAsStandardBackgroundColor());
        subPanel.add((Component)this.myProjectDataSharingSetting);
        subPanel.add(checkboxLabel);
        this.myDataSharingCheckboxPanel.add(subPanel);
        this.myDataSharingCheckboxPanel.setAlignmentX(0.0f);
        this.add(this.myDataSharingCheckboxPanel);
        this.myDataSharingSmallPrintPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        this.myDataSharingSmallPrintPanel.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myDataSharingSmallPrintPanel.setAlignmentX(0.0f);
        JEditorPane smallPrint = new JEditorPane();
        this.myDataSharingSmallPrintPanel.add(smallPrint);
        UIUtils.setHtml((JEditorPane)smallPrint, (String)FirebaseBundle.message("ui.connect.dialog.smallPrint", new Object[0]), (String)("body { background-color: " + standardBG + "; padding-top: 15px; font-size: 11px; color: " + UIUtils.getCssColor((Color)UIUtils.getSecondaryColor()) + "; width: " + 500 + "px; }"));
        smallPrint.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        smallPrint.setOpaque(true);
        smallPrint.setBackground(UIUtils.getAsStandardBackgroundColor());
        this.add(this.myDataSharingSmallPrintPanel);
        if (tosUrl != null) {
            JPanel tosWrapper = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
            tosWrapper.setBorder(BorderFactory.createEmptyBorder(0, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
            tosWrapper.setAlignmentX(0.0f);
            JEditorPane tos = new JEditorPane();
            tosWrapper.add(tos);
            UIUtils.setHtml((JEditorPane)tos, (String)FirebaseBundle.message("ui.tosCopy", tosUrl.toString()), (String)("body { background-color: " + standardBG + "; width: " + 500 + "px; padding-top: 10px; font-size: 11px; color: " + UIUtils.getCssColor((Color)UIUtils.getSecondaryColor()) + "; } .important { color: " + UIUtils.getCssColor((Color)tosWrapper.getForeground()) + " }"));
            tos.setOpaque(true);
            tos.setBackground(UIUtils.getAsStandardBackgroundColor());
            this.add(tosWrapper);
        }
        this.enableCreateProjectMode(true);
        try {
            if (this.myGoogleLogin.fetchOAuth2Token() == null) {
                FirebaseUiUtils.showTrackedErrorBalloon(project, null, "firebaseService.internalError.couldNotVerifySignIn", new Object[0]);
            }
        }
        catch (IOException exception) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, exception, "firebaseService.internalError.couldNotVerifySignIn", new Object[0]);
        }
        this.initializeRadioButtonActionListeners();
    }

    @NotNull
    public Module getAndroidModule() {
        Module module = this.myAndroidModule;
        if (module == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(7);
        }
        return module;
    }

    public boolean isCreateMode() {
        return this.myCreateMode;
    }

    @NotNull
    public String getNewProjectDisplayName() {
        if (!this.isCreateMode()) {
            throw new IllegalStateException("Panel is not in create mode");
        }
        String string = this.myCreateProjectName.getText();
        if (string == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getNewProjectCountryCode() {
        String string = ConnectToOnlineProjectPanel.getCountryCode(this.myProjectCountry);
        if (string == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getCountryCode(@NotNull ComboBox comboBox) {
        if (comboBox == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(10);
        }
        String selectedItem = comboBox.getSelectedItem().toString();
        String selectedKey = null;
        for (String key : CountryConstants.COUNTRY_MAP.keySet()) {
            if (!((String)CountryConstants.COUNTRY_MAP.get((Object)key)).equals(selectedItem)) continue;
            selectedKey = key;
        }
        String string = selectedKey == null ? "US" : selectedKey;
        if (string == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static ComboBox createCountryComboBox() {
        ArrayList countries = new ArrayList(CountryConstants.COUNTRY_MAP.values());
        Collections.sort(countries);
        String defaultValue = (String)CountryConstants.COUNTRY_MAP.get((Object)MobileSdkUtil.getRegionCode());
        if (defaultValue == null) {
            defaultValue = "United States";
        }
        int defaultIndex = countries.indexOf(defaultValue);
        ComboBox comboBox = new ComboBox((Object[])countries.toArray(new String[countries.size()]));
        comboBox.setSelectedIndex(defaultIndex);
        comboBox.setBackground(UIUtils.getBackgroundColor());
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(12);
        }
        return comboBox2;
    }

    @NotNull
    public OnlineProject getExistingProjectToConnect() {
        if (this.isCreateMode()) {
            throw new IllegalStateException("Panel is in create mode");
        }
        OnlineProject onlineProject = (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
        if (onlineProject == null) {
            ConnectToOnlineProjectPanel.$$$reportNull$$$0(13);
        }
        return onlineProject;
    }

    public DataSharingSetting getProjectDataSharingEnabled() {
        return DataSharingSetting.fromCheckbox(this.myProjectDataSharingSetting);
    }

    private void initializeRadioButtonActionListeners() {
        this.myExistingProjectSelector.addActionListener(e -> this.enableCreateProjectMode(false));
        this.myCreateNewProjectSelector.addActionListener(e -> this.enableCreateProjectMode(true));
    }

    private void enableCreateProjectMode(boolean createMode) {
        this.myCreateMode = createMode;
        this.myCreateProjectName.setEnabled(createMode);
        this.myExistingProjectSelectList.setEnabled(!createMode);
        this.updateCountryDisplay();
        this.updateProjectSharingDisplay();
    }

    private void updateCountryDisplay() {
        boolean show = this.myCreateNewProjectSelector.isSelected();
        if (!show) {
            OnlineProject selected = (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
            show = selected == null || selected.isRequiredFirebaseMigration();
        }
        this.myProjectCountry.setVisible(show);
        this.myProjectCountryLabel.setVisible(show);
    }

    private void updateProjectSharingDisplay() {
        Boolean showProjectSharingCheckbox = false;
        this.myProjectDataSharingSetting.setSelected(true);
        if (this.myCreateNewProjectSelector.isSelected()) {
            showProjectSharingCheckbox = false;
        } else {
            OnlineProject selectedProject = (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
            if (selectedProject != null) {
                showProjectSharingCheckbox = selectedProject.shouldShowProjectDataSharingSetting();
            }
        }
        this.myDataSharingCheckboxPanel.setVisible(showProjectSharingCheckbox);
        this.myDataSharingSmallPrintPanel.setVisible(showProjectSharingCheckbox == false);
    }

    @Nullable
    public ValidationInfo doValidate() {
        if (this.myCreateMode) {
            String newProjectName = this.myCreateProjectName.getText();
            boolean isValidProjectName = MobileSdkUtil.isValidProjectName(newProjectName);
            if (!isValidProjectName) {
                return new ValidationInfo(FirebaseBundle.message("ui.connect.input.panel.validation.invalid.project.display.name", new Object[0]), (JComponent)this.myCreateProjectName);
            }
        } else {
            boolean needToAddAndroidAuthClients;
            OnlineProject selected = (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
            if (selected == null) {
                return new ValidationInfo(FirebaseBundle.message("ui.connect.input.panel.validation.project.not.selected", new Object[0]), (JComponent)this.myExistingProjectSelectList);
            }
            boolean bl = needToAddAndroidAuthClients = !this.myFirebaseConfig.getRegisterableAndroidClients().isEmpty();
            if ((selected.isRequiredFirebaseMigration() || needToAddAndroidAuthClients) && !selected.isEditable()) {
                return new ValidationInfo(FirebaseBundle.message("connectDialog.validationError.noEditRightsToProject", new Object[0]), (JComponent)this.myExistingProjectSelectList);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModule";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firebaseConfig";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingProjects";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "googleLogin";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/firebase/view/ConnectToOnlineProjectPanel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/firebase/view/ConnectToOnlineProjectPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewProjectDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewProjectCountryCode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCountryCode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCountryComboBox";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingProjectToConnect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCountryCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OnlineProjectRenderer
    extends DefaultListCellRenderer {
        private OnlineProjectRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(@NotNull JList list, @NotNull Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null) {
                OnlineProjectRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                OnlineProjectRenderer.$$$reportNull$$$0(1);
            }
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setFont(new Font("Monospaced", 0, this.getFont().getSize()));
            OnlineProject project = (OnlineProject)value;
            int numAndroidApps = project.getAndroidFirebaseClientSummaries().size();
            int numIosApps = project.getNumIosApps();
            StringBuilder sb = new StringBuilder();
            boolean hasApps = numAndroidApps > 0 || numIosApps > 0;
            String displayName = project.getDisplayName();
            if (hasApps) {
                sb.append(String.format("%-" + myAppsDisplayOffset + "s", displayName));
            } else {
                sb.append(displayName);
            }
            if (numAndroidApps > 0) {
                sb.append(FirebaseBundle.message("ui.connect.dialog.numAndroidApps", numAndroidApps));
            }
            if (numIosApps > 0) {
                if (numAndroidApps > 0) {
                    sb.append(", ");
                }
                sb.append(FirebaseBundle.message("ui.connect.dialog.numIosApps", numIosApps));
            }
            this.setText(sb.toString());
            return comp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/google/services/firebase/view/ConnectToOnlineProjectPanel$OnlineProjectRenderer";
            objectArray[2] = "getListCellRendererComponent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OnlineProjectModel
    extends CollectionListModel<OnlineProject> {
        final List<OnlineProject> projects;
        private final Collection<OnlineProject> myExistingProjects;

        public OnlineProjectModel(@NotNull Collection<OnlineProject> existingProjects) {
            if (existingProjects == null) {
                OnlineProjectModel.$$$reportNull$$$0(0);
            }
            super((Object[])new OnlineProject[0]);
            this.myExistingProjects = existingProjects;
            this.projects = Lists.newArrayList(this.myExistingProjects);
        }

        public int getSize() {
            return this.projects == null ? 0 : this.projects.size();
        }

        public OnlineProject getElementAt(int index) {
            return this.projects.get(index);
        }

        public void addListDataListener(@NotNull ListDataListener l) {
            if (l == null) {
                OnlineProjectModel.$$$reportNull$$$0(1);
            }
        }

        public void removeListDataListener(@NotNull ListDataListener l) {
            if (l == null) {
                OnlineProjectModel.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingProjects";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "l";
                    break;
                }
            }
            objectArray2[1] = "com/google/services/firebase/view/ConnectToOnlineProjectPanel$OnlineProjectModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListDataListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListDataListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProjectNameInputVerifier
    extends InputVerifier {
        private ProjectNameInputVerifier() {
        }

        @Override
        public boolean verify(@NotNull JComponent input) {
            boolean valid;
            JFormattedTextField textField;
            if (input == null) {
                ProjectNameInputVerifier.$$$reportNull$$$0(0);
            }
            textField.setForeground((valid = MobileSdkUtil.isValidProjectName((textField = (JFormattedTextField)input).getText())) ? UIUtils.getSuccessColor() : UIUtils.getFailureColor());
            return valid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/google/services/firebase/view/ConnectToOnlineProjectPanel$ProjectNameInputVerifier", "verify"));
        }
    }
}

