/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.project.AndroidNotification;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseBundle;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.FirebaseErrorDetails;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseUiUtils {
    public static final String TOS_ENGLISH_LANGUAGE_TAG = "en-US";
    public static final String FIREBASE_NOTIFICATION_TITLE = FirebaseBundle.message("firebase.service.notification.title", new Object[0]);
    public static final String FIREBASE_CONFIG_JSON_FILE_NAME = "google-services.json";

    public static void showWarningBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        if (project == null) {
            FirebaseUiUtils.$$$reportNull$$$0(0);
        }
        if (message == null) {
            FirebaseUiUtils.$$$reportNull$$$0(1);
        }
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.WARNING);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void showTrackedErrorBalloon(@NotNull Project project, @Nullable Throwable throwable, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
        if (project == null) {
            FirebaseUiUtils.$$$reportNull$$$0(2);
        }
        if (messageKey == null) {
            FirebaseUiUtils.$$$reportNull$$$0(3);
        }
        if (messageArguments == null) {
            FirebaseUiUtils.$$$reportNull$$$0(4);
        }
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_ERROR_PRESENTED).withProject(project).withErrorDetails(FirebaseErrorDetails.newBuilder().setErrorMessage(messageKey)).log();
        String message = FirebaseBundle.message(messageKey, messageArguments);
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.ERROR);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void logSilentError(@NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey) {
        if (messageKey == null) {
            FirebaseUiUtils.$$$reportNull$$$0(5);
        }
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_SILENT_ERROR).withErrorDetails(FirebaseErrorDetails.newBuilder().setErrorMessage(messageKey)).log();
    }

    public static void showErrorBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        if (project == null) {
            FirebaseUiUtils.$$$reportNull$$$0(6);
        }
        if (message == null) {
            FirebaseUiUtils.$$$reportNull$$$0(7);
        }
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.ERROR);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void showInfoBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        if (project == null) {
            FirebaseUiUtils.$$$reportNull$$$0(8);
        }
        if (message == null) {
            FirebaseUiUtils.$$$reportNull$$$0(9);
        }
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.INFORMATION);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseUiUtils.class);
    }

    public static void checkGradleState(@NotNull Module androidModule) throws GradleStateException {
        AndroidModuleModel androidModuleModel;
        if (androidModule == null) {
            FirebaseUiUtils.$$$reportNull$$$0(10);
        }
        if ((androidModuleModel = AndroidModuleModel.get((Module)androidModule)) == null) {
            throw new GradleStateException("Android Gradle Model not found.");
        }
        if (androidModuleModel.getSyncIssues() != null && !androidModuleModel.getSyncIssues().isEmpty()) {
            throw new GradleStateException("Android Gradle sync issues are not fully resolved");
        }
        if (GradleSyncState.getInstance((Project)androidModule.getProject()).isSyncNeeded().equals((Object)ThreeState.YES)) {
            throw new GradleStateException("Gradle sync needs to be performed.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageArguments";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModule";
                break;
            }
        }
        objectArray2[1] = "com/google/services/firebase/view/FirebaseUiUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showWarningBalloon";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showTrackedErrorBalloon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logSilentError";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorBalloon";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showInfoBalloon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkGradleState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class GradleStateException
    extends Exception {
        GradleStateException(String message) {
            super(message);
        }
    }
}

