/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.ui;

import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class MatrixControlBuilder {
    private final DefaultTableModel myModel;
    private final JBTable myTable;
    private final JComponent myResult;
    private final int[] myColumnWidths;
    private final FontMetrics myFontMetrics;

    public MatrixControlBuilder(String ... columns) {
        int i;
        if (columns == null) {
            MatrixControlBuilder.$$$reportNull$$$0(0);
        }
        this.myModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.myModel.addColumn("");
        for (String string : columns) {
            this.myModel.addColumn(string);
        }
        this.myTable = new JBTable(this.myModel){

            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        this.myTable.setFocusable(false);
        this.myTable.setStriped(true);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        int max = this.myTable.getColumnCount();
        for (i = 0; i < max; ++i) {
            TableCellRenderer headerRenderer;
            TableColumn tableColumn = this.myTable.getColumnModel().getColumn(i);
            if (i > 0) {
                tableColumn.setCellRenderer(renderer);
            }
            if (!((headerRenderer = tableColumn.getHeaderRenderer()) instanceof JLabel)) continue;
            ((JLabel)((Object)headerRenderer)).setHorizontalAlignment(0);
        }
        this.myResult = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        this.myColumnWidths = new int[columns.length + 1];
        this.myFontMetrics = this.myTable.getFontMetrics(this.myTable.getFont());
        for (i = 0; i < columns.length; ++i) {
            this.myColumnWidths[i + 1] = this.myFontMetrics.stringWidth(columns[i]);
        }
    }

    public void addRow(@NotNull String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            MatrixControlBuilder.$$$reportNull$$$0(1);
        }
        if (values == null) {
            MatrixControlBuilder.$$$reportNull$$$0(2);
        }
        if (values.length != this.myModel.getColumnCount() - 1) {
            StringBuilder columns = new StringBuilder();
            int max = this.myModel.getColumnCount();
            for (int i = 1; i < max; ++i) {
                columns.append(this.myModel.getColumnName(i)).append(", ");
            }
            if (columns.length() > 2) {
                columns.setLength(columns.length() - 2);
            }
            throw new IllegalArgumentException(String.format("Can't add row '%s' to the matrix control. Reason: the row specifies incorrect number of values (%d, expected %d). Registered columns: %s. Given values: %s", name, values.length, this.myModel.getColumnCount() - 1, columns, Arrays.toString(values)));
        }
        Object[] rowData = new Object[values.length + 1];
        rowData[0] = name;
        System.arraycopy(values, 0, rowData, 1, values.length);
        this.myModel.addRow(rowData);
        for (int i = 0; i < rowData.length; ++i) {
            this.myColumnWidths[i] = Math.max(this.myFontMetrics.stringWidth(rowData[i].toString()), this.myColumnWidths[i]);
        }
    }

    @NotNull
    public JComponent build() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int i = 0; i < this.myColumnWidths.length; ++i) {
            columnModel.getColumn(i).setMinWidth(this.myColumnWidths[i] + 4);
        }
        JComponent jComponent = this.myResult;
        if (jComponent == null) {
            MatrixControlBuilder.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/ui/MatrixControlBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/ui/MatrixControlBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

