/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RecursionManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.RecursionManager");
    private static final Object NULL = new Object();
    private static final ThreadLocal<CalculationStack> ourStack = new ThreadLocal<CalculationStack>(){

        @Override
        protected CalculationStack initialValue() {
            return new CalculationStack(null);
        }
    };

    public static RecursionGuard createGuard(final @NonNls String id) {
        return new RecursionGuard(){

            @Override
            @NotNull
            public RecursionGuard.StackStamp markStack() {
                final int stamp = ((CalculationStack)ourStack.get()).reentrancyCount;
                RecursionGuard.StackStamp stackStamp = new RecursionGuard.StackStamp(){

                    @Override
                    public boolean mayCacheNow() {
                        return stamp == ((CalculationStack)ourStack.get()).reentrancyCount;
                    }
                };
                if (stackStamp == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/RecursionManager$2", "markStack"));
                }
                return stackStamp;
            }
        };
    }

    private static class CalculationStack {
        private int reentrancyCount;
    }
}

