/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.EmptyIterator;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtilRt {
    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            ArrayList arrayList = new ArrayList(collection);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
            }
            return arrayList;
        }
        ArrayList<T> arrayList = ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        return c;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "emptyList"));
        }
        return emptyList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "iterator"));
            }
            return emptyIterator;
        }
    }
}

