/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.model.NativeLibraryImpl;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.model.NativeLibrary;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.gradle.api.Project;

public class NativeLibraryFactoryImpl
implements NativeLibraryFactory {
    final NdkHandler ndkHandler;

    public NativeLibraryFactoryImpl(NdkHandler ndkHandler) {
        this.ndkHandler = ndkHandler;
    }

    public Optional<NativeLibrary> create(VariantScope scope, String toolchainName, Abi abi) {
        BaseVariantData variantData = scope.getVariantData();
        if (!AndroidGradleOptions.useDeprecatedNdk((Project)scope.getGlobalScope().getProject())) {
            return Optional.empty();
        }
        CoreNdkOptions ndkConfig = variantData.getVariantConfiguration().getNdkConfig();
        String sysrootFlag = "--sysroot=" + this.ndkHandler.getSysroot(abi);
        ImmutableList cFlags = ndkConfig.getcFlags() == null ? ImmutableList.of((Object)sysrootFlag) : ImmutableList.of((Object)sysrootFlag, (Object)ndkConfig.getcFlags());
        return Optional.of(new NativeLibraryImpl(ndkConfig.getModuleName(), toolchainName, abi.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.ndkHandler.getStlNativeToolSpecification(Stl.getById((String)ndkConfig.getStl()), null, abi).getIncludes(), Collections.emptyList(), Collections.emptyList(), (List)cFlags, (List)cFlags, (List)ImmutableList.of((Object)scope.getNdkDebuggableLibraryFolders(abi))));
    }
}

