/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import com.appspot.cluestick_server.search.model.CodeResult;
import com.appspot.cluestick_server.search.model.Result;
import com.appspot.cluestick_server.search.model.ResultContext;
import com.google.devrel.cluestick.searchservice.EventLog;
import com.google.devrel.cluestick.studioclient.Browser;
import com.google.devrel.cluestick.studioclient.ResultUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CodeBrowser
extends JPanel
implements Browser,
Disposable {
    private static final Color HIGHLIGHT_BACKGROUND = UIUtil.getTreeUnfocusedSelectionBackground();
    private static final TextAttributes HIGHLIGHT_ATTRIBUTES = new TextAttributes(null, HIGHLIGHT_BACKGROUND, null, EffectType.SEARCH_MATCH, 1);
    private static final Pattern WHITESPACE_PREFIX = Pattern.compile("^\\s*");
    private final EventLog eventLog;
    private final EditorEx editor;
    private final Document document;
    private final Project project;
    private final EditorHighlighterFactory highlighterFactory;
    private Result result;

    public CodeBrowser(@NotNull Project project, @NotNull EventLog eventLog) {
        if (project == null) {
            CodeBrowser.$$$reportNull$$$0(0);
        }
        if (eventLog == null) {
            CodeBrowser.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.project = project;
        this.eventLog = eventLog;
        this.highlighterFactory = EditorHighlighterFactory.getInstance();
        EditorFactory factory = EditorFactory.getInstance();
        this.document = factory.createDocument((CharSequence)"");
        this.editor = (EditorEx)factory.createViewer(this.document, project);
        EditorSettings settings = this.editor.getSettings();
        settings.setLineNumbersShown(true);
        settings.setAnimatedScrolling(false);
        settings.setRefrainFromScrolling(true);
        EditorGutterComponentEx gutter = this.editor.getGutterComponentEx();
        gutter.setShowDefaultGutterPopup(false);
        gutter.revalidateMarkup();
        this.editor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                TextRange range = e.getNewRange();
                if (range.isEmpty()) {
                    return;
                }
                CodeBrowser.this.eventLog.logEvent("select", CodeBrowser.this.getResultKey(), 0);
            }
        });
        JComponent component = this.editor.getComponent();
        component.setPreferredSize(new Dimension(0, 0));
        this.add((Component)component, "Center");
    }

    public void dispose() {
        EditorFactory factory = EditorFactory.getInstance();
        factory.releaseEditor((Editor)this.editor);
    }

    @Override
    public void showEmpty() {
        this.result = null;
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CodeBrowser.this.document.setText((CharSequence)"");
            }
        });
    }

    @Override
    public void showResult(Result result) {
        if (result == null || result.getCode() == null) {
            this.showEmpty();
            return;
        }
        this.result = result;
        CodeResult code = result.getCode();
        ArrayList<CharSequence> lines = new ArrayList<CharSequence>();
        int scrollTo = -1;
        ArrayList<Integer> highlightLines = new ArrayList<Integer>();
        List<ResultContext> allContext = code.getContext();
        if (allContext != null && !allContext.isEmpty()) {
            boolean containsSnippets = allContext.size() != 1 || allContext.get(0).getStartAt() != 1;
            for (ResultContext context : allContext) {
                List<String> src = context.getSrc();
                if (src == null || src.isEmpty()) continue;
                src = CodeBrowser.formatCode(src);
                if (!containsSnippets) {
                    if (scrollTo == -1 && !context.getResultsAt().isEmpty()) {
                        scrollTo = context.getResultsAt().get(0);
                    }
                    for (int line : context.getResultsAt()) {
                        highlightLines.add(line - 1);
                    }
                    lines.addAll(CodeBrowser.formatCode(src));
                    continue;
                }
                StringBuilder dividerBuilder = new StringBuilder();
                int startAt = context.getStartAt();
                int endAt = startAt + src.size() - 1;
                if (endAt == startAt) {
                    dividerBuilder.append("// Line ").append(startAt);
                } else {
                    dividerBuilder.append(String.format("// Lines %d-%d", startAt, endAt));
                    String resultsAt = StringUtil.join(context.getResultsAt(), (String)", ");
                    if (!StringUtil.isEmpty((String)resultsAt)) {
                        dividerBuilder.append(" (").append(resultsAt).append(')');
                    }
                }
                lines.add(dividerBuilder);
                for (int line : context.getResultsAt()) {
                    highlightLines.add(lines.size() + line - context.getStartAt());
                }
                lines.addAll(CodeBrowser.formatCode(src));
                lines.add("");
            }
        }
        if (scrollTo < 1) {
            scrollTo = 1;
        }
        LogicalPosition position = new LogicalPosition(scrollTo - 1, 0);
        this.setText(lines, position, highlightLines);
        String path = ResultUtils.getBaseName(code.getPath());
        this.editor.setHighlighter(this.highlighterFactory.createEditorHighlighter(this.project, path));
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Nullable
    private String getResultKey() {
        if (this.result != null) {
            return this.result.getKey();
        }
        return null;
    }

    private void setText(@NotNull List<? extends CharSequence> lines, final @NotNull LogicalPosition position, final @NotNull List<Integer> highlight) {
        if (lines == null) {
            CodeBrowser.$$$reportNull$$$0(2);
        }
        if (position == null) {
            CodeBrowser.$$$reportNull$$$0(3);
        }
        if (highlight == null) {
            CodeBrowser.$$$reportNull$$$0(4);
        }
        MarkupModelEx markup = this.editor.getMarkupModel();
        markup.removeAllHighlighters();
        final StringBuilder text = new StringBuilder();
        for (CharSequence charSequence : lines) {
            text.append(charSequence).append('\n');
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable((MarkupModel)markup){
            final /* synthetic */ MarkupModel val$markup;
            {
                this.val$markup = markupModel;
            }

            @Override
            public void run() {
                CodeBrowser.this.document.setText((CharSequence)text);
                CodeBrowser.this.editor.getCaretModel().moveToLogicalPosition(position);
                CodeBrowser.this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                int layer = 5999;
                Iterator iterator = highlight.iterator();
                while (iterator.hasNext()) {
                    int line = (Integer)iterator.next();
                    this.val$markup.addLineHighlighter(line, layer, HIGHLIGHT_ATTRIBUTES);
                }
                CodeBrowser.this.editor.getGutterComponentEx().revalidateMarkup();
            }
        });
    }

    @NotNull
    public static List<String> formatCode(@NotNull List<String> input) {
        if (input == null) {
            CodeBrowser.$$$reportNull$$$0(5);
        }
        boolean knownPrefix = false;
        String prefix = "";
        for (String line : input) {
            int j;
            Matcher m = WHITESPACE_PREFIX.matcher(line);
            if (!m.find()) {
                throw new IllegalStateException("empty regex should always match");
            }
            if (m.hitEnd()) continue;
            String localPrefix = line.substring(0, m.end());
            if (!knownPrefix) {
                prefix = localPrefix;
                knownPrefix = true;
                continue;
            }
            int len = Math.min(prefix.length(), localPrefix.length());
            for (j = 0; j < len && prefix.charAt(j) == localPrefix.charAt(j); ++j) {
            }
            prefix = prefix.substring(0, j);
        }
        if (prefix.isEmpty()) {
            List<String> list = input;
            if (list == null) {
                CodeBrowser.$$$reportNull$$$0(6);
            }
            return list;
        }
        int plen = prefix.length();
        ArrayList<String> output = new ArrayList<String>(input.size());
        for (String src : input) {
            if (src.length() < plen) {
                output.add("");
                continue;
            }
            output.add(src.substring(plen));
        }
        ArrayList<String> arrayList = output;
        if (arrayList == null) {
            CodeBrowser.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/devrel/cluestick/studioclient/CodeBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/devrel/cluestick/studioclient/CodeBrowser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatCode";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

