/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import com.appspot.cluestick_server.search.model.CodeResult;
import com.appspot.cluestick_server.search.model.Result;
import com.google.devrel.cluestick.studioclient.IconFetcher;
import com.google.devrel.cluestick.studioclient.ResultUtils;
import com.google.devrel.cluestick.studioclient.SearchResultsNode;
import com.google.devrel.cluestick.studioclient.Symbol;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public final class SearchResultsTree
extends Tree {
    private static final SimpleTextAttributes SUFFIX_ATTRIBUTES = new SimpleTextAttributes(2, UIUtil.getInactiveTextColor());
    private final LayoutNode symbolHeading;
    private final LayoutNode resultHeading;

    public SearchResultsTree(Symbol symbol, List<Result> results) {
        super((TreeNode)new DefaultMutableTreeNode());
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.setRootVisible(false);
        this.setCellRenderer((TreeCellRenderer)((Object)new CellRenderer()));
        this.symbolHeading = new LayoutNode();
        this.symbolHeading.text = "Symbol";
        this.symbolHeading.isHeading = true;
        top.add(this.symbolHeading);
        LayoutNode symbolNode = new LayoutNode();
        if (symbol.packageName != null && !symbol.packageName.isEmpty()) {
            symbolNode.prefix = symbol.packageName + ".";
        }
        symbolNode.icon = AllIcons.Nodes.EjbFinderMethod;
        symbolNode.text = symbol.symbolName;
        this.symbolHeading.add(symbolNode);
        this.resultHeading = new LayoutNode();
        this.resultHeading.text = "Found results";
        this.resultHeading.count = results.size();
        this.resultHeading.isHeading = true;
        top.add(this.resultHeading);
        this.addResults(this.resultHeading, results);
    }

    public static boolean hasCode(Result result) {
        return result.getCode() != null && result.getCode().getLines() != null;
    }

    private void addResults(DefaultMutableTreeNode parent, List<Result> results) {
        LinkedHashMap<String, RepoNode> repoNodes = new LinkedHashMap<String, RepoNode>();
        for (Result result : results) {
            if (!SearchResultsTree.hasCode(result)) {
                parent.add(new ResultNode(result));
                continue;
            }
            CodeResult code = result.getCode();
            String key = String.format("%s:%s", code.getRepo(), code.getBranch());
            RepoNode repoNode = (RepoNode)repoNodes.get(key);
            if (repoNode == null) {
                repoNode = new RepoNode(code.getRepo(), code.getBranch());
                repoNodes.put(key, repoNode);
            }
            repoNode.add(new ResultNode(result));
        }
        for (RepoNode repoNode : repoNodes.values()) {
            parent.add(repoNode);
        }
    }

    private static class CellRenderer
    extends ColoredTreeCellRenderer {
        private CellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof LayoutNode) {
                LayoutNode node = (LayoutNode)value;
                this.setIcon(node.icon);
                if (node.prefix != null) {
                    this.append(node.prefix, SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
                }
                SimpleTextAttributes defaultAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (node.isHeading) {
                    defaultAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                }
                this.append(node.getText(), defaultAttributes, true);
                if (node.suffix != null) {
                    this.append(" " + node.suffix, SUFFIX_ATTRIBUTES, false);
                }
                if (node.count >= 0) {
                    String format = " (%d result" + (node.count != 1 ? "s" : "") + ")";
                    this.append(String.format(format, node.count), SUFFIX_ATTRIBUTES, false);
                }
                return;
            }
            if (value instanceof RepoNode) {
                RepoNode node = (RepoNode)value;
                this.setIcon(node.getIcon());
                String prefix = node.getPrefix();
                if (prefix != null) {
                    this.append(prefix, SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
                }
                this.append(node.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                String suffix = node.getSuffix();
                if (suffix != null) {
                    this.append(" " + suffix, SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
                }
                return;
            }
            if (value instanceof ResultNode) {
                ResultNode node = (ResultNode)value;
                Result result = node.getSearchResult();
                if (!SearchResultsTree.hasCode(result)) {
                    this.setIcon(AllIcons.Actions.CreateFromUsage);
                    this.append(result.getText());
                    return;
                }
                this.setIcon(AllIcons.Actions.EditSource);
                String baseName = ResultUtils.getBaseName(result.getCode().getPath());
                this.append(baseName, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
                int count = result.getCode().getLines().size();
                String format = " (%d result" + (count != 1 ? "s" : "") + ")";
                this.append(String.format(format, count), SUFFIX_ATTRIBUTES, false);
                return;
            }
            this.append(value.toString());
        }
    }

    public static class ResultNode
    extends DefaultMutableTreeNode
    implements SearchResultsNode {
        public ResultNode(Result result) {
            super((Object)result);
        }

        @Override
        public String getURL() {
            return this.getSearchResult().getUrl();
        }

        @Override
        public Result getSearchResult() {
            return (Result)((Object)this.getUserObject());
        }
    }

    private static class LayoutNode
    extends DefaultMutableTreeNode {
        String prefix;
        String suffix;
        String text;
        Icon icon;
        boolean isHeading;
        int count = -1;

        private LayoutNode() {
        }

        @NotNull
        public String getText() {
            if (this.text == null) {
                if ("?" == null) {
                    LayoutNode.$$$reportNull$$$0(0);
                }
                return "?";
            }
            String string = this.text;
            if (string == null) {
                LayoutNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/devrel/cluestick/studioclient/SearchResultsTree$LayoutNode", "getText"));
        }
    }

    private static class RepoNode
    extends DefaultMutableTreeNode
    implements SearchResultsNode {
        private final String repo;
        private final String branch;
        private final ResultUtils.GitHubInfo info;

        RepoNode(String repo, String branch) {
            this.repo = repo;
            this.branch = branch;
            this.info = ResultUtils.parseRepoName(repo);
        }

        public Icon getIcon() {
            if (this.info != null) {
                return IconFetcher.GitHub;
            }
            return null;
        }

        public String getSuffix() {
            if (this.branch == null || this.branch.isEmpty() || this.branch.equals("master")) {
                return null;
            }
            return this.branch;
        }

        public String getPrefix() {
            if (this.info != null) {
                return this.info.user + "/";
            }
            return null;
        }

        @Override
        public String getURL() {
            if (this.info != null) {
                return String.format("https://github.com/%s/%s", this.info.user, this.info.repo);
            }
            return null;
        }

        @Override
        public Result getSearchResult() {
            return null;
        }

        @Override
        public String toString() {
            if (this.info != null) {
                return this.info.repo;
            }
            return this.repo;
        }
    }
}

