/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import java.util.List;
import java.util.Map;

public class TestNGTestMethod
extends TestNGTestObject {
    public TestNGTestMethod(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        TestData data = this.myConfig.getPersistantData();
        PsiClass psiClass = (PsiClass)ReadAction.compute(() -> ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)this.myConfig.getProject()), (String)data.getMainClassName().replace('/', '.'), null, (boolean)true, (GlobalSearchScope)this.getSearchScope()));
        if (psiClass == null) {
            throw new CantRunException("No tests found in the class \"" + data.getMainClassName() + '\"');
        }
        if (null == ReadAction.compute(() -> psiClass.getQualifiedName())) {
            throw new CantRunException("Cannot test anonymous or local class \"" + data.getMainClassName() + '\"');
        }
        TestNGTestMethod.collectTestMethods(classes, psiClass, data.getMethodName(), this.getSearchScope());
    }

    @Override
    public String getGeneratedName() {
        TestData data = this.myConfig.getPersistantData();
        return JavaExecutionUtil.getPresentableClassName((String)data.getMainClassName()) + '.' + data.getMethodName();
    }

    @Override
    public String getActionName() {
        return this.myConfig.getPersistantData().getMethodName() + "()";
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        TestData data = this.myConfig.getPersistantData();
        SourceScope scope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig);
        if (scope == null) {
            throw new RuntimeConfigurationException("Invalid scope specified");
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myConfig.getProject()).findClass(data.getMainClassName(), scope.getGlobalSearchScope());
        if (psiClass == null) {
            throw new RuntimeConfigurationException("Class '" + data.getMainClassName() + "' not found");
        }
        PsiMethod[] methods = psiClass.findMethodsByName(data.getMethodName(), true);
        if (methods.length == 0) {
            throw new RuntimeConfigurationException("Method '" + data.getMethodName() + "' not found");
        }
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("public")) continue;
            throw new RuntimeConfigurationException("Non public method '" + data.getMethodName() + "'specified");
        }
    }

    @Override
    public boolean isConfiguredByElement(PsiElement element) {
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false)) instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)element).getContainingClass();
            TestData data = this.myConfig.getPersistantData();
            return aClass != null && Comparing.strEqual((String)data.MAIN_CLASS_NAME, (String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass)) && Comparing.strEqual((String)data.METHOD_NAME, (String)((PsiMethod)element).getName());
        }
        return false;
    }
}

