/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.android.tools.profiler.ProfilerTransform;
import com.android.tools.profiler.asm.ClassVisitor;
import com.android.tools.profiler.asm.MethodVisitor;
import com.android.tools.profiler.asm.Opcodes;

final class InitializerAdapter
extends ClassVisitor
implements Opcodes {
    public static final String ANDROID_APPLICATION = "android/app/Application";
    public static final String ANDROID_ACTIVITY = "android/app/Activity";
    public static final String PROFILER_APPLICATION_CLASSNAME = "com/android/tools/profiler/support/ProfilerService";
    private static final String SERVICE_ADDRESS_PROPERTY = "profiler.service.address";
    private String superName;

    public InitializerAdapter(ClassVisitor classVisitor) {
        super(327680, classVisitor);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((this.superName.equals(ANDROID_ACTIVITY) || this.superName.equals(ANDROID_APPLICATION)) && name.equals("<init>")) {
            return new MethodAdapter(mv);
        }
        return mv;
    }

    private static final class MethodAdapter
    extends MethodVisitor
    implements Opcodes {
        public MethodAdapter(MethodVisitor mv) {
            super(327680, mv);
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    super.visitLdcInsn(InitializerAdapter.SERVICE_ADDRESS_PROPERTY);
                    super.visitLdcInsn(ProfilerTransform.NETWORK_REQUEST_PAYLOAD_ENABLED);
                    super.visitMethodInsn(184, InitializerAdapter.PROFILER_APPLICATION_CLASSNAME, "initialize", "(Ljava/lang/String;Z)V", false);
                }
            }
            super.visitInsn(opcode);
        }
    }
}

