/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.core.config;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.utils.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\r\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/build/jetifier/core/config/ConfigParser;", "", "()V", "TAG", "", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "loadConfigFileInternal", "Lcom/android/tools/build/jetifier/core/config/Config;", "configPath", "Ljava/nio/file/Path;", "loadConfigOrFail", "loadDefaultConfig", "loadFromFile", "parseFromString", "inputText", "writeToFile", "", "config", "outputPath", "writeToString", "jetifier-core"})
public final class ConfigParser {
    private static final String TAG = "Config";
    private static final Gson gson;
    public static final ConfigParser INSTANCE;

    @NotNull
    public final String writeToString(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        String string = gson.toJson((Object)config.toJson());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(config.toJson())");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(@NotNull Config config, @NotNull Path outputPath) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)outputPath, (String)"outputPath");
        Closeable closeable = new FileWriter(outputPath.toFile());
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)closeable;
            gson.toJson((Object)config.toJson(), (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final Config parseFromString(@NotNull String inputText) {
        Intrinsics.checkParameterIsNotNull((Object)inputText, (String)"inputText");
        return ((Config.JsonData)gson.fromJson(inputText, Config.JsonData.class)).toConfig();
    }

    @Nullable
    public final Config loadFromFile(@NotNull Path configPath) {
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        return this.loadConfigFileInternal(configPath);
    }

    @Nullable
    public final Config loadDefaultConfig() {
        InputStream inputStream;
        Log.INSTANCE.v(TAG, "Using the default config '%s'", "/default.generated.config");
        InputStream inputStream2 = inputStream = this.getClass().getResourceAsStream("/default.generated.config");
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
        InputStream inputStream3 = inputStream2;
        ConfigParser configParser = this;
        Charset charset = Charsets.UTF_8;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream3, charset);
        return configParser.parseFromString(TextStreamsKt.readText((Reader)inputStreamReader));
    }

    @NotNull
    public final Config loadConfigOrFail(@Nullable Path configPath) {
        if (configPath != null) {
            Config config = this.loadConfigFileInternal(configPath);
            if (config != null) {
                return config;
            }
            throw (Throwable)new FileNotFoundException("Config file was not found at '" + configPath + '\'');
        }
        Config config = this.loadDefaultConfig();
        if (config != null) {
            return config;
        }
        throw (Throwable)((Object)new AssertionError((Object)"The default config could not be found!"));
    }

    private final Config loadConfigFileInternal(Path configPath) {
        if (!Files.isReadable(configPath)) {
            Log.INSTANCE.e(TAG, "Cannot access the config file: '%s'", configPath);
            return null;
        }
        Log.INSTANCE.i(TAG, "Parsing config file: '%s'", configPath.toUri());
        File file = configPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"configPath.toFile()");
        Config config = this.parseFromString(FilesKt.readText$default((File)file, null, (int)1, null));
        if (config == null) {
            Log.INSTANCE.e(TAG, "Failed to parseFromString the config file", new Object[0]);
            return null;
        }
        return config;
    }

    private ConfigParser() {
    }

    static {
        ConfigParser configParser;
        INSTANCE = configParser = new ConfigParser();
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

