/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.core.pom;

import com.android.tools.build.jetifier.core.pom.PomDependency;
import com.android.tools.build.jetifier.core.utils.Log;
import com.google.gson.annotations.SerializedName;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0013\u001a\u00020\u0000J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\fH\u00d6\u0001J\u001a\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00032\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/android/tools/build/jetifier/core/pom/PomRewriteRule;", "", "from", "Lcom/android/tools/build/jetifier/core/pom/PomDependency;", "to", "(Lcom/android/tools/build/jetifier/core/pom/PomDependency;Lcom/android/tools/build/jetifier/core/pom/PomDependency;)V", "getFrom", "()Lcom/android/tools/build/jetifier/core/pom/PomDependency;", "getTo", "areVersionsMatching", "", "ourVersion", "", "version", "component1", "component2", "copy", "equals", "other", "getReversed", "hashCode", "", "matches", "input", "toJson", "Lcom/android/tools/build/jetifier/core/pom/PomRewriteRule$JsonData;", "toString", "validateVersion", "pomPath", "Ljava/nio/file/Path;", "Companion", "JsonData", "jetifier-core"})
public final class PomRewriteRule {
    @NotNull
    private final PomDependency from;
    @NotNull
    private final PomDependency to;
    @NotNull
    private static final String TAG = "PomRule";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PomRewriteRule getReversed() {
        return new PomRewriteRule(this.to, this.from);
    }

    public final boolean validateVersion(@NotNull PomDependency input, @Nullable Path pomPath) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (this.from.getVersion() == null || input.getVersion() == null) {
            return true;
        }
        if (!this.matches(input)) {
            return true;
        }
        String string = this.from.getVersion();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = input.getVersion();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (!this.areVersionsMatching(string, string2)) {
            Log.INSTANCE.e(TAG, "Version mismatch! Expected version '%s' but found version '%s' for '%s:%s' in '%s' file.", this.from.getVersion(), input.getVersion(), input.getGroupId(), input.getArtifactId(), String.valueOf(pomPath));
            return false;
        }
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean validateVersion$default(PomRewriteRule pomRewriteRule, PomDependency pomDependency, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        return pomRewriteRule.validateVersion(pomDependency, path);
    }

    private final boolean areVersionsMatching(String ourVersion, String version) {
        if (Intrinsics.areEqual((Object)version, (Object)"latest") || Intrinsics.areEqual((Object)version, (Object)"release")) {
            return true;
        }
        if (StringsKt.endsWith$default((String)version, (String)",)", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)version, (String)",]", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.endsWith$default((String)version, (String)(ourVersion + ']'), (boolean)false, (int)2, null)) {
            return true;
        }
        return Intrinsics.areEqual((Object)ourVersion, (Object)version);
    }

    public final boolean matches(@NotNull PomDependency input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return Intrinsics.areEqual((Object)input.getArtifactId(), (Object)this.from.getArtifactId()) && Intrinsics.areEqual((Object)input.getGroupId(), (Object)this.from.getGroupId());
    }

    @NotNull
    public final JsonData toJson() {
        return new JsonData(this.from, this.to);
    }

    @NotNull
    public final PomDependency getFrom() {
        return this.from;
    }

    @NotNull
    public final PomDependency getTo() {
        return this.to;
    }

    public PomRewriteRule(@NotNull PomDependency from, @NotNull PomDependency to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.from = from;
        this.to = to;
        PomRewriteRule.Companion.validate(this.from, false);
        PomRewriteRule.Companion.validate(this.to, true);
    }

    static {
        TAG = TAG;
    }

    @NotNull
    public final PomDependency component1() {
        return this.from;
    }

    @NotNull
    public final PomDependency component2() {
        return this.to;
    }

    @NotNull
    public final PomRewriteRule copy(@NotNull PomDependency from, @NotNull PomDependency to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        return new PomRewriteRule(from, to);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ PomRewriteRule copy$default(PomRewriteRule pomRewriteRule, PomDependency pomDependency, PomDependency pomDependency2, int n, Object object) {
        if ((n & 1) != 0) {
            pomDependency = pomRewriteRule.from;
        }
        if ((n & 2) != 0) {
            pomDependency2 = pomRewriteRule.to;
        }
        return pomRewriteRule.copy(pomDependency, pomDependency2);
    }

    public String toString() {
        return "PomRewriteRule(from=" + this.from + ", to=" + this.to + ")";
    }

    public int hashCode() {
        PomDependency pomDependency = this.from;
        PomDependency pomDependency2 = this.to;
        return (pomDependency != null ? ((Object)pomDependency).hashCode() : 0) * 31 + (pomDependency2 != null ? ((Object)pomDependency2).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PomRewriteRule)) break block3;
                PomRewriteRule pomRewriteRule = (PomRewriteRule)object;
                if (!Intrinsics.areEqual((Object)this.from, (Object)pomRewriteRule.from) || !Intrinsics.areEqual((Object)this.to, (Object)pomRewriteRule.to)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/build/jetifier/core/pom/PomRewriteRule$JsonData;", "", "from", "Lcom/android/tools/build/jetifier/core/pom/PomDependency;", "to", "(Lcom/android/tools/build/jetifier/core/pom/PomDependency;Lcom/android/tools/build/jetifier/core/pom/PomDependency;)V", "getFrom", "()Lcom/android/tools/build/jetifier/core/pom/PomDependency;", "getTo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toRule", "Lcom/android/tools/build/jetifier/core/pom/PomRewriteRule;", "toString", "", "jetifier-core"})
    public static final class JsonData {
        @SerializedName(value="from")
        @NotNull
        private final PomDependency from;
        @SerializedName(value="to")
        @NotNull
        private final PomDependency to;

        @NotNull
        public final PomRewriteRule toRule() {
            return new PomRewriteRule(this.from, this.to);
        }

        @NotNull
        public final PomDependency getFrom() {
            return this.from;
        }

        @NotNull
        public final PomDependency getTo() {
            return this.to;
        }

        public JsonData(@NotNull PomDependency from, @NotNull PomDependency to) {
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            this.from = from;
            this.to = to;
        }

        @NotNull
        public final PomDependency component1() {
            return this.from;
        }

        @NotNull
        public final PomDependency component2() {
            return this.to;
        }

        @NotNull
        public final JsonData copy(@NotNull PomDependency from, @NotNull PomDependency to) {
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            return new JsonData(from, to);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ JsonData copy$default(JsonData jsonData, PomDependency pomDependency, PomDependency pomDependency2, int n, Object object) {
            if ((n & 1) != 0) {
                pomDependency = jsonData.from;
            }
            if ((n & 2) != 0) {
                pomDependency2 = jsonData.to;
            }
            return jsonData.copy(pomDependency, pomDependency2);
        }

        public String toString() {
            return "JsonData(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            PomDependency pomDependency = this.from;
            PomDependency pomDependency2 = this.to;
            return (pomDependency != null ? ((Object)pomDependency).hashCode() : 0) * 31 + (pomDependency2 != null ? ((Object)pomDependency2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JsonData)) break block3;
                    JsonData jsonData = (JsonData)object;
                    if (!Intrinsics.areEqual((Object)this.from, (Object)jsonData.from) || !Intrinsics.areEqual((Object)this.to, (Object)jsonData.to)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/tools/build/jetifier/core/pom/PomRewriteRule$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "validate", "", "dep", "Lcom/android/tools/build/jetifier/core/pom/PomDependency;", "checkVersion", "", "jetifier-core"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private final void validate(PomDependency dep, boolean checkVersion) {
            block6: {
                block7: {
                    CharSequence charSequence;
                    if (dep.getGroupId() == null || (charSequence = (CharSequence)dep.getGroupId()).length() == 0) {
                        throw (Throwable)new IllegalArgumentException("GroupId is missing in the POM rule!");
                    }
                    if (dep.getArtifactId() == null || (charSequence = (CharSequence)dep.getArtifactId()).length() == 0) {
                        throw (Throwable)new IllegalArgumentException("ArtifactId is missing in the POM rule!");
                    }
                    if (!checkVersion) break block6;
                    if (dep.getVersion() == null) break block7;
                    String string = dep.getVersion();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!((charSequence = (CharSequence)string).length() == 0)) break block6;
                }
                throw (Throwable)new IllegalArgumentException("Version is missing in the POM rule for " + dep.getGroupId() + ':' + dep.getArtifactId() + '!');
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

