/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    @NonNls
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text();
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "\"" + s + "\"";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$1", "fun"));
            }
            return string;
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "'" + s + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$2", "fun"));
            }
            return string;
        }
    };
    @NotNull
    public static Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(@Nullable String s) {
            return StringUtil.trim(s);
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    @NonNls
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    @NonNls
    private static final String[] REPLACES_DISP = new String[]{"<", ">", "&", "'", "\""};
    @NonNls
    private static final String[] MN_QUOTED = new String[]{"&&", "__"};
    @NonNls
    private static final String[] MN_CHARS = new String[]{"&", "_"};
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-eA-E]{4}");

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/openapi/util/text/StringUtil", "indexOfIgnoreCase"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/openapi/util/text/StringUtil", "indexOfIgnoreCase"));
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/openapi/util/text/StringUtil", "containsIgnoreCase"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/openapi/util/text/StringUtil", "containsIgnoreCase"));
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "endsWithIgnoreCase"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtil", "endsWithIgnoreCase"));
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCode"));
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCodeInsensitive"));
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCodeInsensitive"));
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenation"));
        }
        if (prefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenation"));
        }
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        String string = StringUtil.trimEnd(s, suffix, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        if (StringUtil.endsWithChar(s, suffix)) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/text/StringUtil", "trimExtension"));
        }
        int index = name.lastIndexOf(46);
        String string = index < 0 ? name : name.substring(0, index);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimExtension"));
        }
        return string;
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "repeatSymbol"));
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        String string = StringUtil.join(Arrays.asList(items), f, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (items.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
            }
            return "";
        }
        String string = StringUtil.join(items, f, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.isEmpty()) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "endsWith"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtil", "endsWith"));
        }
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "lastIndexOf"));
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        String[] parts;
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] stringArray = parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p = parts[idx];
            int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtilRt.charsEqualIgnoreCase(a, b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();

        private MyHtml2Text() {
        }

        public void parse(Reader in) throws IOException {
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char[] text, int pos) {
            this.myBuffer.append(text);
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(HTML.Tag tag) {
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        public String getText() {
            return this.myBuffer.toString();
        }
    }
}

