/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.util.TimeoutUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiUtilCore");
    public static final PsiElement NULL_PSI_ELEMENT = new NullPsiElement();
    public static final PsiFile NULL_PSI_FILE = new NullPsiFile();

    @NotNull
    public static PsiElement[] toPsiElementArray(@NotNull Collection<? extends PsiElement> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/psi/util/PsiUtilCore", "toPsiElementArray"));
        }
        if (collection.isEmpty()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiUtilCore", "toPsiElementArray"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = collection.toArray(new PsiElement[collection.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiUtilCore", "toPsiElementArray"));
        }
        return psiElementArray;
    }

    public static int compareElementsByPosition(PsiElement element1, PsiElement element2) {
        if (element1 != null && element2 != null) {
            PsiFile psiFile2;
            PsiFile psiFile1 = element1.getContainingFile();
            if (Comparing.equal(psiFile1, psiFile2 = element2.getContainingFile())) {
                TextRange textRange1 = element1.getTextRange();
                TextRange textRange2 = element2.getTextRange();
                if (textRange1 != null && textRange2 != null) {
                    return textRange1.getStartOffset() - textRange2.getStartOffset();
                }
            } else if (psiFile1 != null && psiFile2 != null) {
                String name1 = psiFile1.getName();
                String name2 = psiFile2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        }
        return 0;
    }

    public static void ensureValid(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiUtilCore", "ensureValid"));
        }
        if (!element.isValid()) {
            TimeoutUtil.sleep(1L);
            if (element.isValid()) {
                LOG.error("PSI resurrected: " + element + " of " + element.getClass());
                return;
            }
            throw new PsiInvalidElementAccessException(element);
        }
    }

    private static class NullPsiFile
    extends NullPsiElement
    implements PsiFile {
        private NullPsiFile() {
        }

        @Override
        public PsiDirectory getParent() {
            throw this.createException();
        }

        @Override
        public long getModificationStamp() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiFile getOriginalFile() {
            throw this.createException();
        }

        @Override
        public String toString() {
            return "NULL_PSI_FILE";
        }
    }

    protected static class NullPsiElement
    implements PsiElement {
        protected NullPsiElement() {
        }

        @Override
        @NotNull
        public Language getLanguage() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiElement[] getChildren() {
            throw this.createException();
        }

        @Override
        public PsiElement getParent() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getFirstChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getLastChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getNextSibling() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getPrevSibling() {
            throw this.createException();
        }

        @Override
        public PsiFile getContainingFile() {
            throw this.createException();
        }

        @Override
        public TextRange getTextRange() {
            throw this.createException();
        }

        @Override
        public int getStartOffsetInParent() {
            throw this.createException();
        }

        @Override
        public int getTextLength() {
            throw this.createException();
        }

        @Override
        public int getTextOffset() {
            throw this.createException();
        }

        @Override
        public String getText() {
            throw this.createException();
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            throw this.createException();
        }

        @Override
        public PsiElement getNavigationElement() {
            throw this.createException();
        }

        @Override
        public PsiElement getOriginalElement() {
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/util/PsiUtilCore$NullPsiElement", "textMatches"));
            }
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/PsiUtilCore$NullPsiElement", "textMatches"));
            }
            throw this.createException();
        }

        @Override
        public boolean textContains(char c) {
            throw this.createException();
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/util/PsiUtilCore$NullPsiElement", "accept"));
            }
            throw this.createException();
        }

        @Override
        public void acceptChildren(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/util/PsiUtilCore$NullPsiElement", "acceptChildren"));
            }
            throw this.createException();
        }

        @Override
        public boolean isValid() {
            throw this.createException();
        }

        @Override
        public boolean isWritable() {
            throw this.createException();
        }

        protected PsiInvalidElementAccessException createException() {
            return null;
        }

        @Override
        @Nullable
        public PsiReference getReference() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            throw this.createException();
        }

        @Override
        public PsiElement getContext() {
            throw this.createException();
        }

        @Override
        public boolean isPhysical() {
            throw this.createException();
        }

        @Override
        public String toString() {
            return "NULL_PSI_ELEMENT";
        }
    }
}

