/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Maps;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CutPasteDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"CutPasteId", (String)"Likely cut & paste mistakes", (String)"This lint check looks for cases where you have cut & pasted calls to `findViewById` but have forgotten to update the R.id field. It's possible that your code is simply (redundantly) looking up the field repeatedly, but lint cannot distinguish that from a case where you for example want to initialize fields `prev` and `next` and you cut & pasted `findViewById(R.id.prev)` and forgot to update the second initialization to `R.id.next`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(CutPasteDetector.class, Scope.JAVA_FILE_SCOPE));
    private PsiMethod mLastMethod;
    private Map<String, PsiMethodCallExpression> mIds;
    private Map<String, String> mLhs;
    private Map<String, String> mCallOperands;

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("findViewById");
    }

    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod calledMethod) {
        PsiReferenceExpression methodExpression;
        String lhs = CutPasteDetector.getLhs(call);
        if (lhs == null) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class, (boolean)false);
        if (method == null) {
            return;
        }
        if (method != this.mLastMethod) {
            this.mIds = Maps.newHashMap();
            this.mLhs = Maps.newHashMap();
            this.mCallOperands = Maps.newHashMap();
            this.mLastMethod = method;
        }
        String callOperand = (methodExpression = call.getMethodExpression()).getQualifier() != null ? methodExpression.getQualifier().getText() : "";
        PsiExpression[] arguments = call.getArgumentList().getExpressions();
        if (arguments.length == 0) {
            return;
        }
        PsiExpression first = arguments[0];
        if (first instanceof PsiReferenceExpression) {
            PsiReferenceExpression type;
            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)first;
            String id = psiReferenceExpression.getReferenceName();
            PsiElement operand = psiReferenceExpression.getQualifier();
            if (operand instanceof PsiReferenceExpression && "id".equals((type = (PsiReferenceExpression)operand).getReferenceName())) {
                if (this.mIds.containsKey(id)) {
                    if (lhs.equals(this.mLhs.get(id))) {
                        return;
                    }
                    if (!callOperand.equals(this.mCallOperands.get(id))) {
                        return;
                    }
                    PsiMethodCallExpression earlierCall = this.mIds.get(id);
                    if (!CutPasteDetector.isReachableFrom(method, (PsiElement)earlierCall, (PsiElement)call)) {
                        return;
                    }
                    Location location = context.getLocation((PsiElement)call);
                    Location secondary = context.getLocation((PsiElement)earlierCall);
                    secondary.setMessage("First usage here");
                    location.setSecondary(secondary);
                    context.report(ISSUE, (PsiElement)call, location, String.format("The id `%1$s` has already been looked up in this method; possible cut & paste error?", first.getText()));
                } else {
                    this.mIds.put(id, call);
                    this.mLhs.put(id, lhs);
                    this.mCallOperands.put(id, callOperand);
                }
            }
        }
    }

    private static String getLhs(PsiMethodCallExpression call) {
        PsiElement parent = LintUtils.skipParentheses((PsiElement)call.getParent());
        if (parent instanceof PsiTypeCastExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiLocalVariable) {
            return ((PsiLocalVariable)parent).getName();
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression be = (PsiBinaryExpression)parent;
            PsiExpression left = be.getLOperand();
            if (left instanceof PsiReference) {
                return left.getText();
            }
            if (left instanceof PsiArrayAccessExpression) {
                PsiArrayAccessExpression aa = (PsiArrayAccessExpression)left;
                return aa.getArrayExpression().getText();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            PsiExpression left = ((PsiAssignmentExpression)parent).getLExpression();
            if (left instanceof PsiReference) {
                return left.getText();
            }
            if (left instanceof PsiArrayAccessExpression) {
                PsiArrayAccessExpression aa = (PsiArrayAccessExpression)left;
                return aa.getArrayExpression().getText();
            }
        }
        return null;
    }

    static boolean isReachableFrom(PsiMethod method, PsiElement from, PsiElement to) {
        PsiElement prev = from;
        PsiElement curr = CutPasteDetector.next(method, from, to, null);
        while (curr != null) {
            if (CutPasteDetector.containsElement(method, curr, to)) {
                return true;
            }
            prev = curr = CutPasteDetector.next(method, curr, to, prev);
        }
        return false;
    }

    static PsiElement next(PsiMethod method, PsiElement curr, PsiElement target, PsiElement prev) {
        if (curr instanceof PsiMethod) {
            return null;
        }
        PsiElement parent = curr.getParent();
        if (curr instanceof PsiContinueStatement) {
            PsiStatement continuedStatement = ((PsiContinueStatement)curr).findContinuedStatement();
            if (continuedStatement != null) {
                if (CutPasteDetector.containsElement(method, (PsiElement)continuedStatement, target)) {
                    return target;
                }
                return CutPasteDetector.next(method, (PsiElement)continuedStatement, target, curr);
            }
            return CutPasteDetector.next(method, parent, target, curr);
        }
        if (curr instanceof PsiBreakStatement) {
            PsiStatement exitedStatement = ((PsiBreakStatement)curr).findExitedStatement();
            if (exitedStatement != null) {
                return CutPasteDetector.next(method, (PsiElement)exitedStatement, target, curr);
            }
            return CutPasteDetector.next(method, parent, target, curr);
        }
        if (curr instanceof PsiReturnStatement) {
            return null;
        }
        if (curr instanceof PsiLoopStatement && prev != null && CutPasteDetector.containsElement(method, curr, prev) && CutPasteDetector.containsElement(method, curr, target)) {
            return target;
        }
        PsiElement sibling = curr.getNextSibling();
        while (sibling instanceof PsiWhiteSpace || sibling instanceof PsiJavaToken) {
            sibling = sibling.getNextSibling();
        }
        if (sibling == null) {
            return CutPasteDetector.next(method, parent, target, curr);
        }
        if (parent instanceof PsiIfStatement && curr == ((PsiIfStatement)parent).getThenBranch()) {
            return CutPasteDetector.next(method, parent, target, curr);
        }
        if (parent instanceof PsiLoopStatement && CutPasteDetector.containsElement(method, parent, target)) {
            return target;
        }
        return sibling;
    }

    private static boolean containsElement(PsiMethod method, PsiElement root, PsiElement element) {
        while (element != null && element != method) {
            if (root.equals(element)) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }
}

