/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.IntSetSerializer;

public class ClassSetAnalysisData {
    final Map<String, String> filePathToClassName;
    final Map<String, DependentsSet> dependents;
    final Map<String, IntSet> classesToConstants;
    final Map<String, Set<String>> classesToChildren;

    public ClassSetAnalysisData(Map<String, String> filePathToClassName, Map<String, DependentsSet> dependents, Map<String, IntSet> classesToConstants, Multimap<String, String> classesToChildren) {
        this(filePathToClassName, dependents, classesToConstants, ClassSetAnalysisData.asMap(classesToChildren));
    }

    public ClassSetAnalysisData(Map<String, String> filePathToClassName, Map<String, DependentsSet> dependents, Map<String, IntSet> classesToConstants, Map<String, Set<String>> classesToChildren) {
        this.filePathToClassName = filePathToClassName;
        this.dependents = dependents;
        this.classesToConstants = classesToConstants;
        this.classesToChildren = classesToChildren;
    }

    private static <K, V> Map<K, Set<V>> asMap(Multimap<K, V> multimap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object key : multimap.keySet()) {
            builder.put(key, (Object)ImmutableSet.copyOf((Collection)multimap.get(key)));
        }
        return builder.build();
    }

    public String getClassNameForFile(String filePath) {
        return this.filePathToClassName.get(filePath);
    }

    public DependentsSet getDependents(String className) {
        return this.dependents.get(className);
    }

    public IntSet getConstants(String className) {
        IntSet integers = this.classesToConstants.get(className);
        if (integers == null) {
            return IntSets.EMPTY_SET;
        }
        return integers;
    }

    public Set<String> getChildren(String className) {
        Set<String> children = this.classesToChildren.get(className);
        return children == null ? Collections.emptySet() : children;
    }

    public static class Serializer
    extends AbstractSerializer<ClassSetAnalysisData> {
        public ClassSetAnalysisData read(Decoder decoder) throws Exception {
            String className;
            HashMap<Integer, String> classNameMap = new HashMap<Integer, String>();
            int count = decoder.readSmallInt();
            ImmutableMap.Builder filePathToClassNameBuilder = ImmutableMap.builder();
            for (int i = 0; i < count; ++i) {
                String filePath = decoder.readString();
                className = this.readClassName(decoder, classNameMap);
                filePathToClassNameBuilder.put((Object)filePath, (Object)className);
            }
            count = decoder.readSmallInt();
            ImmutableMap.Builder dependentsBuilder = ImmutableMap.builder();
            for (int i = 0; i < count; ++i) {
                className = this.readClassName(decoder, classNameMap);
                DependentsSet dependents = this.readDependentsSet(decoder, classNameMap);
                dependentsBuilder.put((Object)className, (Object)dependents);
            }
            count = decoder.readSmallInt();
            ImmutableMap.Builder classesToConstantsBuilder = ImmutableMap.builder();
            for (int i = 0; i < count; ++i) {
                String className2 = this.readClassName(decoder, classNameMap);
                IntSet constants = IntSetSerializer.INSTANCE.read(decoder);
                classesToConstantsBuilder.put((Object)className2, (Object)constants);
            }
            count = decoder.readSmallInt();
            ImmutableMap.Builder classNameToChildren = ImmutableMap.builder();
            for (int i = 0; i < count; ++i) {
                String parent = this.readClassName(decoder, classNameMap);
                int nameCount = decoder.readSmallInt();
                ImmutableSet.Builder namesBuilder = ImmutableSet.builder();
                for (int j = 0; j < nameCount; ++j) {
                    namesBuilder.add((Object)this.readClassName(decoder, classNameMap));
                }
                classNameToChildren.put((Object)parent, (Object)namesBuilder.build());
            }
            return new ClassSetAnalysisData((Map<String, String>)filePathToClassNameBuilder.build(), (Map<String, DependentsSet>)dependentsBuilder.build(), (Map<String, IntSet>)classesToConstantsBuilder.build(), (Map<String, Set<String>>)classNameToChildren.build());
        }

        public void write(Encoder encoder, ClassSetAnalysisData value) throws Exception {
            HashMap<String, Integer> classNameMap = new HashMap<String, Integer>();
            encoder.writeSmallInt(value.filePathToClassName.size());
            for (Map.Entry<String, String> entry : value.filePathToClassName.entrySet()) {
                encoder.writeString((CharSequence)entry.getKey());
                this.writeClassName(entry.getValue(), classNameMap, encoder);
            }
            encoder.writeSmallInt(value.dependents.size());
            for (Map.Entry<String, Object> entry : value.dependents.entrySet()) {
                this.writeClassName(entry.getKey(), classNameMap, encoder);
                this.writeDependentSet((DependentsSet)entry.getValue(), classNameMap, encoder);
            }
            encoder.writeSmallInt(value.classesToConstants.size());
            for (Map.Entry<String, Object> entry : value.classesToConstants.entrySet()) {
                this.writeClassName(entry.getKey(), classNameMap, encoder);
                IntSetSerializer.INSTANCE.write(encoder, (IntSet)entry.getValue());
            }
            encoder.writeSmallInt(value.classesToChildren.size());
            for (Map.Entry<String, Object> entry : value.classesToChildren.entrySet()) {
                this.writeClassName(entry.getKey(), classNameMap, encoder);
                encoder.writeSmallInt(((Set)entry.getValue()).size());
                for (String className : (Set)entry.getValue()) {
                    this.writeClassName(className, classNameMap, encoder);
                }
            }
        }

        private DependentsSet readDependentsSet(Decoder decoder, Map<Integer, String> classNameMap) throws IOException {
            byte b = decoder.readByte();
            if (b == 1) {
                return new DependencyToAll(decoder.readNullableString());
            }
            int count = decoder.readSmallInt();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < count; ++i) {
                builder.add((Object)this.readClassName(decoder, classNameMap));
            }
            return new DefaultDependentsSet((Set<String>)builder.build());
        }

        private void writeDependentSet(DependentsSet dependentsSet, Map<String, Integer> classNameMap, Encoder encoder) throws IOException {
            if (dependentsSet.isDependencyToAll()) {
                encoder.writeByte((byte)1);
                encoder.writeNullableString((CharSequence)dependentsSet.getDescription());
            } else {
                encoder.writeByte((byte)2);
                encoder.writeSmallInt(dependentsSet.getDependentClasses().size());
                for (String className : dependentsSet.getDependentClasses()) {
                    this.writeClassName(className, classNameMap, encoder);
                }
            }
        }

        private String readClassName(Decoder decoder, Map<Integer, String> classNameMap) throws IOException {
            int id = decoder.readSmallInt();
            if (id == 0) {
                id = decoder.readSmallInt();
                String className = decoder.readString();
                classNameMap.put(id, className);
                return className;
            }
            return classNameMap.get(id);
        }

        private void writeClassName(String className, Map<String, Integer> classIdMap, Encoder encoder) throws IOException {
            Integer id = classIdMap.get(className);
            if (id == null) {
                id = classIdMap.size() + 1;
                classIdMap.put(className, id);
                encoder.writeSmallInt(0);
                encoder.writeSmallInt(id.intValue());
                encoder.writeString((CharSequence)className);
            } else {
                encoder.writeSmallInt(id.intValue());
            }
        }
    }
}

