/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.internal.ClasspathFactory;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.util.ConfigureUtil;

public class EclipseClasspath {
    private Iterable<SourceSet> sourceSets;
    private Collection<Configuration> plusConfigurations = new ArrayList<Configuration>();
    private Collection<Configuration> minusConfigurations = new ArrayList<Configuration>();
    private Set<String> containers = new LinkedHashSet<String>();
    private File defaultOutputDir;
    private boolean downloadSources = true;
    private boolean downloadJavadoc;
    private XmlFileContentMerger file;
    private Map<String, File> pathVariables = new HashMap<String, File>();
    private boolean projectDependenciesOnly;
    private List<File> classFolders;
    private final Project project;

    public EclipseClasspath(Project project) {
        this.project = project;
    }

    public Iterable<SourceSet> getSourceSets() {
        return this.sourceSets;
    }

    public void setSourceSets(Iterable<SourceSet> sourceSets) {
        this.sourceSets = sourceSets;
    }

    public Collection<Configuration> getPlusConfigurations() {
        return this.plusConfigurations;
    }

    public void setPlusConfigurations(Collection<Configuration> plusConfigurations) {
        this.plusConfigurations = plusConfigurations;
    }

    public Collection<Configuration> getMinusConfigurations() {
        return this.minusConfigurations;
    }

    public void setMinusConfigurations(Collection<Configuration> minusConfigurations) {
        this.minusConfigurations = minusConfigurations;
    }

    public Set<String> getContainers() {
        return this.containers;
    }

    public void setContainers(Set<String> containers) {
        this.containers = containers;
    }

    public File getDefaultOutputDir() {
        return this.defaultOutputDir;
    }

    public void setDefaultOutputDir(File defaultOutputDir) {
        this.defaultOutputDir = defaultOutputDir;
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public boolean isDownloadJavadoc() {
        return this.downloadJavadoc;
    }

    public void setDownloadJavadoc(boolean downloadJavadoc) {
        this.downloadJavadoc = downloadJavadoc;
    }

    public XmlFileContentMerger getFile() {
        return this.file;
    }

    public void setFile(XmlFileContentMerger file) {
        this.file = file;
    }

    public Map<String, File> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, File> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public boolean isProjectDependenciesOnly() {
        return this.projectDependenciesOnly;
    }

    public void setProjectDependenciesOnly(boolean projectDependenciesOnly) {
        this.projectDependenciesOnly = projectDependenciesOnly;
    }

    public List<File> getClassFolders() {
        return this.classFolders;
    }

    public void setClassFolders(List<File> classFolders) {
        this.classFolders = classFolders;
    }

    public Project getProject() {
        return this.project;
    }

    public void containers(String ... containers) {
        Preconditions.checkNotNull((Object)containers);
        this.containers.addAll(Arrays.asList(containers));
    }

    public void file(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.file);
    }

    public void file(Action<? super XmlFileContentMerger> action) {
        action.execute((Object)this.file);
    }

    public List<ClasspathEntry> resolveDependencies() {
        ClasspathFactory classpathFactory = new ClasspathFactory(this);
        List<ClasspathEntry> entries = classpathFactory.createEntries();
        return entries;
    }

    public void mergeXmlClasspath(Classpath xmlClasspath) {
        this.file.getBeforeMerged().execute((Object)xmlClasspath);
        List<ClasspathEntry> entries = this.resolveDependencies();
        xmlClasspath.configure(entries);
        this.file.getWhenMerged().execute((Object)xmlClasspath);
    }

    public FileReferenceFactory getFileReferenceFactory() {
        FileReferenceFactory referenceFactory = new FileReferenceFactory();
        for (Map.Entry<String, File> entry : this.pathVariables.entrySet()) {
            referenceFactory.addPathVariable(entry.getKey(), entry.getValue());
        }
        return referenceFactory;
    }
}

