/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectLocalComponentProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Delete;
import org.gradle.initialization.ProjectPathRegistry;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

public abstract class IdePlugin
implements Plugin<Project>,
IdeArtifactRegistry {
    private Task lifecycleTask;
    private Task cleanTask;
    protected Project project;

    public static String toGradleCommand(Project project) {
        Gradle gradle = project.getGradle();
        Optional gradleWrapperPath = Optional.absent();
        Project rootProject = project.getRootProject();
        String gradlewExtension = OperatingSystem.current().isWindows() ? ".bat" : "";
        File gradlewFile = rootProject.file((Object)("gradlew" + gradlewExtension));
        if (gradlewFile.exists()) {
            gradleWrapperPath = Optional.of((Object)gradlewFile.getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.or((Object)"gradle");
    }

    public void apply(Project target) {
        this.project = target;
        String lifecycleTaskName = this.getLifecycleTaskName();
        this.lifecycleTask = target.task(lifecycleTaskName);
        this.lifecycleTask.setGroup("IDE");
        this.cleanTask = target.getTasks().create(this.cleanName(lifecycleTaskName), Delete.class);
        this.cleanTask.setGroup("IDE");
        this.onApply(target);
    }

    public Task getLifecycleTask() {
        return this.lifecycleTask;
    }

    public Task getCleanTask() {
        return this.cleanTask;
    }

    public Task getCleanTask(Task worker) {
        return this.project.getTasks().getByName(this.cleanName(worker.getName()));
    }

    protected String cleanName(String taskName) {
        return String.format("clean%s", StringUtils.capitalize((String)taskName));
    }

    public void addWorker(Task worker) {
        this.addWorker(worker, true);
    }

    public void addWorker(Task worker, boolean includeInClean) {
        this.lifecycleTask.dependsOn(new Object[]{worker});
        Delete cleanWorker = (Delete)this.project.getTasks().create(this.cleanName(worker.getName()), Delete.class);
        cleanWorker.delete(new Object[]{worker.getOutputs().getFiles()});
        if (includeInClean) {
            this.cleanTask.dependsOn(new Object[]{cleanWorker});
        }
    }

    protected void onApply(Project target) {
    }

    protected abstract String getLifecycleTaskName();

    protected void postProcess(String key, final Action<? super Gradle> action) {
        String extraPropertyName;
        Project rootProject = this.project.getRootProject();
        ExtraPropertiesExtension rootExtraProperties = (ExtraPropertiesExtension)rootProject.getExtensions().getByType(ExtraPropertiesExtension.class);
        if (!rootExtraProperties.has(extraPropertyName = "org.gradle." + key + ".postprocess.applied")) {
            this.project.getGradle().addBuildListener((BuildListener)new BuildAdapter(){

                public void projectsEvaluated(Gradle gradle) {
                    action.execute((Object)gradle);
                }
            });
            rootExtraProperties.set(extraPropertyName, (Object)true);
        }
    }

    @Override
    public void registerIdeArtifact(PublishArtifact ideArtifact) {
        ProjectLocalComponentProvider projectComponentProvider = (ProjectLocalComponentProvider)((ProjectInternal)this.project).getServices().get(ProjectLocalComponentProvider.class);
        ProjectComponentIdentifier projectId = DefaultProjectComponentIdentifier.newProjectId((Project)this.project);
        projectComponentProvider.registerAdditionalArtifact(projectId, (LocalComponentArtifactMetadata)new PublishArtifactLocalArtifactMetadata((ComponentIdentifier)projectId, ideArtifact));
    }

    @Override
    public List<LocalComponentArtifactMetadata> getIdeArtifactMetadata(String type) {
        ServiceRegistry serviceRegistry = ((ProjectInternal)this.project).getServices();
        ArrayList result = Lists.newArrayList();
        ProjectPathRegistry projectPathRegistry = (ProjectPathRegistry)serviceRegistry.get(ProjectPathRegistry.class);
        LocalComponentRegistry localComponentRegistry = (LocalComponentRegistry)serviceRegistry.get(LocalComponentRegistry.class);
        for (Path projectPath : projectPathRegistry.getAllExplicitProjectPaths()) {
            ProjectComponentIdentifier projectId = projectPathRegistry.getProjectComponentIdentifier(projectPath);
            Iterable additionalArtifacts = localComponentRegistry.getAdditionalArtifacts(projectId);
            for (LocalComponentArtifactMetadata artifactMetadata : additionalArtifacts) {
                if (!artifactMetadata.getName().getType().equals(type)) continue;
                result.add(artifactMetadata);
            }
        }
        return result;
    }

    @Override
    public FileCollection getIdeArtifacts(final String type) {
        return this.project.files(new Object[]{new Callable<List<FileCollection>>(){

            @Override
            public List<FileCollection> call() throws Exception {
                return CollectionUtils.collect(IdePlugin.this.getIdeArtifactMetadata(type), (Transformer)new Transformer<FileCollection, LocalComponentArtifactMetadata>(){

                    public FileCollection transform(LocalComponentArtifactMetadata metadata) {
                        ConfigurableFileCollection result = IdePlugin.this.project.files(new Object[]{metadata.getFile()});
                        result.builtBy(new Object[]{metadata.getBuildDependencies()});
                        return result;
                    }
                });
            }
        }});
    }

    public boolean isRoot() {
        return this.project.getParent() == null;
    }
}

