/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.codeInsight.ExternalAnnotationsListener;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.ReadableExternalAnnotationsManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.OptionsMessageDialog;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotationsManagerImpl
extends ReadableExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotationsManagerImpl.class);
    private final MessageBus myBus;

    public ExternalAnnotationsManagerImpl(@NotNull Project project, PsiManager psiManager) {
        if (project == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(0);
        }
        super(psiManager);
        this.myBus = project.getMessageBus();
        this.myBus.connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ExternalAnnotationsManagerImpl.this.dropCache();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(), (Disposable)project);
    }

    private void notifyAfterAnnotationChanging(@NotNull PsiModifierListOwner owner, @NotNull String annotationFQName, boolean successful) {
        if (owner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(1);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(2);
        }
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).afterExternalAnnotationChanging(owner, annotationFQName, successful);
        this.myPsiManager.dropPsiCaches();
    }

    private void notifyChangedExternally() {
        ((ExternalAnnotationsListener)this.myBus.syncPublisher(TOPIC)).externalAnnotationsChangedExternally();
        this.myPsiManager.dropPsiCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value2) throws ExternalAnnotationsManager.CanceledConfigurationException {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(3);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(4);
        }
        if (fromFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(5);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        LOG.assertTrue(!application.isWriteAccessAllowed());
        Project project = this.myPsiManager.getProject();
        PsiFile containingFile = listOwner.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        String packageName = ((PsiJavaFile)containingFile).getPackageName();
        VirtualFile containingVirtualFile = containingFile.getVirtualFile();
        LOG.assertTrue(containingVirtualFile != null);
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(containingVirtualFile);
        if (entries.isEmpty()) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        for (OrderEntry entry : entries) {
            if (entry instanceof ModuleOrderEntry) continue;
            VirtualFile[] roots = AnnotationOrderRootType.getFiles((OrderEntry)entry);
            if ((roots = ExternalAnnotationsManagerImpl.filterByReadOnliness(roots)).length > 0) {
                this.chooseRootAndAnnotateExternally(listOwner, annotationFQName, fromFile, project, packageName, roots, value2);
                break;
            }
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                return;
            }
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
            try {
                if (!this.setupRootAndAnnotateExternally(entry, project, listOwner, annotationFQName, fromFile, packageName, value2)) {
                    throw new ExternalAnnotationsManager.CanceledConfigurationException();
                }
                break;
            }
            finally {
                DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
            }
        }
    }

    @Nullable
    private List<XmlFile> findExternalAnnotationsXmlFiles(@NotNull PsiModifierListOwner listOwner) {
        List<PsiFile> psiFiles;
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(6);
        }
        if ((psiFiles = this.findExternalAnnotationsFiles(listOwner)) == null) {
            return null;
        }
        ArrayList<XmlFile> xmlFiles = new ArrayList<XmlFile>();
        for (PsiFile psiFile : psiFiles) {
            if (!(psiFile instanceof XmlFile)) continue;
            xmlFiles.add((XmlFile)psiFile);
        }
        return xmlFiles;
    }

    private boolean setupRootAndAnnotateExternally(final @NotNull OrderEntry entry, @NotNull Project project, final @NotNull PsiModifierListOwner listOwner, final @NotNull String annotationFQName, final @NotNull PsiFile fromFile, final @NotNull String packageName, final @Nullable PsiNameValuePair[] value2) {
        if (entry == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(8);
        }
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(9);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(10);
        }
        if (fromFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(12);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(ProjectBundle.message((String)"external.annotations.root.chooser.title", (Object[])new Object[]{entry.getPresentableName()}));
        descriptor.setDescription(ProjectBundle.message((String)"external.annotations.root.chooser.description", (Object[])new Object[0]));
        final VirtualFile newRoot = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (newRoot == null) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return false;
        }
        final String externalName = ExternalAnnotationsManagerImpl.getExternalName(listOwner, false);
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExternalAnnotationsManagerImpl.this.appendChosenAnnotationsRoot(entry, newRoot);
                XmlFile xmlFileInRoot = ExternalAnnotationsManagerImpl.findXmlFileInRoot(ExternalAnnotationsManagerImpl.this.findExternalAnnotationsXmlFiles(listOwner), newRoot);
                if (xmlFileInRoot != null) {
                    if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)xmlFileInRoot)) {
                        ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                        return;
                    }
                    ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, xmlFileInRoot, fromFile, value2, externalName);
                } else {
                    XmlFile annotationsXml = ExternalAnnotationsManagerImpl.this.createAnnotationsXml(newRoot, packageName);
                    if (annotationsXml != null) {
                        SmartList createdFiles = new SmartList((Object)annotationsXml);
                        ExternalAnnotationsManagerImpl.this.cacheExternalAnnotations(packageName, fromFile, (List<PsiFile>)createdFiles);
                    }
                    ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, annotationsXml, fromFile, value2, externalName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$2", "run"));
            }
        }.execute();
        return true;
    }

    @Nullable
    private static XmlFile findXmlFileInRoot(@Nullable List<XmlFile> xmlFiles, @NotNull VirtualFile root) {
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(13);
        }
        if (xmlFiles != null) {
            for (XmlFile xmlFile : xmlFiles) {
                VirtualFile vf = xmlFile.getVirtualFile();
                if (vf == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)vf, (boolean)false)) continue;
                return xmlFile;
            }
        }
        return null;
    }

    private void chooseRootAndAnnotateExternally(final @NotNull PsiModifierListOwner listOwner, final @NotNull String annotationFQName, final @NotNull PsiFile fromFile, final @NotNull Project project, final @NotNull String packageName, @NotNull VirtualFile[] roots, final @Nullable PsiNameValuePair[] value2) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(14);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(15);
        }
        if (fromFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(16);
        }
        if (project == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(17);
        }
        if (packageName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(18);
        }
        if (roots == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(19);
        }
        if (roots.length > 1) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<VirtualFile>("Annotation Roots", roots){

                public void canceled() {
                    ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                }

                public PopupStep onChosen(@NotNull VirtualFile file, boolean finalChoice) {
                    if (file == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ExternalAnnotationsManagerImpl.this.annotateExternally(file, listOwner, project, packageName, annotationFQName, fromFile, value2);
                    return FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(@NotNull VirtualFile value22) {
                    if (value22 == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    String string = value22.getPresentableUrl();
                    if (string == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public Icon getIconFor(VirtualFile aValue) {
                    return AllIcons.Modules.Annotation;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "value";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$3";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTextFor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "onChosen";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "getTextFor";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }).showInBestPositionFor(DataManager.getInstance().getDataContext());
        } else {
            this.annotateExternally(roots[0], listOwner, project, packageName, annotationFQName, fromFile, value2);
        }
    }

    @NotNull
    private static VirtualFile[] filterByReadOnliness(@NotNull VirtualFile[] files) {
        if (files == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(20);
        }
        List result = ContainerUtil.filter((Object[])files, VirtualFile::isInLocalFileSystem);
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result);
        if (virtualFileArray == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(21);
        }
        return virtualFileArray;
    }

    private void annotateExternally(final @NotNull VirtualFile root, final @NotNull PsiModifierListOwner listOwner, @NotNull Project project, final @NotNull String packageName, final @NotNull String annotationFQName, final @NotNull PsiFile fromFile, final @Nullable PsiNameValuePair[] value2) {
        List<XmlFile> xmlFiles;
        XmlFile existingXml;
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(22);
        }
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(24);
        }
        if (packageName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(25);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(26);
        }
        if (fromFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(27);
        }
        if ((existingXml = ExternalAnnotationsManagerImpl.findXmlFileInRoot(xmlFiles = this.findExternalAnnotationsXmlFiles(listOwner), root)) != null && !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)existingXml)) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        THashSet annotationFiles = xmlFiles == null ? new THashSet() : new THashSet(xmlFiles);
        final String externalName = ExternalAnnotationsManagerImpl.getExternalName(listOwner, false);
        new WriteCommandAction(project, new PsiFile[0], (Set)annotationFiles, project){
            final /* synthetic */ Set val$annotationFiles;
            final /* synthetic */ Project val$project;
            {
                this.val$annotationFiles = set;
                this.val$project = project;
                super(arg0, arg1);
            }

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (existingXml != null) {
                    ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, existingXml, fromFile, value2, externalName);
                } else {
                    XmlFile newXml = ExternalAnnotationsManagerImpl.this.createAnnotationsXml(root, packageName);
                    if (newXml == null) {
                        ExternalAnnotationsManagerImpl.this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
                    } else {
                        this.val$annotationFiles.add(newXml);
                        ExternalAnnotationsManagerImpl.this.cacheExternalAnnotations(packageName, fromFile, (List<PsiFile>)new SmartList((Collection)this.val$annotationFiles));
                        ExternalAnnotationsManagerImpl.this.annotateExternally(listOwner, annotationFQName, newXml, fromFile, value2, externalName);
                    }
                }
                UndoManager.getInstance((Project)this.val$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                    public void undo() {
                        ExternalAnnotationsManagerImpl.this.dropCache();
                        ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                    }

                    public void redo() {
                        ExternalAnnotationsManagerImpl.this.dropCache();
                        ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$4", "run"));
            }
        }.execute();
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(28);
        }
        if (annotationFQN == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<XmlTag>)((Processor)annotationTag -> {
            PsiElement parent = annotationTag.getParent();
            annotationTag.delete();
            if (parent instanceof XmlTag && ((XmlTag)parent).getSubTags().length == 0) {
                parent.delete();
            }
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementRenamedOrMoved(@NotNull PsiModifierListOwner element, @NotNull String oldExternalName) {
        if (element == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(30);
        }
        if (oldExternalName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            List<XmlFile> files = this.findExternalAnnotationsXmlFiles(element);
            if (files == null) {
                return;
            }
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className = StringUtil.unescapeXml((String)tag.getAttributeValue("name"));
                    if (!Comparing.strEqual((String)className, (String)oldExternalName)) continue;
                    WriteCommandAction.runWriteCommandAction((Project)this.myPsiManager.getProject(), (String)ExternalAnnotationsManagerImpl.class.getName(), null, () -> {
                        if (element == null) {
                            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(63);
                        }
                        PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject()).commitAllDocuments();
                        try {
                            tag.setAttribute("name", StringUtil.escapeXml((String)ExternalAnnotationsManagerImpl.getExternalName(element, false)));
                            this.commitChanges(file);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }, (PsiFile[])new PsiFile[]{file});
                }
            }
        }
        finally {
            this.dropCache();
        }
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value2) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(32);
        }
        if (annotationFQN == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.processExistingExternalAnnotations(listOwner, annotationFQN, (Processor<XmlTag>)((Processor)annotationTag -> {
            if (annotationFQN == null) {
                ExternalAnnotationsManagerImpl.$$$reportNull$$$0(62);
            }
            annotationTag.replace((PsiElement)XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQN, value2)));
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processExistingExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @NotNull Processor<XmlTag> annotationTagProcessor) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(34);
        }
        if (annotationFQN == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(35);
        }
        if (annotationTagProcessor == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(36);
        }
        try {
            List<XmlFile> files = this.findExternalAnnotationsXmlFiles(listOwner);
            if (files == null) {
                this.notifyAfterAnnotationChanging(listOwner, annotationFQN, false);
                boolean bl = false;
                return bl;
            }
            boolean processedAnything = false;
            for (XmlFile file : files) {
                XmlTag rootTag;
                XmlDocument document;
                if (!file.isValid() || ReadonlyStatusHandler.getInstance((Project)this.myPsiManager.getProject()).ensureFilesWritable(new VirtualFile[]{file.getVirtualFile()}).hasReadonlyFiles() || (document = file.getDocument()) == null || (rootTag = document.getRootTag()) == null) continue;
                String externalName = ExternalAnnotationsManagerImpl.getExternalName(listOwner, false);
                ArrayList<XmlTag> tagsToProcess = new ArrayList<XmlTag>();
                for (XmlTag tag : rootTag.getSubTags()) {
                    String className = StringUtil.unescapeXml((String)tag.getAttributeValue("name"));
                    if (!Comparing.strEqual((String)className, (String)externalName)) continue;
                    for (XmlTag annotationTag : tag.getSubTags()) {
                        if (!Comparing.strEqual((String)annotationTag.getAttributeValue("name"), (String)annotationFQN)) continue;
                        tagsToProcess.add(annotationTag);
                        processedAnything = true;
                    }
                }
                if (tagsToProcess.isEmpty()) continue;
                WriteCommandAction.runWriteCommandAction((Project)this.myPsiManager.getProject(), (String)ExternalAnnotationsManagerImpl.class.getName(), null, () -> {
                    if (annotationTagProcessor == null) {
                        ExternalAnnotationsManagerImpl.$$$reportNull$$$0(61);
                    }
                    PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject()).commitAllDocuments();
                    try {
                        for (XmlTag annotationTag : tagsToProcess) {
                            annotationTagProcessor.process((Object)annotationTag);
                        }
                        this.commitChanges(file);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }, (PsiFile[])new PsiFile[0]);
            }
            this.notifyAfterAnnotationChanging(listOwner, annotationFQN, processedAnything);
            boolean bl = processedAnything;
            return bl;
        }
        finally {
            this.dropCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        block21: {
            if (element == null) {
                ExternalAnnotationsManagerImpl.$$$reportNull$$$0(37);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!element.isPhysical()) {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
                if (annotationPlace == null) {
                    ExternalAnnotationsManagerImpl.$$$reportNull$$$0(38);
                }
                return annotationPlace;
            }
            if (!element.getManager().isInProject(element)) {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                if (annotationPlace == null) {
                    ExternalAnnotationsManagerImpl.$$$reportNull$$$0(39);
                }
                return annotationPlace;
            }
            Project project = this.myPsiManager.getProject();
            if (((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS) {
                MyExternalPromptDialog dialog;
                PsiFile containingFile = element.getContainingFile();
                VirtualFile virtualFile = containingFile.getVirtualFile();
                LOG.assertTrue(virtualFile != null);
                List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
                if (!entries.isEmpty()) {
                    for (OrderEntry entry : entries) {
                        if (entry instanceof ModuleOrderEntry) continue;
                        if (AnnotationOrderRootType.getUrls((OrderEntry)entry).length <= 0) break;
                        ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                        if (annotationPlace == null) {
                            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(40);
                        }
                        return annotationPlace;
                    }
                }
                MyExternalPromptDialog myExternalPromptDialog = dialog = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() ? null : new MyExternalPromptDialog(project);
                if (dialog != null && dialog.isToBeShown()) {
                    ExternalAnnotationsManager.AnnotationPlace annotationPlace;
                    PsiElement highlightElement = element instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element).getNameIdentifier() : element.getNavigationElement();
                    LOG.assertTrue(highlightElement != null);
                    Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                    ArrayList highlighters = new ArrayList();
                    boolean highlight = editor != null && editor.getDocument() == PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
                    if (highlight) {
                        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                        TextRange textRange = highlightElement.getTextRange();
                        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, highlighters);
                        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
                        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
                    }
                    dialog.show();
                    if (dialog.getExitCode() == 2) {
                        annotationPlace = ExternalAnnotationsManager.AnnotationPlace.EXTERNAL;
                        ExternalAnnotationsManager.AnnotationPlace annotationPlace2 = annotationPlace;
                        if (annotationPlace2 == null) {
                            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(41);
                        }
                        return annotationPlace2;
                    }
                    if (dialog.getExitCode() != 1) break block21;
                    annotationPlace = ExternalAnnotationsManager.AnnotationPlace.NOWHERE;
                    ExternalAnnotationsManager.AnnotationPlace annotationPlace3 = annotationPlace;
                    if (annotationPlace3 == null) {
                        ExternalAnnotationsManagerImpl.$$$reportNull$$$0(42);
                    }
                    return annotationPlace3;
                    finally {
                        if (highlight) {
                            HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, (RangeHighlighter)highlighters.get(0));
                        }
                    }
                }
                if (dialog != null) {
                    dialog.close(0);
                }
            }
        }
        ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
        if (annotationPlace == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(43);
        }
        return annotationPlace;
    }

    private void appendChosenAnnotationsRoot(@NotNull OrderEntry entry, @NotNull VirtualFile vFile) {
        if (entry == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(44);
        }
        if (vFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(45);
        }
        if (entry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            LOG.assertTrue(library != null);
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(vFile, AnnotationOrderRootType.getInstance());
            model.commit();
        } else if (entry instanceof ModuleSourceOrderEntry) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)entry.getOwnerModule()).getModifiableModel();
            JavaModuleExternalPaths extension = (JavaModuleExternalPaths)model.getModuleExtension(JavaModuleExternalPaths.class);
            extension.setExternalAnnotationUrls(ArrayUtil.mergeArrays((String[])extension.getExternalAnnotationsUrls(), (String[])new String[]{vFile.getUrl()}));
            model.commit();
        } else if (entry instanceof JdkOrderEntry) {
            SdkModificator sdkModificator = ((JdkOrderEntry)entry).getJdk().getSdkModificator();
            sdkModificator.addRoot(vFile, AnnotationOrderRootType.getInstance());
            sdkModificator.commitChanges();
        }
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @Nullable XmlFile xmlFile, @NotNull PsiFile codeUsageFile, @Nullable PsiNameValuePair[] values, @Nullable String externalName) {
        if (listOwner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(46);
        }
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(47);
        }
        if (codeUsageFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(48);
        }
        if (xmlFile == null) {
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
            return;
        }
        try {
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag rootTag = document.getRootTag();
                if (externalName == null) {
                    LOG.info("member without external name: " + listOwner);
                }
                if (rootTag != null && externalName != null) {
                    XmlTag anchor = null;
                    for (XmlTag item : rootTag.getSubTags()) {
                        int compare = Comparing.compare((Comparable)((Object)externalName), (Comparable)((Object)StringUtil.unescapeXml((String)item.getAttributeValue("name"))));
                        if (compare == 0) {
                            anchor = null;
                            for (XmlTag annotation : item.getSubTags()) {
                                compare = Comparing.compare((Comparable)((Object)annotationFQName), (Comparable)((Object)annotation.getAttributeValue("name")));
                                if (compare == 0) {
                                    annotation.delete();
                                    break;
                                }
                                anchor = annotation;
                            }
                            XmlTag newTag = XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQName, values));
                            item.addAfter((PsiElement)newTag, (PsiElement)anchor);
                            this.commitChanges(xmlFile);
                            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, true);
                            return;
                        }
                        if (compare < 0) break;
                        anchor = item;
                    }
                    String text2 = "<item name='" + StringUtil.escapeXml((String)externalName) + "'>\n";
                    text2 = text2 + ExternalAnnotationsManagerImpl.createAnnotationTag(annotationFQName, values);
                    text2 = text2 + "</item>";
                    rootTag.addAfter((PsiElement)XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)text2), (PsiElement)anchor);
                    this.commitChanges(xmlFile);
                    this.notifyAfterAnnotationChanging(listOwner, annotationFQName, true);
                    return;
                }
            }
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            this.notifyAfterAnnotationChanging(listOwner, annotationFQName, false);
        }
        finally {
            this.dropCache();
            if (codeUsageFile.getVirtualFile().isInLocalFileSystem()) {
                UndoUtil.markPsiFileForUndo((PsiFile)codeUsageFile);
            }
        }
    }

    private static void sortItems(@NotNull XmlFile xmlFile) {
        XmlDocument document;
        if (xmlFile == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(49);
        }
        if ((document = xmlFile.getDocument()) == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        ArrayList<XmlTag> itemTags = new ArrayList<XmlTag>();
        for (XmlTag item : rootTag.getSubTags()) {
            if (item.getAttributeValue("name") != null) {
                itemTags.add(item);
                continue;
            }
            item.delete();
        }
        ArrayList sorted = new ArrayList(itemTags);
        Collections.sort(sorted, (item1, item2) -> {
            String externalName1 = item1.getAttributeValue("name");
            String externalName2 = item2.getAttributeValue("name");
            assert (externalName1 != null && externalName2 != null);
            return externalName1.compareTo(externalName2);
        });
        if (!sorted.equals(itemTags)) {
            for (XmlTag item : sorted) {
                rootTag.addAfter((PsiElement)item, null);
                item.delete();
            }
        }
    }

    private void commitChanges(XmlFile xmlFile) {
        ExternalAnnotationsManagerImpl.sortItems(xmlFile);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject());
        Document doc = documentManager.getDocument((PsiFile)xmlFile);
        assert (doc != null);
        documentManager.doPostponedOperationsAndUnblockDocument(doc);
        FileDocumentManager.getInstance().saveDocument(doc);
    }

    @NonNls
    @NotNull
    @VisibleForTesting
    public static String createAnnotationTag(@NotNull String annotationFQName, @Nullable PsiNameValuePair[] values) {
        String text2;
        if (annotationFQName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(50);
        }
        if (values != null && values.length != 0) {
            text2 = "  <annotation name='" + annotationFQName + "'>\n";
            text2 = text2 + StringUtil.join((Object[])values, pair -> "<val" + (pair.getName() != null ? " name=\"" + pair.getName() + "\"" : "") + " val=\"" + StringUtil.escapeXml((String)pair.getValue().getText()) + "\"/>", (String)"    \n");
            text2 = text2 + "  </annotation>";
        } else {
            text2 = "  <annotation name='" + annotationFQName + "'/>\n";
        }
        String string = text2;
        if (string == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nullable
    private XmlFile createAnnotationsXml(@NotNull VirtualFile root, @NonNls @NotNull String packageName) {
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(52);
        }
        if (packageName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(53);
        }
        return ExternalAnnotationsManagerImpl.createAnnotationsXml(root, packageName, this.myPsiManager);
    }

    @Nullable
    @VisibleForTesting
    public static XmlFile createAnnotationsXml(@NotNull VirtualFile root, @NonNls @NotNull String packageName, PsiManager manager) {
        String[] dirs;
        if (root == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(54);
        }
        if (packageName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(55);
        }
        for (String dir : dirs = packageName.split("\\.")) {
            if (dir.isEmpty()) break;
            VirtualFile subdir = root.findChild(dir);
            if (subdir == null) {
                try {
                    subdir = root.createChildDirectory(null, dir);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            root = subdir;
        }
        PsiDirectory directory = manager.findDirectory(root);
        if (directory == null) {
            return null;
        }
        PsiFile psiFile = directory.findFile("annotations.xml");
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        try {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)manager.getProject());
            return (XmlFile)directory.add((PsiElement)factory.createFileFromText("annotations.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)"<root></root>"));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(56);
        }
        if (this.hasAnyAnnotationsRoots()) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myPsiManager.getProject()).getFileIndex();
            for (OrderEntry entry : fileIndex.getOrderEntriesForFile(file)) {
                if (entry instanceof ModuleOrderEntry || AnnotationOrderRootType.getUrls((OrderEntry)entry).length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void duplicateError(@NotNull PsiFile file, @NotNull String externalName, @NotNull String text2) {
        if (file == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(57);
        }
        if (externalName == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(58);
        }
        if (text2 == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(59);
        }
        String message2 = text2 + "; for signature: '" + externalName + "' in the file " + file.getVirtualFile().getPresentableUrl();
        LogMessageEx.error((Logger)LOG, (String)message2, (String[])new String[]{file.getText()});
    }

    public static boolean areExternalAnnotationsApplicable(@NotNull PsiModifierListOwner owner) {
        PsiElement parent;
        if (owner == null) {
            ExternalAnnotationsManagerImpl.$$$reportNull$$$0(60);
        }
        if (!owner.isPhysical()) {
            return false;
        }
        if (owner instanceof PsiLocalVariable) {
            return false;
        }
        if (owner instanceof PsiParameter && ((parent = owner.getParent()) == null || !(parent.getParent() instanceof PsiMethod))) {
            return false;
        }
        if (!owner.getManager().isInProject((PsiElement)owner)) {
            return true;
        }
        return ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)owner.getProject()).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 15: 
            case 26: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQName";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 23: 
            case 28: 
            case 32: 
            case 34: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 7: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 12: 
            case 18: 
            case 25: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 13: 
            case 22: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 21: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl";
                break;
            }
            case 29: 
            case 33: 
            case 35: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 30: 
            case 37: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExternalName";
                break;
            }
            case 36: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTagProcessor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeUsageFile";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByReadOnliness";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAnnotationsPlace";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifyAfterAnnotationChanging";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "annotateExternally";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotationsXmlFiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setupRootAndAnnotateExternally";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findXmlFileInRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "chooseRootAndAnnotateExternally";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterByReadOnliness";
                break;
            }
            case 21: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 51: {
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deannotate";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "elementRenamedOrMoved";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "editExternalAnnotation";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processExistingExternalAnnotations";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlace";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "appendChosenAnnotationsRoot";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sortItems";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationTag";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationsXml";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationRootsForFile";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "duplicateError";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "areExternalAnnotationsApplicable";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExistingExternalAnnotations$3";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$editExternalAnnotation$2";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$elementRenamedOrMoved$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        private void processEvent(VirtualFileEvent event) {
            if (event.isFromRefresh() && "annotations.xml".equals(event.getFileName())) {
                ExternalAnnotationsManagerImpl.this.dropCache();
                ExternalAnnotationsManagerImpl.this.notifyChangedExternally();
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            this.processEvent(event);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            this.processEvent(event);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(2);
            }
            this.processEvent(event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(3);
            }
            this.processEvent((VirtualFileEvent)event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(4);
            }
            this.processEvent((VirtualFileEvent)event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyExternalPromptDialog
    extends OptionsMessageDialog {
        private final Project myProject;
        private static final String ADD_IN_CODE = ProjectBundle.message((String)"external.annotations.in.code.option", (Object[])new Object[0]);
        private static final String MESSAGE = ProjectBundle.message((String)"external.annotations.suggestion.message", (Object[])new Object[0]);

        MyExternalPromptDialog(Project project) {
            super(project, MESSAGE, ProjectBundle.message((String)"external.annotation.prompt", (Object[])new Object[0]), Messages.getQuestionIcon());
            this.myProject = project;
            this.init();
        }

        protected String getOkActionName() {
            return ADD_IN_CODE;
        }

        @NotNull
        protected String getCancelActionName() {
            String string = CommonBundle.getCancelButtonText();
            if (string == null) {
                MyExternalPromptDialog.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        protected Action[] createActions() {
            Action okAction = this.getOKAction();
            MyExternalPromptDialog.assignMnemonic((String)ADD_IN_CODE, (Action)okAction);
            final String externalName = ProjectBundle.message((String)"external.annotations.external.option", (Object[])new Object[0]);
            Action[] actionArray = new Action[]{okAction, new AbstractAction(externalName){
                {
                    super(x0);
                    MyExternalPromptDialog.assignMnemonic((String)externalName, (Action)this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.canBeHidden()) {
                        this.setToBeShown(this.toBeShown(), true);
                    }
                    this.close(2);
                }
            }, this.getCancelAction()};
            if (actionArray == null) {
                MyExternalPromptDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        protected boolean isToBeShown() {
            return ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS;
        }

        protected void setToBeShown(boolean value2, boolean onOk) {
            ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).USE_EXTERNAL_ANNOTATIONS = value2;
        }

        protected JComponent createNorthPanel() {
            JPanel northPanel = (JPanel)super.createNorthPanel();
            northPanel.add((Component)new JLabel(MESSAGE), "Center");
            return northPanel;
        }

        protected boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/ExternalAnnotationsManagerImpl$MyExternalPromptDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCancelActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

