/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeInferredAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Make Inferred Annotations Explicit" == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(0);
        }
        return "Make Inferred Annotations Explicit";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Object[] annotations2;
        PsiElement leaf;
        if (project == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(1);
        }
        if ((leaf = file.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return false;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        if (owner != null && owner.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeInferredAnnotationExplicit.isWritable(owner) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5) && (annotations2 = InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner)).length > 0) {
            String annos = StringUtil.join((Object[])annotations2, annotation -> {
                PsiJavaCodeReferenceElement nameRef = MakeInferredAnnotationExplicit.correctAnnotation(annotation).getNameReferenceElement();
                String name = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
                return "@" + name + annotation.getParameterList().getText();
            }, (String)" ");
            this.setText("Insert '" + annos + "'");
            return true;
        }
        return false;
    }

    private static boolean isWritable(PsiModifierListOwner owner) {
        if (owner instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner);
        return vFile != null && vFile.isInLocalFileSystem();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(2);
        }
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        assert (leaf != null);
        PsiModifierListOwner owner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        assert (owner != null);
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)owner)) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (PsiAnnotation inferred : InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner)) {
            PsiAnnotation toInsert = MakeInferredAnnotationExplicit.correctAnnotation(inferred);
            String qname = toInsert.getQualifiedName();
            assert (qname != null);
            if (facade.findClass(qname, file.getResolveScope()) == null && !InferNullityAnnotationsAction.addAnnotationsDependency(project, Collections.singleton(module), qname, this.getFamilyName())) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                if (project == null) {
                    MakeInferredAnnotationExplicit.$$$reportNull$$$0(7);
                }
                DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
                    if (project == null) {
                        MakeInferredAnnotationExplicit.$$$reportNull$$$0(8);
                    }
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(modifierList.addAfter((PsiElement)toInsert, null));
                });
            });
        }
    }

    @NotNull
    private static PsiAnnotation correctAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(3);
        }
        Project project = annotation.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance((Project)project);
        if ("org.jetbrains.annotations.Nullable".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNullable(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNullable(), null);
            if (psiAnnotation == null) {
                MakeInferredAnnotationExplicit.$$$reportNull$$$0(4);
            }
            return psiAnnotation;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNotNull(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNotNull(), null);
            if (psiAnnotation == null) {
                MakeInferredAnnotationExplicit.$$$reportNull$$$0(5);
            }
            return psiAnnotation;
        }
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(6);
        }
        return psiAnnotation;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MakeInferredAnnotationExplicit";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MakeInferredAnnotationExplicit";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "correctAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "correctAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

