/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetBrainsAnnotationsExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final ExternalLibraryDescriptor JAVA5 = new JetBrainsAnnotationsLibraryDescriptor("annotations-java5"){

        @Override
        @NotNull
        public List<String> getLibraryClassesRoots() {
            File annotationsJar = new File(PathManager.getLibPath(), "annotations.jar");
            if (annotationsJar.exists()) {
                List<String> list = Collections.singletonList(FileUtil.toSystemIndependentName((String)annotationsJar.getAbsolutePath()));
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }
            List list = JetBrainsAnnotationsExternalLibraryResolver.getPathsToAnnotationsDirectoriesInDevelopmentMode("intellij.platform.annotations.java5");
            if (list == null) {
                1.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver$1", "getLibraryClassesRoots"));
        }
    };
    private static final ExternalLibraryDescriptor JAVA8 = new JetBrainsAnnotationsLibraryDescriptor("annotations"){

        @Override
        @NotNull
        public List<String> getLibraryClassesRoots() {
            File annotationsJar = new File(PathManager.getHomePath(), "redist/annotations-java8.jar");
            if (annotationsJar.exists()) {
                List<String> list = Collections.singletonList(FileUtil.toSystemIndependentName((String)annotationsJar.getAbsolutePath()));
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }
            List list = JetBrainsAnnotationsExternalLibraryResolver.getPathsToAnnotationsDirectoriesInDevelopmentMode("intellij.platform.annotations");
            if (list == null) {
                2.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver$2", "getLibraryClassesRoots"));
        }
    };

    @NotNull
    private static List<String> getPathsToAnnotationsDirectoriesInDevelopmentMode(String moduleName) {
        String annotationsRoot = PathManager.getJarPathForClass(Flow.class);
        if (annotationsRoot == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JetBrainsAnnotationsExternalLibraryResolver.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<String> list = Arrays.asList(annotationsRoot, FileUtil.toSystemIndependentName((String)new File(new File(annotationsRoot).getParentFile(), moduleName).getAbsolutePath()));
        if (list == null) {
            JetBrainsAnnotationsExternalLibraryResolver.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            JetBrainsAnnotationsExternalLibraryResolver.$$$reportNull$$$0(2);
        }
        if (isAnnotation == null) {
            JetBrainsAnnotationsExternalLibraryResolver.$$$reportNull$$$0(3);
        }
        if (contextModule == null) {
            JetBrainsAnnotationsExternalLibraryResolver.$$$reportNull$$$0(4);
        }
        if (AnnotationUtil.isJetbrainsAnnotation((String)shortClassName)) {
            ExternalLibraryDescriptor libraryDescriptor = JetBrainsAnnotationsExternalLibraryResolver.getAnnotationsLibraryDescriptor(contextModule);
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.jetbrains.annotations." + shortClassName, libraryDescriptor);
        }
        return null;
    }

    @NotNull
    public static ExternalLibraryDescriptor getAnnotationsLibraryDescriptor(@NotNull Module contextModule) {
        boolean java8;
        if (contextModule == null) {
            JetBrainsAnnotationsExternalLibraryResolver.$$$reportNull$$$0(5);
        }
        ExternalLibraryDescriptor externalLibraryDescriptor = (java8 = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)contextModule).isAtLeast(LanguageLevel.JDK_1_8)) ? JAVA8 : JAVA5;
        if (externalLibraryDescriptor == null) {
            JetBrainsAnnotationsExternalLibraryResolver.$$$reportNull$$$0(6);
        }
        return externalLibraryDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortClassName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToAnnotationsDirectoriesInDevelopmentMode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/JetBrainsAnnotationsExternalLibraryResolver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsLibraryDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationsLibraryDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class JetBrainsAnnotationsLibraryDescriptor
    extends ExternalLibraryDescriptor {
        public JetBrainsAnnotationsLibraryDescriptor(String artifactId) {
            super("org.jetbrains", artifactId);
        }
    }
}

