/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAddAllArrayToCollectionFix
implements IntentionAction {
    private final PsiMethodCallExpression myMethodCall;

    public ReplaceAddAllArrayToCollectionFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            ReplaceAddAllArrayToCollectionFix.$$$reportNull$$$0(0);
        }
        this.myMethodCall = methodCall;
    }

    @NotNull
    public String getText() {
        String string = "Replace " + this.myMethodCall.getText() + " with " + this.getCollectionsMethodCall();
        if (string == null) {
            ReplaceAddAllArrayToCollectionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ReplaceAddAllArrayToCollectionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ReplaceAddAllArrayToCollectionFix.$$$reportNull$$$0(3);
        }
        if (!this.myMethodCall.isValid()) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (jdk == null || !JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_5)) {
            return false;
        }
        PsiReferenceExpression expression2 = this.myMethodCall.getMethodExpression();
        PsiElement element = expression2.resolve();
        if (element instanceof PsiMethod) {
            PsiExpressionList list;
            PsiExpression[] expressions2;
            PsiParameter[] psiParameters;
            PsiMethod method = (PsiMethod)element;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass collectionsClass = psiFacade.findClass("java.util.Collection", GlobalSearchScope.allScope((Project)project));
            if (collectionsClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)collectionsClass, (boolean)true) && Comparing.strEqual((String)method.getName(), (String)"addAll") && PsiType.BOOLEAN.equals((Object)method.getReturnType()) && (psiParameters = method.getParameterList().getParameters()).length == 1 && psiParameters[0].getType() instanceof PsiClassType && InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClassType)psiParameters[0].getType()).resolve(), (PsiClass)collectionsClass, (boolean)true) && (expressions2 = (list = this.myMethodCall.getArgumentList()).getExpressions()).length == 1 && expressions2[0].getType() instanceof PsiArrayType) {
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ReplaceAddAllArrayToCollectionFix.$$$reportNull$$$0(4);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression toReplace = elementFactory.createExpressionFromText(this.getCollectionsMethodCall(), (PsiElement)this.myMethodCall);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(this.myMethodCall.replace((PsiElement)toReplace));
    }

    @NonNls
    private String getCollectionsMethodCall() {
        PsiExpression qualifierExpression2 = this.myMethodCall.getMethodExpression().getQualifierExpression();
        PsiExpression[] expressions2 = this.myMethodCall.getArgumentList().getExpressions();
        return "java.util.Collections.addAll(" + (qualifierExpression2 != null ? qualifierExpression2.getText() : "this") + ", " + (expressions2.length == 0 ? "" : expressions2[0].getText()) + ")";
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAddAllArrayToCollectionFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAddAllArrayToCollectionFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

