/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoFormatTypedHandler
extends TypedActionHandlerBase {
    private static boolean myIsEnabledInTests;
    private static final char[] NO_SPACE_AFTER;
    private static final List<IElementType> COMPLEX_ASSIGNMENTS;

    public AutoFormatTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    private static boolean isEnabled(Editor editor) {
        PsiFile file;
        boolean isEnabled;
        boolean bl = isEnabled = myIsEnabledInTests && ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"editor.reformat.on.typing");
        if (!isEnabled) {
            return false;
        }
        Project project = editor.getProject();
        Language language = null;
        if (project != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            language = file.getLanguage();
        }
        return language == JavaLanguage.INSTANCE;
    }

    public static void setEnabledInTests(boolean value2) {
        myIsEnabledInTests = value2;
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(1);
        }
        if (!AutoFormatTypedHandler.isEnabled(editor)) {
            this.executeOriginalHandler(editor, charTyped, dataContext);
            return;
        }
        if (AutoFormatTypedHandler.isInsertSpaceAtCaret(editor, charTyped, dataContext)) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
        }
        this.executeOriginalHandler(editor, charTyped, dataContext);
    }

    private static boolean isInsertSpaceAtCaret(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(3);
        }
        if (!AutoFormatTypedHandler.isSpaceAroundAssignment(editor, dataContext)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text2 = editor.getDocument().getImmutableCharSequence();
        HighlighterIterator lexerIterator = AutoFormatTypedHandler.createLexerIterator(editor, caretOffset);
        if (lexerIterator == null || lexerIterator.getTokenType() == JavaTokenType.STRING_LITERAL) {
            return false;
        }
        boolean insertBeforeEq = charTyped == '=' && AutoFormatTypedHandler.isInsertSpaceBeforeEq(caretOffset, text2);
        boolean insertAfterEq = caretOffset > 0 && caretOffset - 1 < text2.length() && text2.charAt(caretOffset - 1) == '=' && AutoFormatTypedHandler.isAssignmentOperator(lexerIterator) && AutoFormatTypedHandler.isInsertSpaceAfterEq(charTyped);
        return insertBeforeEq || insertAfterEq;
    }

    private static boolean isAssignmentOperator(HighlighterIterator iterator) {
        IElementType type2 = iterator.getTokenType();
        if (type2 == TokenType.WHITE_SPACE) {
            iterator.retreat();
            type2 = iterator.getTokenType();
        }
        if (COMPLEX_ASSIGNMENTS.indexOf(type2) >= 0) {
            return true;
        }
        if (type2 == JavaTokenType.EQ) {
            iterator.retreat();
            type2 = iterator.getTokenType();
            if (type2 == JavaTokenType.GT) {
                iterator.retreat();
                type2 = iterator.getTokenType();
                if (type2 == JavaTokenType.GT) {
                    return true;
                }
            } else if (type2 == TokenType.WHITE_SPACE || type2 == JavaTokenType.IDENTIFIER) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInsertSpaceAfterEq(char charTyped) {
        return charTyped != '=' && charTyped != ' ';
    }

    private static HighlighterIterator createLexerIterator(Editor editor, int offset) {
        if (editor.getDocument().getTextLength() == 0) {
            return null;
        }
        return editor instanceof EditorEx ? ((EditorEx)editor).getHighlighter().createIterator(offset) : null;
    }

    private void executeOriginalHandler(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            AutoFormatTypedHandler.$$$reportNull$$$0(5);
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
    }

    private static boolean isInsertSpaceBeforeEq(int caretOffset, CharSequence text2) {
        if (caretOffset == 0) {
            return false;
        }
        char charBefore = text2.charAt(caretOffset - 1);
        for (char c : NO_SPACE_AFTER) {
            if (c != charBefore) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpaceAroundAssignment(Editor editor, DataContext dataContext) {
        PsiFile file;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile psiFile = file = project == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file != null) {
            Language language = file.getLanguage();
            CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
            CommonCodeStyleSettings common = settings.getCommonSettings(language);
            return common.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        }
        return false;
    }

    static {
        NO_SPACE_AFTER = new char[]{'+', '-', '*', '/', '%', '&', '^', '|', '<', '>', '!', '=', ' '};
        COMPLEX_ASSIGNMENTS = ContainerUtil.newArrayList((Object[])new IElementType[]{JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.ANDEQ, JavaTokenType.XOREQ, JavaTokenType.OREQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsertSpaceAtCaret";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOriginalHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

