/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

public class JavaWithDoWhileSurrounder
extends JavaStatementsSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.dowhile.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, false)).length == 0) {
            return null;
        }
        String text2 = "do{\n}while(true);";
        PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)factory.createStatementFromText(text2, null);
        doWhileStatement = (PsiDoWhileStatement)codeStyleManager.reformat((PsiElement)doWhileStatement);
        PsiStatement body2 = (doWhileStatement = (PsiDoWhileStatement)container.addAfter((PsiElement)doWhileStatement, statements[statements.length - 1])).getBody();
        if (!(body2 instanceof PsiBlockStatement)) {
            return null;
        }
        PsiCodeBlock bodyBlock = ((PsiBlockStatement)body2).getCodeBlock();
        SurroundWithUtil.indentCommentIfNecessary(bodyBlock, statements);
        bodyBlock.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        PsiExpression condition2 = doWhileStatement.getCondition();
        return condition2 == null ? null : condition2.getTextRange();
    }
}

