/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SplitIfAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.SplitIfAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiPolyadicExpression expression2;
        if (project == null) {
            SplitIfAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SplitIfAction.$$$reportNull$$$0(1);
        }
        if ((expression2 = SplitConditionUtil.findCondition(element)) == null) {
            return false;
        }
        if (!(expression2.getParent() instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)expression2.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression2, (boolean)false)) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.split.if.text", (Object[])new Object[0]));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.if.family", (Object[])new Object[0]);
        if (string == null) {
            SplitIfAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token;
        if (project == null) {
            SplitIfAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SplitIfAction.$$$reportNull$$$0(4);
        }
        LOG.assertTrue((token = (PsiJavaToken)element).getTokenType() == JavaTokenType.ANDAND || token.getTokenType() == JavaTokenType.OROR);
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)token.getParent();
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiIfStatement.class);
        LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression2, (boolean)false));
        if (token.getTokenType() == JavaTokenType.ANDAND) {
            SplitIfAction.doAndSplit(ifStatement, expression2, token, editor);
        } else if (token.getTokenType() == JavaTokenType.OROR) {
            SplitIfAction.doOrSplit(ifStatement, expression2, token, editor);
        }
    }

    private static void doAndSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression2, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression2, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression2, token);
        PsiManager psiManager = ifStatement.getManager();
        PsiIfStatement subIf = (PsiIfStatement)ifStatement.copy();
        subIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        if (ifStatement.getThenBranch() instanceof PsiBlockStatement) {
            PsiBlockStatement blockStmt = (PsiBlockStatement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText("{}", null);
            blockStmt = (PsiBlockStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)blockStmt);
            blockStmt = (PsiBlockStatement)ifStatement.getThenBranch().replace((PsiElement)blockStmt);
            blockStmt.getCodeBlock().add((PsiElement)subIf);
        } else {
            ifStatement.getThenBranch().replace((PsiElement)subIf);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static void doOrSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression2, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression2, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression2, token);
        PsiIfStatement secondIf = (PsiIfStatement)ifStatement.copy();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
        }
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        secondIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.setElseBranch((PsiStatement)secondIf);
        if (elseBranch != null) {
            secondIf.setElseBranch(elseBranch);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitIfAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitIfAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

