/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

class PackageLookupItem
extends LookupElement {
    private final PsiPackage myPackage;
    private final String myString;

    public PackageLookupItem(PsiPackage pkg) {
        this.myPackage = pkg;
        this.myString = StringUtil.notNullize((String)this.myPackage.getName());
    }

    @NotNull
    public Object getObject() {
        PsiPackage psiPackage = this.myPackage;
        if (psiPackage == null) {
            PackageLookupItem.$$$reportNull$$$0(0);
        }
        return psiPackage;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myString;
        if (string == null) {
            PackageLookupItem.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    public void handleInsert(InsertionContext context) {
        boolean addDot;
        PsiFile file = context.getFile();
        boolean bl = addDot = !(file instanceof PsiJavaCodeReferenceCodeFragment) || ((PsiJavaCodeReferenceCodeFragment)file).isClassesAccepted();
        if (addDot) {
            context.setAddCompletionChar(false);
            TailType.DOT.processTail(context.getEditor(), context.getTailOffset());
        }
        if (addDot || context.getCompletionChar() == '.') {
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/lookup/PackageLookupItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

