/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates.editable;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaEditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaPostfixTemplateExpressionCondition;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPostfixTemplateEditor
implements PostfixTemplateEditor {
    @NotNull
    private final PostfixTemplateProvider myProvider;
    @NotNull
    private final Editor myTemplateEditor;
    @NotNull
    private final JBList<JavaPostfixTemplateExpressionCondition> myExpressionTypesList;
    @NotNull
    private final DefaultListModel<JavaPostfixTemplateExpressionCondition> myExpressionTypesListModel;
    private JPanel myPanel;
    private JBCheckBox myApplyToTheTopmostJBCheckBox;
    private ComboBox<LanguageLevel> myLanguageLevelCombo;
    private JBLabel myExpressionVariableHint;
    private JPanel myExpressionTypesPanel;
    private JPanel myTemplateEditorPanel;

    public JavaPostfixTemplateEditor(@NotNull PostfixTemplateProvider provider, @Nullable PostfixTemplate template) {
        if (provider == null) {
            JavaPostfixTemplateEditor.$$$reportNull$$$0(0);
        }
        this.myProvider = provider;
        this.$$$setupUI$$$();
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        this.myTemplateEditor = TemplateEditorUtil.createEditor((boolean)false, (Document)JavaPostfixTemplateEditor.createDocument(defaultProject), (Project)defaultProject);
        this.myExpressionTypesListModel = JBList.createDefaultListModel((Object[])new JavaPostfixTemplateExpressionCondition[0]);
        this.myExpressionTypesList = new JBList(this.myExpressionTypesListModel);
        this.myExpressionTypesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<JavaPostfixTemplateExpressionCondition>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JavaPostfixTemplateExpressionCondition> list, JavaPostfixTemplateExpressionCondition value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(value2.getPresentableName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/template/postfix/templates/editable/JavaPostfixTemplateEditor$1", "customizeCellRenderer"));
            }
        });
        this.myExpressionTypesPanel.setLayout(new BorderLayout());
        this.myExpressionTypesPanel.add(ToolbarDecorator.createDecorator(this.myExpressionTypesList).setAddAction(button -> this.addExpressionType((AnActionButton)button)).setRemoveAction(button -> ListUtil.removeSelectedItems(this.myExpressionTypesList)).disableUpDownActions().createPanel());
        this.myExpressionTypesPanel.setMinimumSize(new Dimension(-1, 100));
        this.myTemplateEditorPanel.setLayout(new BorderLayout());
        this.myTemplateEditorPanel.add(this.myTemplateEditor.getComponent());
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myExpressionVariableHint);
        this.myExpressionVariableHint.setFontColor(UIUtil.FontColor.BRIGHTER);
        if (template instanceof JavaEditablePostfixTemplate) {
            this.setTemplate((JavaEditablePostfixTemplate)template);
        }
    }

    private void createUIComponents() {
        this.myLanguageLevelCombo = new ComboBox((Object[])LanguageLevel.values());
        this.myLanguageLevelCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<LanguageLevel>(){

            protected void customizeCellRenderer(@NotNull JList list, LanguageLevel value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.append(value2.getPresentableText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/template/postfix/templates/editable/JavaPostfixTemplateEditor$2", "customizeCellRenderer"));
            }
        });
    }

    public void dispose() {
        TemplateEditorUtil.disposeTemplateEditor((Editor)this.myTemplateEditor);
    }

    @NotNull
    public JavaEditablePostfixTemplate createTemplate(@NotNull String templateId, @NotNull String templateName) {
        if (templateId == null) {
            JavaPostfixTemplateEditor.$$$reportNull$$$0(1);
        }
        if (templateName == null) {
            JavaPostfixTemplateEditor.$$$reportNull$$$0(2);
        }
        LanguageLevel selectedLanguageLevel = (LanguageLevel)ObjectUtils.tryCast((Object)this.myLanguageLevelCombo.getSelectedItem(), LanguageLevel.class);
        LanguageLevel languageLevel = (LanguageLevel)ObjectUtils.notNull((Object)selectedLanguageLevel, (Object)LanguageLevel.JDK_1_3);
        LinkedHashSet conditions = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAll((Collection)conditions, this.myExpressionTypesListModel.elements());
        String templateText = this.myTemplateEditor.getDocument().getText();
        boolean useTopmostExpression = this.myApplyToTheTopmostJBCheckBox.isSelected();
        JavaEditablePostfixTemplate javaEditablePostfixTemplate = new JavaEditablePostfixTemplate(templateId, templateName, templateText, "", (Set<JavaPostfixTemplateExpressionCondition>)conditions, languageLevel, useTopmostExpression, this.myProvider);
        if (javaEditablePostfixTemplate == null) {
            JavaPostfixTemplateEditor.$$$reportNull$$$0(3);
        }
        return javaEditablePostfixTemplate;
    }

    private void setTemplate(@NotNull JavaEditablePostfixTemplate template) {
        if (template == null) {
            JavaPostfixTemplateEditor.$$$reportNull$$$0(4);
        }
        this.myExpressionTypesListModel.clear();
        for (JavaPostfixTemplateExpressionCondition condition2 : template.getExpressionConditions()) {
            this.myExpressionTypesListModel.addElement(condition2);
        }
        this.myLanguageLevelCombo.setSelectedItem((Object)template.getMinimumLanguageLevel());
        this.myApplyToTheTopmostJBCheckBox.setSelected(template.isUseTopmostExpression());
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (template == null) {
                JavaPostfixTemplateEditor.$$$reportNull$$$0(7);
            }
            this.myTemplateEditor.getDocument().setText((CharSequence)template.getLiveTemplate().getString());
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            JavaPostfixTemplateEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public String getHelpId() {
        return "reference.custom.postfix.templates";
    }

    private static Document createDocument(@Nullable Project project) {
        if (project == null) {
            return EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        JavaCodeFragment fragment = factory.createCodeBlockCodeFragment("", (PsiElement)psiFacade.findPackage(""), true);
        DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)fragment, false);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }

    private void addExpressionType(@NotNull AnActionButton button) {
        Project[] projects;
        if (button == null) {
            JavaPostfixTemplateEditor.$$$reportNull$$$0(6);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddConditionAction(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateVoidExpressionCondition()));
        group.add((AnAction)new AddConditionAction(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNonVoidExpressionCondition()));
        group.add((AnAction)new AddConditionAction(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateBooleanExpressionCondition()));
        group.add((AnAction)new AddConditionAction(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNumberExpressionCondition()));
        group.add((AnAction)new AddConditionAction(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNotPrimitiveTypeExpressionCondition()));
        group.add((AnAction)new AddConditionAction(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateArrayExpressionCondition()));
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            group.add((AnAction)new ChooseClassAction(project));
        }
        group.add((AnAction)new ChooseClassAction(null));
        DataContext context = DataManager.getInstance().getDataContext((Component)button.getContextComponent());
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup.show((RelativePoint)ObjectUtils.assertNotNull((Object)button.getPreferredPopupPoint()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/editable/JavaPostfixTemplateEditor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/editable/JavaPostfixTemplateEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExpressionType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setTemplate$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myApplyToTheTopmostJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Apply to the topmost expression");
        jBCheckBox.setMnemonic('T');
        jBCheckBox.setDisplayedMnemonicIndex(13);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Minimum language level:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExpressionVariableHint = jBLabel = new JBLabel();
        jBLabel.setText("Use $EXPR$ variable to refer target expression");
        jPanel3.add((Component)jBLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        ComboBox<LanguageLevel> comboBox = this.myLanguageLevelCombo;
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myExpressionTypesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Applicable expression types:");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateEditorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ChooseClassAction
    extends DumbAwareAction {
        @Nullable
        private final Project myProject;

        protected ChooseClassAction(Project project) {
            super(project != null && !project.isDefault() ? "choose class in " + project.getName() + "..." : "enter class name...");
            this.myProject = project;
        }

        public void actionPerformed(AnActionEvent e) {
            String fqn = this.getFqn();
            if (fqn != null) {
                JavaPostfixTemplateEditor.this.myExpressionTypesListModel.addElement(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateExpressionFqnCondition(fqn));
            }
        }

        private String getFqn() {
            String title = "Choose Class";
            if (this.myProject == null || this.myProject.isDefault()) {
                return Messages.showInputDialog((Component)JavaPostfixTemplateEditor.this.myPanel, (String)title, (String)title, null);
            }
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.myProject).createAllProjectScopeChooser(title);
            chooser.showDialog();
            PsiClass selectedClass = chooser.getSelected();
            return selectedClass != null ? selectedClass.getQualifiedName() : null;
        }
    }

    private class AddConditionAction
    extends DumbAwareAction {
        @NotNull
        private final JavaPostfixTemplateExpressionCondition myCondition;

        public AddConditionAction(JavaPostfixTemplateExpressionCondition condition2) {
            super(condition2.getPresentableName());
            this.myCondition = condition2;
        }

        public void actionPerformed(AnActionEvent e) {
            JavaPostfixTemplateEditor.this.myExpressionTypesListModel.addElement(this.myCondition);
        }
    }
}

