/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyStreamApiCallChainsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall("java.util.Collection", "stream").parameterCount(0);
    private static final CallMatcher COLLECTION_CONTAINS = CallMatcher.instanceCall("java.util.Collection", "contains").parameterCount(1);
    private static final CallMatcher OPTIONAL_STREAM = CallMatcher.instanceCall("java.util.Optional", "stream").parameterCount(0);
    private static final CallMatcher STREAM_FIND = CallMatcher.instanceCall("java.util.stream.Stream", "findFirst", "findAny").parameterCount(0);
    private static final CallMatcher STREAM_FILTER = CallMatcher.instanceCall("java.util.stream.Stream", "filter").parameterTypes("java.util.function.Predicate");
    private static final CallMatcher STREAM_FIND_FIRST = CallMatcher.instanceCall("java.util.stream.BaseStream", "findFirst").parameterCount(0);
    private static final CallMatcher STREAM_SORTED = CallMatcher.instanceCall("java.util.stream.BaseStream", "sorted");
    private static final CallMatcher STREAM_MAP = CallMatcher.instanceCall("java.util.stream.Stream", "map").parameterTypes("java.util.function.Function");
    private static final CallMatcher BASE_STREAM_MAP = CallMatcher.instanceCall("java.util.stream.BaseStream", "map").parameterCount(1);
    private static final CallMatcher STREAM_ANY_MATCH = CallMatcher.instanceCall("java.util.stream.BaseStream", "anyMatch").parameterCount(1);
    private static final CallMatcher INT_STREAM_RANGE = CallMatcher.staticCall("java.util.stream.IntStream", "range").parameterTypes("int", "int");
    private static final CallMatcher STREAM_NONE_MATCH = CallMatcher.instanceCall("java.util.stream.BaseStream", "noneMatch").parameterCount(1);
    private static final CallMatcher STREAM_ALL_MATCH = CallMatcher.instanceCall("java.util.stream.BaseStream", "allMatch").parameterCount(1);
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterCount(1);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.instanceCall("java.util.Optional", "isPresent").parameterCount(0);
    private static final CallMatcher BOOLEAN_EQUALS = CallMatcher.instanceCall("java.lang.Boolean", "equals").parameterCount(1);
    private static final CallMatcher STREAM_OF = CallMatcher.staticCall("java.util.stream.Stream", "of").parameterTypes("T");
    private static final CallMatcher N_COPIES = CallMatcher.staticCall("java.util.Collections", "nCopies").parameterTypes("int", "T");
    private static final CallMatcher COMPARATOR_REVERSED = CallMatcher.instanceCall("java.util.Comparator", "reversed").parameterCount(0);
    private static final CallMatcher STREAM_INT_MAP_TO_ALL = CallMatcher.instanceCall("java.util.stream.IntStream", "map", "mapToObj", "mapToDouble", "mapToLong").parameterCount(1);
    private static final CallMatcher STREAM_MAP_TO_ALL = CallMatcher.instanceCall("java.util.stream.BaseStream", "map", "mapToInt", "mapToDouble", "mapToLong").parameterCount(1);
    private static final CallMatcher STREAM_MATCH = CallMatcher.anyOf(STREAM_ANY_MATCH, STREAM_NONE_MATCH, STREAM_ALL_MATCH);
    private static final CallMapper<CallChainSimplification> CALL_TO_FIX_MAPPER = new CallMapper(ReplaceCollectionStreamFix.handler(), ReplaceWithToArrayFix.handler(), ReplaceStreamSupportWithCollectionStreamFix.handler(), ReplaceWithBoxedFix.handler(), ReplaceWithElementIterationFix.handler(), ReplaceForEachMethodFix.handler(), RemoveBooleanIdentityFix.handler(), ReplaceWithPeekFix.handler(), SimpleStreamOfFix.handler(), RangeToArrayStreamFix.handler(), NCopiesToGenerateStreamFix.handler(), SortedFirstToMinMaxFix.handler(), AllMatchContainsFix.handler()).registerAll(SimplifyMatchNegationFix.handlers());
    private static final Logger LOG = Logger.getInstance(SimplifyStreamApiCallChainsInspection.class);
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String IF_PRESENT_METHOD = "ifPresent";
    private static final String STREAM_METHOD = "stream";
    private static final String EMPTY_METHOD = "empty";
    private static final String OF_METHOD = "of";
    private static final String ANY_MATCH_METHOD = "anyMatch";
    private static final String NONE_MATCH_METHOD = "noneMatch";
    private static final String ALL_MATCH_METHOD = "allMatch";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                CALL_TO_FIX_MAPPER.mapAll(methodCall).forEach(simplification -> {
                    if (holder == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    holder.registerProblem(nameElement, simplification.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix((CallChainFix)simplification)});
                });
                if (STREAM_COLLECT.test(methodCall)) {
                    this.handleStreamCollect(methodCall);
                } else if (OPTIONAL_IS_PRESENT.test(methodCall)) {
                    this.handleOptionalIsPresent(methodCall);
                }
            }

            private void handleOptionalIsPresent(PsiMethodCallExpression methodCall) {
                PsiMethodCallExpression optionalQualifier = MethodCallUtils.getQualifierMethodCall(methodCall);
                if (!STREAM_FIND.test(optionalQualifier)) {
                    return;
                }
                PsiMethodCallExpression streamQualifier = MethodCallUtils.getQualifierMethodCall(optionalQualifier);
                if (!STREAM_FILTER.test(streamQualifier)) {
                    return;
                }
                ReplaceOptionalIsPresentChainFix fix = new ReplaceOptionalIsPresentChainFix(optionalQualifier.getMethodExpression().getReferenceName());
                holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, streamQualifier), fix.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix(fix)});
            }

            private void handleStreamCollect(PsiMethodCallExpression methodCall) {
                PsiExpression parameter2 = methodCall.getArgumentList().getExpressions()[0];
                if (parameter2 instanceof PsiMethodCallExpression) {
                    String replacement;
                    PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter2;
                    ReplaceCollectorFix fix = ReplaceCollectorFix.COLLECTOR_TO_FIX_MAPPER.mapFirst(collectorCall);
                    if (fix != null) {
                        TextRange range = methodCall.getTextRange();
                        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                        if (nameElement != null) {
                            range = new TextRange(nameElement.getTextOffset(), range.getEndOffset());
                        }
                        holder.registerProblem((PsiElement)methodCall, range.shiftRight(-methodCall.getTextOffset()), fix.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix(fix)});
                    } else if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)methodCall.getType()) instanceof PsiTypeParameter) && (replacement = SimplifyCollectionCreationFix.COLLECTOR_TO_CLASS_MAPPER.mapFirst(collectorCall)) != null) {
                        PsiElement startElement;
                        PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall(methodCall);
                        if (COLLECTION_STREAM.test(qualifier) && (startElement = qualifier.getMethodExpression().getReferenceNameElement()) != null) {
                            holder.registerProblem((PsiElement)methodCall, new TextRange(startElement.getTextOffset() - methodCall.getTextOffset(), methodCall.getTextLength()), "Can be replaced with '" + replacement + "' constructor", new LocalQuickFix[]{new SimplifyCallChainFix(new SimplifyCollectionCreationFix(replacement))});
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$1", "lambda$visitMethodCallExpression$0"));
            }
        };
        if (javaElementVisitor == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    public static PsiElement simplifyStreamExpressions(PsiElement element) {
        boolean replaced = true;
        while (replaced) {
            replaced = false;
            Map callToSimplification = StreamEx.ofTree((Object)element, e -> StreamEx.of((Object[])e.getChildren())).select(PsiMethodCallExpression.class).mapToEntry(CALL_TO_FIX_MAPPER::mapFirst).nonNullValues().toMap();
            for (Map.Entry entry : callToSimplification.entrySet()) {
                PsiElement replacement;
                if (!((PsiMethodCallExpression)entry.getKey()).isValid() || (replacement = ((CallChainSimplification)entry.getValue()).simplify((PsiMethodCallExpression)entry.getKey())) == null) continue;
                replaced = true;
                if (element != entry.getKey()) continue;
                element = replacement;
            }
        }
        return element;
    }

    static CallMatcher collectorMatcher(String name, int parameterCount) {
        return CallMatcher.staticCall("java.util.stream.Collectors", name).parameterCount(parameterCount);
    }

    @NotNull
    protected static TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression2, @NotNull PsiMethodCallExpression qualifierExpression2) {
        PsiReferenceExpression qualifierMethodExpression;
        PsiElement qualifierNameElement;
        if (expression2 == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(3);
        }
        if (qualifierExpression2 == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(4);
        }
        int startOffset = ((qualifierNameElement = (qualifierMethodExpression = qualifierExpression2.getMethodExpression()).getReferenceNameElement()) != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression2.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression2.getTextOffset());
        if (textRange == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallChainRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCallChainRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AllMatchContainsFix
    implements CallChainSimplification {
        AllMatchContainsFix() {
        }

        @Override
        public String getName() {
            return "Can be replaced with 'containsAll'";
        }

        @Override
        public String getMessage() {
            return "Replace with 'containsAll'";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression left = AllMatchContainsFix.extractLeft(call);
            if (left == null) {
                return null;
            }
            PsiExpression right = AllMatchContainsFix.extractRight(call);
            if (right == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = ct.text((PsiElement)right) + ".containsAll(" + ct.text((PsiElement)left) + ")";
            return ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        @Nullable
        private static PsiExpression extractRight(PsiMethodCallExpression allMatchCall) {
            PsiLambdaExpression lambda2;
            PsiParameter[] parameters2;
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)allMatchCall.getArgumentList().getExpressions()[0]);
            if (arg instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)arg;
                if (COLLECTION_CONTAINS.methodReferenceMatches(methodRef) && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef) && !ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)methodRef)) {
                    return methodRef.getQualifierExpression();
                }
            } else if (arg instanceof PsiLambdaExpression && (parameters2 = (lambda2 = (PsiLambdaExpression)arg).getParameterList().getParameters()).length == 1) {
                PsiParameter parameter2 = parameters2[0];
                PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
                if (COLLECTION_CONTAINS.test(call) && ExpressionUtils.isReferenceTo(call.getArgumentList().getExpressions()[0], (PsiVariable)parameter2) && !ExpressionUtil.isEffectivelyUnqualified(call.getMethodExpression())) {
                    return call.getMethodExpression().getQualifierExpression();
                }
            }
            return null;
        }

        @Nullable
        private static PsiExpression extractLeft(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (!COLLECTION_STREAM.test(qualifierCall) || ExpressionUtil.isEffectivelyUnqualified(qualifierCall.getMethodExpression())) {
                return null;
            }
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierCall.getMethodExpression().getQualifierExpression());
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(CallMatcher.instanceCall("java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD).parameterCount(1), call -> {
                if (AllMatchContainsFix.extractLeft(call) == null || AllMatchContainsFix.extractRight(call) == null) {
                    return null;
                }
                return new AllMatchContainsFix();
            });
        }
    }

    static class SortedFirstToMinMaxFix
    implements CallChainSimplification {
        private final String myMethodName;
        private final String myReplacement;

        SortedFirstToMinMaxFix(String methodName, String replacement) {
            this.myMethodName = methodName;
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace with " + this.myMethodName + "()";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with " + this.myMethodName + "()";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            return new CommentTracker().replaceAndRestoreComments((PsiElement)call, this.myReplacement);
        }

        @NotNull
        static CallHandler<CallChainSimplification> handler() {
            CallHandler<CallChainSimplification> callHandler = CallHandler.of(STREAM_FIND_FIRST, call -> {
                String comparator;
                PsiMethodCallExpression maybeSorted = MethodCallUtils.getQualifierMethodCall(call);
                if (!STREAM_SORTED.test(maybeSorted)) {
                    return null;
                }
                PsiExpression[] args = maybeSorted.getArgumentList().getExpressions();
                PsiExpression qualifier = maybeSorted.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return null;
                }
                boolean reversed = false;
                if (args.length == 1) {
                    PsiExpression maybeComparator = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]);
                    if (maybeComparator instanceof PsiMethodCallExpression && COMPARATOR_REVERSED.test((PsiMethodCallExpression)maybeComparator)) {
                        PsiExpression comparatorQualifier = ((PsiMethodCallExpression)maybeComparator).getMethodExpression().getQualifierExpression();
                        if (comparatorQualifier == null) {
                            return null;
                        }
                        comparator = comparatorQualifier.getText();
                        reversed = true;
                    } else {
                        PsiType comparatorType;
                        if (maybeComparator == null) {
                            return null;
                        }
                        PsiType psiType = comparatorType = maybeComparator instanceof PsiFunctionalExpression ? ((PsiFunctionalExpression)maybeComparator).getFunctionalInterfaceType() : maybeComparator.getType();
                        if (comparatorType == null || !InheritanceUtil.isInheritor((PsiType)comparatorType, (String)"java.util.Comparator")) {
                            return null;
                        }
                        comparator = maybeComparator.getText();
                    }
                } else {
                    return null;
                }
                String methodName = reversed ? "max" : "min";
                return new SortedFirstToMinMaxFix(methodName, qualifier.getText() + "." + methodName + "(" + comparator + ")");
            });
            if (callHandler == null) {
                SortedFirstToMinMaxFix.$$$reportNull$$$0(0);
            }
            return callHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SortedFirstToMinMaxFix", "handler"));
        }
    }

    static class NCopiesToGenerateStreamFix
    implements CallChainSimplification {
        @NotNull
        private final String myReplacement;

        NCopiesToGenerateStreamFix(@NotNull String replacement) {
            if (replacement == null) {
                NCopiesToGenerateStreamFix.$$$reportNull$$$0(0);
            }
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace with Stream.generate()";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with Stream.generate()";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression streamCall) {
            PsiMethodCallExpression maybeMap = ExpressionUtils.getCallForQualifier((PsiExpression)streamCall);
            if (maybeMap == null) {
                return null;
            }
            Project project = streamCall.getProject();
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)maybeMap, this.myReplacement);
            return JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
        }

        @NotNull
        static CallHandler<CallChainSimplification> handler() {
            CallHandler<CallChainSimplification> callHandler = CallHandler.of(COLLECTION_STREAM, call -> {
                PsiMethodCallExpression maybeNCopies = MethodCallUtils.getQualifierMethodCall(call);
                if (!N_COPIES.test(maybeNCopies)) {
                    return null;
                }
                PsiExpression[] nCopiesArgs = maybeNCopies.getArgumentList().getExpressions();
                PsiExpression count = nCopiesArgs[0];
                PsiExpression obj = nCopiesArgs[1];
                if (!ExpressionUtils.isSafelyRecomputableExpression(obj)) {
                    return null;
                }
                PsiMethodCallExpression maybeMap = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (!STREAM_MAP_TO_ALL.test(maybeMap)) {
                    return null;
                }
                PsiExpression arg = maybeMap.getArgumentList().getExpressions()[0];
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiLambdaExpression.class);
                if (lambda2 == null) {
                    return null;
                }
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 1) {
                    return null;
                }
                PsiParameter lambdaVar = parameters2[0];
                PsiExpression body2 = (PsiExpression)ObjectUtils.tryCast((Object)lambda2.getBody(), PsiExpression.class);
                if (body2 == null || body2.getType() == null) {
                    return null;
                }
                String streamClass = NCopiesToGenerateStreamFix.getStreamClassName(maybeMap);
                if (VariableAccessUtils.variableIsUsed((PsiVariable)lambdaVar, (PsiElement)body2)) {
                    return null;
                }
                return new NCopiesToGenerateStreamFix(streamClass + ".generate(()->" + body2.getText() + ").limit(" + count.getText() + ")");
            });
            if (callHandler == null) {
                NCopiesToGenerateStreamFix.$$$reportNull$$$0(1);
            }
            return callHandler;
        }

        private static String getStreamClassName(@NotNull PsiMethodCallExpression call) {
            String name;
            if (call == null) {
                NCopiesToGenerateStreamFix.$$$reportNull$$$0(2);
            }
            if ((name = MethodCallUtils.getMethodName(call)) == null) {
                return "java.util.stream.Stream";
            }
            switch (name) {
                case "mapToInt": {
                    return "java.util.stream.IntStream";
                }
                case "mapToLong": {
                    return "java.util.stream.LongStream";
                }
                case "mapToDouble": {
                    return "java.util.stream.DoubleStream";
                }
            }
            return "java.util.stream.Stream";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$NCopiesToGenerateStreamFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$NCopiesToGenerateStreamFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStreamClassName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class RangeToArrayStreamFix
    implements CallChainSimplification {
        @NotNull
        private final String myReplacement;

        RangeToArrayStreamFix(@NotNull String replacement) {
            if (replacement == null) {
                RangeToArrayStreamFix.$$$reportNull$$$0(0);
            }
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace with Arrays.stream()";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with Arrays.stream()";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiMethodCallExpression mapCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            if (mapCall == null) {
                return null;
            }
            return new CommentTracker().replaceAndRestoreComments((PsiElement)mapCall, this.myReplacement);
        }

        @NotNull
        static CallHandler<CallChainSimplification> handler() {
            CallHandler<CallChainSimplification> callHandler = CallHandler.of(INT_STREAM_RANGE, call -> {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiMethodCallExpression maybeMap = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (!STREAM_INT_MAP_TO_ALL.test(maybeMap)) {
                    return null;
                }
                PsiExpression arg = maybeMap.getArgumentList().getExpressions()[0];
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)arg, PsiLambdaExpression.class);
                if (lambda2 == null) {
                    return null;
                }
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 1) {
                    return null;
                }
                PsiExpression lambdaExpr = (PsiExpression)ObjectUtils.tryCast((Object)lambda2.getBody(), PsiExpression.class);
                if (lambdaExpr == null) {
                    return null;
                }
                PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)lambdaExpr), PsiArrayAccessExpression.class);
                if (arrayAccess == null) {
                    return null;
                }
                PsiExpression index = arrayAccess.getIndexExpression();
                if (!ExpressionUtils.isReferenceTo(index, (PsiVariable)parameters2[0])) {
                    return null;
                }
                PsiExpression arrayExpr = arrayAccess.getArrayExpression();
                PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)arrayExpr.getType(), PsiArrayType.class);
                if (arrayType == null) {
                    return null;
                }
                if (!StreamApiUtil.isSupportedStreamElement(arrayType.getComponentType())) {
                    return null;
                }
                PsiExpression leftBound = args[0];
                PsiExpression rightBound = args[1];
                return new RangeToArrayStreamFix("java.util.Arrays.stream(" + arrayExpr.getText() + "," + leftBound.getText() + "," + rightBound.getText() + ")");
            });
            if (callHandler == null) {
                RangeToArrayStreamFix.$$$reportNull$$$0(1);
            }
            return callHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$RangeToArrayStreamFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$RangeToArrayStreamFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceStreamSupportWithCollectionStreamFix
    implements CallChainSimplification {
        private static final CallMatcher STREAM_SUPPORT = CallMatcher.staticCall("java.util.stream.StreamSupport", "stream").parameterTypes("java.util.Spliterator", "boolean");
        private static final CallMatcher SPLITERATOR = CallMatcher.instanceCall("java.util.Collection", "spliterator").parameterCount(0);
        private final String myQualifierText;
        private final boolean myParallel;

        public ReplaceStreamSupportWithCollectionStreamFix(PsiExpression qualifier, boolean parallel) {
            this.myQualifierText = PsiExpressionTrimRenderer.render((PsiExpression)qualifier, (int)50);
            this.myParallel = parallel;
        }

        @Override
        public String getName() {
            return "Replace with '" + this.myQualifierText + "." + this.getMethodName() + "' call";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with '" + this.myQualifierText + "." + this.getMethodName() + "' call";
        }

        @NotNull
        private String getMethodName() {
            String string = this.myParallel ? "parallelStream" : SimplifyStreamApiCallChainsInspection.STREAM_METHOD;
            if (string == null) {
                ReplaceStreamSupportWithCollectionStreamFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return null;
            }
            PsiMethodCallExpression spliteratorCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
            if (spliteratorCall == null) {
                return null;
            }
            ExpressionUtils.bindCallTo(spliteratorCall, this.getMethodName());
            CommentTracker ct = new CommentTracker();
            return ct.replace((PsiElement)call, (PsiElement)spliteratorCall);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(STREAM_SUPPORT, call -> {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiExpression parallel = args[1];
                if (!ExpressionUtils.isLiteral((PsiElement)parallel, Boolean.TRUE) && !ExpressionUtils.isLiteral((PsiElement)parallel, Boolean.FALSE)) {
                    return null;
                }
                PsiMethodCallExpression spliterator = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
                if (!SPLITERATOR.test(spliterator)) {
                    return null;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)spliterator.getMethodExpression().getQualifierExpression());
                if (qualifier == null || qualifier instanceof PsiThisExpression) {
                    return null;
                }
                return new ReplaceStreamSupportWithCollectionStreamFix(qualifier, ExpressionUtils.isLiteral((PsiElement)parallel, Boolean.TRUE));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamSupportWithCollectionStreamFix", "getMethodName"));
        }
    }

    private static class RemoveBooleanIdentityFix
    implements CallChainSimplification {
        private final boolean myInvert;

        public RemoveBooleanIdentityFix(boolean invert) {
            this.myInvert = invert;
        }

        @Override
        public String getName() {
            return "Merge with previous 'map' call";
        }

        @Override
        public String getMessage() {
            return "Can be merged with previous 'map' call";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall(call);
            if (qualifier == null) {
                return null;
            }
            String name = call.getMethodExpression().getReferenceName();
            if (name == null) {
                return null;
            }
            if (this.myInvert) {
                if (name.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD)) {
                    name = SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD;
                } else if (name.equals(SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD)) {
                    name = SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD;
                } else {
                    return null;
                }
            }
            PsiExpression[] args = qualifier.getArgumentList().getExpressions();
            CommentTracker ct = new CommentTracker();
            if (args.length == 1) {
                PsiExpression arg = args[0];
                String replacement = RemoveBooleanIdentityFix.adaptToPredicate(ct.markUnchanged(arg));
                if (replacement == null) {
                    return null;
                }
                ct.replace((PsiElement)arg, replacement);
            }
            ExpressionUtils.bindCallTo(qualifier, name);
            return ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)ct.markUnchanged(qualifier));
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(STREAM_MATCH, call -> {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
                if (!STREAM_MAP.test(qualifierCall)) {
                    return null;
                }
                PsiExpression qualifierArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierCall.getArgumentList().getExpressions()[0]);
                PsiExpression predicate = call.getArgumentList().getExpressions()[0];
                boolean invert = false;
                if (!RemoveBooleanIdentityFix.isBooleanIdentity(predicate)) {
                    Boolean target = RemoveBooleanIdentityFix.getBooleanEqualsTarget(predicate);
                    if (target == null || !target.booleanValue() && SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD.equals(call.getMethodExpression().getReferenceName())) {
                        return null;
                    }
                    boolean bl = invert = target == false;
                    if (qualifierArg instanceof PsiMethodReferenceExpression) {
                        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)((PsiMethodReferenceExpression)qualifierArg).resolve(), PsiMethod.class);
                        if (method == null) {
                            return null;
                        }
                        if (!PsiType.BOOLEAN.equals((Object)method.getReturnType()) && !NullableNotNullManager.isNotNull((PsiModifierListOwner)method)) {
                            return null;
                        }
                    } else if (!(qualifierArg instanceof PsiLambdaExpression) || DfaUtil.inferLambdaNullity((PsiLambdaExpression)qualifierArg) != Nullness.NOT_NULL) {
                        return null;
                    }
                } else if (RemoveBooleanIdentityFix.adaptToPredicate(qualifierArg) == null) {
                    return null;
                }
                return new RemoveBooleanIdentityFix(invert);
            });
        }

        private static boolean isBooleanIdentity(PsiExpression arg) {
            if (FunctionalExpressionUtils.isFunctionalReferenceTo(arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), "java.lang.Boolean", (PsiType)PsiType.BOOLEAN, "booleanValue", PsiType.EMPTY_ARRAY) || FunctionalExpressionUtils.isFunctionalReferenceTo(arg, "java.lang.Boolean", null, "valueOf", new PsiType[]{PsiType.BOOLEAN})) {
                return true;
            }
            return arg instanceof PsiLambdaExpression && LambdaUtil.isIdentityLambda((PsiLambdaExpression)((PsiLambdaExpression)arg));
        }

        @Nullable
        private static Boolean getBooleanEqualsTarget(PsiExpression arg) {
            arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg);
            PsiReferenceExpression qualifier = null;
            if (arg instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)arg;
                if (!BOOLEAN_EQUALS.methodReferenceMatches(methodRef)) {
                    return null;
                }
                qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)methodRef.getQualifierExpression(), PsiReferenceExpression.class);
            } else if (arg instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)arg;
                PsiParameter parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda2.getParameterList().getParameters());
                if (parameter2 == null) {
                    return null;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()), PsiMethodCallExpression.class);
                if (!BOOLEAN_EQUALS.test(call)) {
                    return null;
                }
                if (!ExpressionUtils.isReferenceTo(call.getArgumentList().getExpressions()[0], (PsiVariable)parameter2)) {
                    return null;
                }
                qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression().getQualifierExpression(), PsiReferenceExpression.class);
            }
            if (qualifier == null) {
                return null;
            }
            PsiField field = (PsiField)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiField.class);
            if (field == null) {
                return null;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass != null && "java.lang.Boolean".equals(containingClass.getQualifiedName())) {
                String name = field.getName();
                if ("TRUE".equals(name)) {
                    return Boolean.TRUE;
                }
                if ("FALSE".equals(name)) {
                    return Boolean.FALSE;
                }
            }
            return null;
        }

        @Nullable
        private static String adaptToPredicate(PsiExpression expression2) {
            if (expression2 == null) {
                return null;
            }
            String text2 = expression2.getText();
            if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
                return null;
            }
            if (expression2 instanceof PsiFunctionalExpression) {
                return text2;
            }
            if (expression2 instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)expression2;
                String thenBranch = RemoveBooleanIdentityFix.adaptToPredicate(ternary.getThenExpression());
                String elseBranch = RemoveBooleanIdentityFix.adaptToPredicate(ternary.getElseExpression());
                if (thenBranch == null || elseBranch == null) {
                    return null;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
                PsiConditionalExpression copy = (PsiConditionalExpression)factory.createExpressionFromText(text2, (PsiElement)expression2);
                Objects.requireNonNull(copy.getThenExpression()).replace((PsiElement)factory.createExpressionFromText(thenBranch, (PsiElement)expression2));
                Objects.requireNonNull(copy.getElseExpression()).replace((PsiElement)factory.createExpressionFromText(elseBranch, (PsiElement)expression2));
                return copy.getText();
            }
            String adapted = ParenthesesUtils.getText(expression2, 2) + "::apply";
            PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)expression2.getType(), PsiClassType.class);
            if (type2 == null) {
                return null;
            }
            if (type2.rawType().equalsToText("java.util.function.Function")) {
                return adapted;
            }
            PsiClass typeClass = type2.resolve();
            if (typeClass == null) {
                return null;
            }
            PsiMethod[] methods = typeClass.findMethodsByName("apply", true);
            if (methods.length != 1 || methods[0].getContainingClass() == null || !"java.util.function.Function".equals(methods[0].getContainingClass().getQualifiedName())) {
                return null;
            }
            return adapted;
        }
    }

    private static class ReplaceWithElementIterationFix
    implements CallChainSimplification {
        private static final CallMatcher INT_STREAM_MAP = CallMatcher.instanceCall("java.util.stream.IntStream", "map", "mapToLong", "mapToDouble", "mapToObj").parameterCount(1);
        private static final CallMatcher MIN_INT = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Integer", "min").parameterTypes("int", "int"));
        private final String myName;

        public ReplaceWithElementIterationFix(IndexedContainer container, String name) {
            PsiExpression qualifier = container.getQualifier();
            String qualifierText = PsiExpressionTrimRenderer.render((PsiExpression)qualifier, (int)50);
            PsiType type2 = qualifier.getType();
            String replacement = type2 instanceof PsiArrayType ? "Arrays.stream(" + qualifierText + ")" : qualifierText + ".stream()";
            this.myName = "Replace IntStream.range()." + name + "() with " + replacement;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public String getMessage() {
            return "Can be replaced with element iteration";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression mapToObjCall) {
            String name;
            Project project = mapToObjCall.getProject();
            PsiExpression mapper = (PsiExpression)ArrayUtil.getFirstElement((Object[])mapToObjCall.getArgumentList().getExpressions());
            LimitedContainer limitedContainer = ReplaceWithElementIterationFix.extractContainer(MethodCallUtils.getQualifierMethodCall(mapToObjCall), mapper);
            if (limitedContainer == null) {
                return null;
            }
            IndexedContainer container = limitedContainer.myContainer;
            PsiExpression limit = limitedContainer.myLimit;
            PsiExpression containerQualifier = container.getQualifier();
            PsiType type2 = containerQualifier.getType();
            PsiType elementType = container.getElementType();
            PsiType outElementType = StreamApiUtil.getStreamElementType(mapToObjCall.getType());
            if (type2 == null || elementType == null) {
                return null;
            }
            String replacement = type2 instanceof PsiArrayType ? "java.util.Arrays.stream(" + containerQualifier.getText() + ")" : ParenthesesUtils.getText(containerQualifier, 2) + ".stream()";
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            if (limit != null) {
                replacement = replacement + ".limit(" + ct.text((PsiElement)limit) + ")";
            }
            if (mapper instanceof PsiMethodReferenceExpression) {
                mapper = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)mapper, false, true);
            }
            if (!(mapper instanceof PsiLambdaExpression)) {
                return null;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)mapper;
            PsiParameter indexParameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda2.getParameterList().getParameters());
            PsiElement body2 = lambda2.getBody();
            if (body2 == null || indexParameter == null) {
                return null;
            }
            String nameCandidate = null;
            if (containerQualifier instanceof PsiReferenceExpression && (name = ((PsiReferenceExpression)containerQualifier).getReferenceName()) != null && name.equals(nameCandidate = StringUtil.unpluralize((String)name))) {
                nameCandidate = null;
            }
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, nameCandidate, null, elementType, true);
            nameCandidate = (String)ArrayUtil.getFirstElement((Object[])info.names);
            String name2 = javaCodeStyleManager.suggestUniqueVariableName(nameCandidate == null ? "item" : nameCandidate, (PsiElement)mapToObjCall, true);
            Collection refs = ReferencesSearch.search((PsiElement)indexParameter, (SearchScope)new LocalSearchScope(body2)).findAll();
            for (PsiReference ref : refs) {
                PsiExpression getExpression = container.extractGetExpressionFromIndex((PsiExpression)ObjectUtils.tryCast((Object)ref, PsiExpression.class));
                if (getExpression == null) continue;
                PsiElement result = ct.replace((PsiElement)getExpression, (PsiElement)factory.createIdentifier(name2));
                if (getExpression != body2) continue;
                body2 = result;
            }
            PsiLambdaExpression newLambda = (PsiLambdaExpression)factory.createExpressionFromText("(" + elementType.getCanonicalText() + " " + name2 + ")->" + ct.text(body2), (PsiElement)mapToObjCall);
            PsiParameter newParameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])newLambda.getParameterList().getParameters());
            replacement = replacement + StreamRefactoringUtil.generateMapOperation((PsiVariable)newParameter, outElementType, newLambda.getBody());
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)mapToObjCall, replacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            return CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(INT_STREAM_MAP, call -> {
                PsiExpression mapper = call.getArgumentList().getExpressions()[0];
                LimitedContainer limitedContainer = ReplaceWithElementIterationFix.extractContainer(MethodCallUtils.getQualifierMethodCall(call), mapper);
                if (limitedContainer == null) {
                    return null;
                }
                return new ReplaceWithElementIterationFix(limitedContainer.myContainer, call.getMethodExpression().getReferenceName());
            });
        }

        @Contract(value="null, _ -> null")
        private static LimitedContainer extractContainer(PsiMethodCallExpression qualifierCall, PsiExpression mapper) {
            if (!INT_STREAM_RANGE.test(qualifierCall)) {
                return null;
            }
            PsiExpression[] rangeArgs = qualifierCall.getArgumentList().getExpressions();
            if (!ExpressionUtils.isZero(rangeArgs[0])) {
                return null;
            }
            PsiExpression bound = ExpressionUtils.resolveExpression(rangeArgs[1]);
            IndexedContainer container = IndexedContainer.fromLengthExpression(bound);
            PsiExpression limit = null;
            if (container == null) {
                if (bound instanceof PsiMethodCallExpression && MIN_INT.test((PsiMethodCallExpression)bound)) {
                    PsiExpression[] args = ((PsiMethodCallExpression)bound).getArgumentList().getExpressions();
                    container = IndexedContainer.fromLengthExpression(args[0]);
                    if (container != null) {
                        limit = args[1];
                    } else {
                        container = IndexedContainer.fromLengthExpression(args[1]);
                        if (container != null) {
                            limit = args[0];
                        }
                    }
                }
                if (container == null) {
                    return null;
                }
            }
            if (!StreamApiUtil.isSupportedStreamElement(container.getElementType())) {
                return null;
            }
            LimitedContainer limitedContainer = new LimitedContainer(container, limit);
            if (mapper instanceof PsiMethodReferenceExpression && container.isGetMethodReference((PsiMethodReferenceExpression)mapper)) {
                return limitedContainer;
            }
            if (mapper instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)mapper;
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 1) {
                    return null;
                }
                PsiParameter indexParameter = parameters2[0];
                PsiElement body2 = lambda2.getBody();
                if (body2 == null) {
                    return null;
                }
                Collection refs = ReferencesSearch.search((PsiElement)indexParameter, (SearchScope)new LocalSearchScope(body2)).findAll();
                if (!refs.isEmpty() && refs.stream().allMatch(ref -> limitedContainer.myContainer.extractGetExpressionFromIndex((PsiExpression)ObjectUtils.tryCast((Object)ref, PsiExpression.class)) != null)) {
                    return limitedContainer;
                }
            }
            return null;
        }

        static class LimitedContainer {
            @NotNull
            final IndexedContainer myContainer;
            @Nullable
            final PsiExpression myLimit;

            LimitedContainer(@NotNull IndexedContainer container, @Nullable PsiExpression limit) {
                if (container == null) {
                    LimitedContainer.$$$reportNull$$$0(0);
                }
                this.myContainer = container;
                this.myLimit = limit;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithElementIterationFix$LimitedContainer", "<init>"));
            }
        }
    }

    private static class ReplaceWithToArrayFix
    implements CallChainSimplification {
        private static final CallMatcher TO_ARRAY = CallMatcher.instanceCall("java.util.stream.Stream", "toArray");
        private final String myReplacement;

        private ReplaceWithToArrayFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace 'stream().toArray()' with 'toArray()'";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with collection.toArray()";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression toArrayCall) {
            PsiMethodCallExpression streamCall = MethodCallUtils.getQualifierMethodCall(toArrayCall);
            if (streamCall == null) {
                return null;
            }
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            return ct.replaceAndRestoreComments((PsiElement)toArrayCall, ct.text((PsiElement)collectionExpression) + ".toArray(" + this.myReplacement + ")");
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(TO_ARRAY, methodCall -> {
                if (!COLLECTION_STREAM.test(MethodCallUtils.getQualifierMethodCall(methodCall))) {
                    return null;
                }
                PsiArrayType type2 = ReplaceWithToArrayFix.getArrayType(methodCall);
                if (type2 == null) {
                    return null;
                }
                String replacement = type2.equalsToText("java.lang.Object[]") ? "" : "new " + type2.getCanonicalText().replaceFirst("\\[]", "[0]");
                return new ReplaceWithToArrayFix(replacement);
            });
        }

        @Nullable
        private static PsiArrayType getArrayType(PsiMethodCallExpression call) {
            PsiType type2 = call.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return null;
            }
            PsiArrayType candidate = (PsiArrayType)type2;
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 0) {
                return candidate;
            }
            if (args.length != 1) {
                return null;
            }
            PsiExpression supplier = args[0];
            if (supplier instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)supplier;
                PsiTypeElement qualifierType = methodRef.getQualifierType();
                if (methodRef.isConstructor() && qualifierType != null && candidate.isAssignableFrom(qualifierType.getType())) {
                    return candidate;
                }
            } else if (supplier instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)supplier;
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 1) {
                    return null;
                }
                PsiParameter sizeParameter = parameters2[0];
                PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
                if (body2 instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)body2;
                    PsiExpression[] dimensions = newExpression.getArrayDimensions();
                    PsiType newExpressionType = newExpression.getType();
                    if (dimensions.length != 0 && ExpressionUtils.isReferenceTo(dimensions[0], (PsiVariable)sizeParameter) && newExpressionType != null && candidate.isAssignableFrom(newExpressionType)) {
                        return candidate;
                    }
                }
            }
            return null;
        }
    }

    private static class ReplaceWithBoxedFix
    implements CallChainSimplification {
        private static final CallMatcher MAP_TO_OBJ = CallMatcher.instanceCall("java.util.stream.BaseStream", "mapToObj").parameterCount(1);

        private ReplaceWithBoxedFix() {
        }

        @Override
        public String getName() {
            return "Replace with 'boxed'";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with 'boxed'";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            ExpressionUtils.bindCallTo(call, "boxed");
            args[0].delete();
            call.getTypeArgumentList().delete();
            return call;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(MAP_TO_OBJ, call -> {
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                PsiType type2 = StreamApiUtil.getStreamElementType(call.getType());
                PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
                if (targetClass == null) {
                    return null;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null || !TypeConversionUtil.boxingConversionApplicable((PsiType)StreamApiUtil.getStreamElementType(qualifier.getType()), (PsiType)type2) || !ReplaceWithBoxedFix.isBoxingFunction(arg, targetClass)) {
                    return null;
                }
                return new ReplaceWithBoxedFix();
            });
        }

        @Contract(value="null, _ -> false")
        private static boolean isBoxingFunction(PsiExpression arg, PsiClass targetClass) {
            PsiMethod method;
            PsiElement target;
            if (arg instanceof PsiMethodReferenceExpression && (target = ((PsiMethodReferenceExpression)arg).resolve()) instanceof PsiMethod && targetClass == (method = (PsiMethod)target).getContainingClass() && (method.isConstructor() || method.getName().equals("valueOf")) && method.getParameterList().getParametersCount() == 1) {
                return true;
            }
            if (arg instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)arg;
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 1) {
                    return false;
                }
                PsiParameter parameter2 = parameters2[0];
                PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
                if (ExpressionUtils.isReferenceTo(expression2, (PsiVariable)parameter2)) {
                    return true;
                }
                if (expression2 instanceof PsiCallExpression) {
                    PsiMethod method2;
                    PsiJavaCodeReferenceElement ref;
                    PsiExpressionList list = ((PsiCallExpression)expression2).getArgumentList();
                    if (list == null) {
                        return false;
                    }
                    PsiExpression[] args = list.getExpressions();
                    if (args.length != 1 || !ExpressionUtils.isReferenceTo(args[0], (PsiVariable)parameter2)) {
                        return false;
                    }
                    if (expression2 instanceof PsiNewExpression && (ref = ((PsiNewExpression)expression2).getClassReference()) != null && ref.isReferenceTo((PsiElement)targetClass)) {
                        return true;
                    }
                    if (expression2 instanceof PsiMethodCallExpression && (method2 = ((PsiMethodCallExpression)expression2).resolveMethod()) != null && method2.getContainingClass() == targetClass && method2.getName().equals("valueOf")) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class SimpleStreamOfFix
    implements CallChainSimplification {
        private static final CallMatcher LAMBDA_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "anyMatch", "allMatch", "noneMatch", "forEach", "forEachOrdered").parameterCount(1);
        private static final CallMatcher OPTIONAL_TERMINAL = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.BaseStream", "findFirst", "findAny").parameterCount(0), CallMatcher.instanceCall("java.util.stream.BaseStream", "min", "max", "reduce").parameterCount(1));
        private final ReplacementMode myMode;

        public SimpleStreamOfFix(ReplacementMode mode) {
            this.myMode = mode;
        }

        @Override
        public String getName() {
            switch (this.myMode) {
                case OPTIONAL: {
                    return "Replace with 'Optional.of'";
                }
            }
            return "Use Stream element explicitly";
        }

        @Override
        public String getMessage() {
            return "Unnecessary single-element Stream";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression streamOfCall) {
            String replacement;
            PsiExpression streamOfArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])streamOfCall.getArgumentList().getExpressions());
            if (streamOfArg == null) {
                return null;
            }
            PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)streamOfCall);
            PsiExpression nextArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])nextCall.getArgumentList().getExpressions());
            if (this.myMode == ReplacementMode.OPTIONAL) {
                replacement = "java.util.Optional.of(" + streamOfArg.getText() + ")";
            } else {
                if (nextArg == null) {
                    return null;
                }
                PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)nextArg.getType());
                if (method == null) {
                    return null;
                }
                String name = method.getName();
                replacement = (this.myMode == ReplacementMode.NEGATED_FUNCTION ? "!" : "") + nextArg.getText() + "." + name + "(" + streamOfArg.getText() + ")";
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)streamOfCall.getProject());
            PsiExpression result = factory.createExpressionFromText(replacement, (PsiElement)streamOfCall);
            return nextCall.replace((PsiElement)result);
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(STREAM_OF, call -> {
                PsiExpression arg;
                PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (nextCall == null) {
                    return null;
                }
                if (LAMBDA_TERMINAL.test(nextCall) && ((arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextCall.getArgumentList().getExpressions()[0])) instanceof PsiReferenceExpression || arg instanceof PsiMethodCallExpression)) {
                    PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)arg.getType());
                    boolean negate = SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD.equals(nextCall.getMethodExpression().getReferenceName());
                    if (method == null || negate && PsiUtil.skipParenthesizedExprUp((PsiElement)nextCall.getParent()) instanceof PsiExpressionStatement) {
                        return null;
                    }
                    return new SimpleStreamOfFix(negate ? ReplacementMode.NEGATED_FUNCTION : ReplacementMode.FUNCTION);
                }
                if (OPTIONAL_TERMINAL.test(nextCall)) {
                    return new SimpleStreamOfFix(ReplacementMode.OPTIONAL);
                }
                return null;
            });
        }

        static enum ReplacementMode {
            OPTIONAL,
            FUNCTION,
            NEGATED_FUNCTION;

        }
    }

    private static class ReplaceWithPeekFix
    implements CallChainSimplification {
        private ReplaceWithPeekFix() {
        }

        @Override
        public String getName() {
            return "Replace with 'peek'";
        }

        @Override
        public String getMessage() {
            return "Can be replaced with 'peek'";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
            if (lambda2 == null) {
                return null;
            }
            PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)lambda2.getBody(), PsiCodeBlock.class);
            if (block == null) {
                return null;
            }
            PsiReturnStatement statement = (PsiReturnStatement)ObjectUtils.tryCast((Object)ArrayUtil.getLastElement((Object[])block.getStatements()), PsiReturnStatement.class);
            if (statement == null) {
                return null;
            }
            ExpressionUtils.bindCallTo(call, "peek");
            new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
            LambdaRefactoringUtil.simplifyToExpressionLambda(lambda2);
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2);
            return call;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(BASE_STREAM_MAP, call -> {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
                if (lambda2 == null) {
                    return null;
                }
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 1) {
                    return null;
                }
                PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)lambda2.getBody(), PsiCodeBlock.class);
                if (block == null) {
                    return null;
                }
                Object[] statements = block.getStatements();
                if (statements.length <= 1) {
                    return null;
                }
                PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)ArrayUtil.getLastElement((Object[])statements), PsiReturnStatement.class);
                PsiParameter parameter2 = parameters2[0];
                if (returnStatement == null || !ExpressionUtils.isReferenceTo(returnStatement.getReturnValue(), (PsiVariable)parameter2)) {
                    return null;
                }
                if (VariableAccessUtils.variableIsAssigned((PsiVariable)parameter2)) {
                    return null;
                }
                if (Arrays.stream(statements, 0, statements.length - 1).anyMatch(ControlFlowUtils::containsReturn)) {
                    return null;
                }
                return new ReplaceWithPeekFix();
            });
        }
    }

    private static class SimplifyCollectionCreationFix
    implements CallChainFix {
        static final CallMapper<String> COLLECTOR_TO_CLASS_MAPPER = new CallMapper<String>().register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toList", 0), "java.util.ArrayList").register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toSet", 0), "java.util.HashSet").register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toCollection", 1), (String)((Object)((Function<PsiMethodCallExpression, String>)SimplifyCollectionCreationFix::getCollectionClass)));
        private final String myReplacement;

        public SimplifyCollectionCreationFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return "Replace with '" + this.myReplacement + "' constructor";
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                SimplifyCollectionCreationFix.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression collectCall = (PsiMethodCallExpression)element;
            PsiType type2 = collectCall.getType();
            PsiClass resolvedType = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            if (resolvedType == null || resolvedType instanceof PsiTypeParameter) {
                return;
            }
            PsiMethodCallExpression streamCall = MethodCallUtils.getQualifierMethodCall(collectCall);
            if (streamCall == null) {
                return;
            }
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return;
            }
            String typeText = type2.getCanonicalText();
            if ("java.util.List".equals(resolvedType.getQualifiedName()) || "java.util.Set".equals(resolvedType.getQualifiedName())) {
                PsiType[] parameters2 = ((PsiClassType)type2).getParameters();
                if (parameters2.length != 1) {
                    return;
                }
                typeText = this.myReplacement + "<" + parameters2[0].getCanonicalText() + ">";
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression result = factory.createExpressionFromText("new " + typeText + "(" + collectionExpression.getText() + ")", element);
            PsiNewExpression newExpression = (PsiNewExpression)element.replace((PsiElement)result);
            PsiJavaCodeReferenceElement classReference2 = newExpression.getClassOrAnonymousClassReference();
            LOG.assertTrue(classReference2 != null);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)classReference2);
            if (PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, newExpression, null)) {
                PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)classReference2.getParameterList());
            }
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newExpression);
        }

        @Nullable
        private static String getCollectionClass(PsiMethodCallExpression call) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiMethodReferenceExpression.class);
            if (methodRef == null || !methodRef.isConstructor()) {
                return null;
            }
            PsiMethod ctor = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            if (ctor == null || !ctor.getParameterList().isEmpty()) {
                return null;
            }
            PsiClass aClass = ctor.getContainingClass();
            if (aClass == null) {
                return null;
            }
            String name = aClass.getQualifiedName();
            if (name != null && name.startsWith("java.util.") && Stream.of(aClass.getConstructors()).anyMatch(SimplifyCollectionCreationFix::isCollectionConstructor)) {
                return name;
            }
            return null;
        }

        @Contract(value="null -> false")
        private static boolean isCollectionConstructor(PsiMethod ctor) {
            if (ctor == null || !ctor.getModifierList().hasExplicitModifier("public")) {
                return false;
            }
            PsiParameterList list = ctor.getParameterList();
            if (list.getParametersCount() != 1) {
                return false;
            }
            PsiTypeElement typeElement = list.getParameters()[0].getTypeElement();
            if (typeElement == null) {
                return false;
            }
            PsiType type2 = typeElement.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            return aClass != null && "java.util.Collection".equals(aClass.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCollectionCreationFix", "applyFix"));
        }
    }

    private static class SimplifyMatchNegationFix
    implements CallChainSimplification {
        private final String myFrom;
        private final String myTo;

        private SimplifyMatchNegationFix(PsiMethodCallExpression call, boolean argNegated, boolean parentNegated, String to) {
            String name = call.getMethodExpression().getReferenceName();
            String arg = argNegated ? "x -> !(...)" : "...";
            String className = Objects.requireNonNull(Objects.requireNonNull(call.resolveMethod()).getContainingClass()).getName();
            this.myFrom = (parentNegated ? "!" : "") + className + "." + name + "(" + arg + ")";
            this.myTo = to;
        }

        @Override
        public String getName() {
            return "Replace " + this.myFrom + " with " + this.myTo + "(...)";
        }

        @Override
        public String getMessage() {
            return this.myFrom + " can be replaced with " + this.myTo + "(...)";
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression methodCall) {
            boolean removeParentNegation;
            boolean removeLambdaNegation;
            String from = methodCall.getMethodExpression().getReferenceName();
            if (from == null) {
                return null;
            }
            switch (from) {
                case "allMatch": {
                    removeLambdaNegation = true;
                    removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                    break;
                }
                case "anyMatch": {
                    removeParentNegation = true;
                    removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                    break;
                }
                case "noneMatch": {
                    removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                    removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (removeParentNegation && !SimplifyMatchNegationFix.isParentNegated(methodCall)) {
                return null;
            }
            if (removeLambdaNegation && !SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall)) {
                return null;
            }
            ExpressionUtils.bindCallTo(methodCall, this.myTo);
            if (removeLambdaNegation) {
                PsiExpression body2 = (PsiExpression)((PsiLambdaExpression)methodCall.getArgumentList().getExpressions()[0]).getBody();
                PsiExpression negated = BoolUtils.getNegated(body2);
                LOG.assertTrue(negated != null);
                body2.replace((PsiElement)negated);
            }
            if (removeParentNegation) {
                return PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent()).replace((PsiElement)methodCall);
            }
            return methodCall;
        }

        static boolean isParentNegated(PsiMethodCallExpression methodCall) {
            if (ExpressionUtil.isEffectivelyUnqualified(methodCall.getMethodExpression())) {
                return false;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
            return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
        }

        static boolean isArgumentLambdaNegated(PsiMethodCallExpression methodCall) {
            if (ExpressionUtil.isEffectivelyUnqualified(methodCall.getMethodExpression())) {
                return false;
            }
            PsiExpression[] expressions2 = methodCall.getArgumentList().getExpressions();
            if (expressions2.length != 1) {
                return false;
            }
            PsiExpression arg = expressions2[0];
            if (!(arg instanceof PsiLambdaExpression)) {
                return false;
            }
            PsiElement body2 = ((PsiLambdaExpression)arg).getBody();
            return body2 instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)body2);
        }

        static List<CallHandler<CallChainSimplification>> handlers() {
            return Arrays.asList(CallHandler.of(STREAM_ANY_MATCH, methodCall -> {
                boolean argNegated;
                if (!SimplifyMatchNegationFix.isParentNegated(methodCall)) {
                    return null;
                }
                return new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, argNegated, true, (argNegated = SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall)) ? SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD);
            }), CallHandler.of(STREAM_NONE_MATCH, methodCall -> SimplifyMatchNegationFix.isParentNegated(methodCall) ? new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, false, true, SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD) : null), CallHandler.of(STREAM_NONE_MATCH, methodCall -> SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall) ? new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, true, false, SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD) : null), CallHandler.of(STREAM_ALL_MATCH, methodCall -> {
                boolean parentNegated;
                if (!SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall)) {
                    return null;
                }
                return new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, true, parentNegated, (parentNegated = SimplifyMatchNegationFix.isParentNegated(methodCall)) ? SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD);
            }));
        }
    }

    private static class ReplaceOptionalIsPresentChainFix
    implements CallChainFix {
        private final String myFindMethodName;

        ReplaceOptionalIsPresentChainFix(String findMethodName) {
            this.myFindMethodName = findMethodName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace 'filter()." + this.myFindMethodName + "().isPresent()' with 'anyMatch()'";
            if (string == null) {
                ReplaceOptionalIsPresentChainFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            PsiMethodCallExpression findCall;
            PsiExpression findQualifier;
            PsiMethodCallExpression isPresentCall;
            PsiExpression isPresentQualifier;
            if (project == null) {
                ReplaceOptionalIsPresentChainFix.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMethodCallExpression && (isPresentQualifier = (isPresentCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && (findQualifier = (findCall = (PsiMethodCallExpression)isPresentQualifier).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression filterCall = (PsiMethodCallExpression)findQualifier;
                PsiElement replacement = element.replace((PsiElement)filterCall);
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiElement filterName = ((PsiMethodCallExpression)replacement).getMethodExpression().getReferenceNameElement();
                LOG.assertTrue(filterName != null);
                filterName.replace((PsiElement)factory.createIdentifier(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD));
            }
        }

        @NotNull
        public String getMessage() {
            String string = "The 'filter()." + this.myFindMethodName + "().isPresent()' chain can be replaced with 'anyMatch()'";
            if (string == null) {
                ReplaceOptionalIsPresentChainFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceCollectorFix
    implements CallChainFix {
        static final CallMapper<ReplaceCollectorFix> COLLECTOR_TO_FIX_MAPPER = new CallMapper(ReplaceCollectorFix.handler("counting", 0, "count()", false), ReplaceCollectorFix.handler("minBy", 1, "min({0})", true), ReplaceCollectorFix.handler("maxBy", 1, "max({0})", true), ReplaceCollectorFix.handler("mapping", 2, "map({0}).collect({1})", false), ReplaceCollectorFix.handler("reducing", 1, "reduce({0})", true), ReplaceCollectorFix.handler("reducing", 2, "reduce({0}, {1})", false), ReplaceCollectorFix.handler("reducing", 3, "map({1}).reduce({0}, {2})", false), ReplaceCollectorFix.handler("summingInt", 1, "mapToInt({0}).sum()", false), ReplaceCollectorFix.handler("summingLong", 1, "mapToLong({0}).sum()", false), ReplaceCollectorFix.handler("summingDouble", 1, "mapToDouble({0}).sum()", false));
        private final String myCollector;
        private final String myStreamSequence;
        private final String myStreamSequenceStripped;
        private final boolean myChangeSemantics;

        public ReplaceCollectorFix(String collector, String streamSequence, boolean changeSemantics) {
            this.myCollector = collector;
            this.myStreamSequence = streamSequence;
            this.myStreamSequenceStripped = streamSequence.replaceAll("\\([^)]+\\)", "()");
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace 'collect(" + this.myCollector + "())' with '" + this.myStreamSequenceStripped + "'" + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                ReplaceCollectorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            PsiExpression parameter2;
            PsiMethodCallExpression collectCall;
            PsiExpression qualifierExpression2;
            if (project == null) {
                ReplaceCollectorFix.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMethodCallExpression && (qualifierExpression2 = (collectCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) != null && (parameter2 = collectCall.getArgumentList().getExpressions()[0]) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter2;
                PsiExpression[] collectorArgs = collectorCall.getArgumentList().getExpressions();
                String result = MessageFormat.format(this.myStreamSequence, Arrays.stream(collectorArgs).map(PsiElement::getText).toArray());
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression replacement = factory.createExpressionFromText(qualifierExpression2.getText() + "." + result, (PsiElement)collectCall);
                ReplaceCollectorFix.addBoxingIfNecessary(factory, collectCall.replace((PsiElement)replacement));
            }
        }

        private static void addBoxingIfNecessary(PsiElementFactory factory, PsiElement expression2) {
            PsiExpression castExpression;
            PsiElement cast;
            PsiClassType boxedType;
            PsiType type2;
            if (expression2 instanceof PsiExpression && (type2 = ((PsiExpression)expression2).getType()) instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)type2).getBoxedType(expression2)) != null && (cast = expression2.replace((PsiElement)(castExpression = factory.createExpressionFromText("(" + boxedType.getCanonicalText() + ") " + expression2.getText(), expression2)))) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)cast))) {
                RedundantCastUtil.removeCast((PsiTypeCastExpression)((PsiTypeCastExpression)cast));
            }
        }

        @NotNull
        public String getMessage() {
            String string = "The 'collect(" + this.myCollector + "())' call can be replaced with '" + this.myStreamSequenceStripped + "'" + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                ReplaceCollectorFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        static CallHandler<ReplaceCollectorFix> handler(String collectorName, int parameterCount, String template, boolean changeSemantics) {
            return CallHandler.of(SimplifyStreamApiCallChainsInspection.collectorMatcher(collectorName, parameterCount), call -> new ReplaceCollectorFix(collectorName, template, changeSemantics));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ReplaceForEachMethodFix
    implements CallChainSimplification {
        private static final CallMatcher STREAM_FOR_EACH = CallMatcher.instanceCall("java.util.stream.Stream", "forEach", "forEachOrdered").parameterCount(1);
        private final String myStreamMethod;
        private final String myReplacementMethod;
        private final boolean myChangeSemantics;

        public ReplaceForEachMethodFix(String streamMethod, String replacementMethod, boolean changeSemantics) {
            this.myStreamMethod = streamMethod;
            this.myReplacementMethod = replacementMethod;
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace 'stream()." + this.myStreamMethod + "()' with '" + this.myReplacementMethod + "()'" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                ReplaceForEachMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = "The 'stream()." + this.myStreamMethod + "()' chain can be replaced with '" + this.myReplacementMethod + "()'" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                ReplaceForEachMethodFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression streamMethodCall) {
            PsiMethodCallExpression collectionStreamCall = MethodCallUtils.getQualifierMethodCall(streamMethodCall);
            if (collectionStreamCall == null) {
                return null;
            }
            PsiExpression collectionExpression = collectionStreamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return null;
            }
            collectionStreamCall.replace((PsiElement)collectionExpression);
            ExpressionUtils.bindCallTo(streamMethodCall, this.myReplacementMethod);
            return streamMethodCall;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(STREAM_FOR_EACH, call -> {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
                if (COLLECTION_STREAM.test(qualifierCall)) {
                    return new ReplaceForEachMethodFix(call.getMethodExpression().getReferenceName(), SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, true);
                }
                if (OPTIONAL_STREAM.test(qualifierCall)) {
                    return new ReplaceForEachMethodFix(call.getMethodExpression().getReferenceName(), SimplifyStreamApiCallChainsInspection.IF_PRESENT_METHOD, false);
                }
                return null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceForEachMethodFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ReplaceSingletonWithStreamOfFix
    extends ReplaceCollectionStreamFix {
        private ReplaceSingletonWithStreamOfFix(String qualifierCall) {
            super(qualifierCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD);
        }

        @Override
        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            PsiType argType;
            String typeParameter;
            if (qualifierCall == null) {
                ReplaceSingletonWithStreamOfFix.$$$reportNull$$$0(0);
            }
            if ((typeParameter = super.getTypeParameter(qualifierCall)) != null) {
                return typeParameter;
            }
            PsiType[] argTypes = qualifierCall.getArgumentList().getExpressionTypes();
            if (argTypes.length == 1 && (argType = argTypes[0]) instanceof PsiArrayType) {
                return argType.getCanonicalText();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceSingletonWithStreamOfFix", "getTypeParameter"));
        }
    }

    private static class ReplaceCollectionStreamFix
    implements CallChainSimplification {
        private static final CallMatcher EMPTY_LIST = CallMatcher.staticCall("java.util.Collections", "emptyList").parameterCount(0);
        private static final CallMatcher EMPTY_SET = CallMatcher.staticCall("java.util.Collections", "emptySet").parameterCount(0);
        private static final CallMatcher SINGLETON_LIST = CallMatcher.staticCall("java.util.Collections", "singletonList").parameterCount(1);
        private static final CallMatcher SINGLETON = CallMatcher.staticCall("java.util.Collections", "singleton").parameterCount(1);
        private static final CallMatcher AS_LIST = CallMatcher.staticCall("java.util.Arrays", "asList").parameterCount(1);
        private static final CallMatcher ENUMSET_OF = CallMatcher.staticCall("java.util.EnumSet", "of");
        private static final CallMapper<ReplaceCollectionStreamFix> COLLECTION_TO_STREAM_MAPPER = new CallMapper<ReplaceCollectionStreamFix>().register(EMPTY_LIST, new ReplaceCollectionStreamFix("Collections.emptyList()", "java.util.stream.Stream", "empty")).register(EMPTY_SET, new ReplaceCollectionStreamFix("Collections.emptySet()", "java.util.stream.Stream", "empty")).register(SINGLETON, (ReplaceCollectionStreamFix)((Object)((Function<PsiMethodCallExpression, ReplaceCollectionStreamFix>)call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? null : new ReplaceSingletonWithStreamOfFix("Collections.singleton()")))).register(SINGLETON_LIST, call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? null : new ReplaceSingletonWithStreamOfFix("Collections.singletonList()")).register(AS_LIST, call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? new ReplaceCollectionStreamFix("Arrays.asList()", "java.util.Arrays", SimplifyStreamApiCallChainsInspection.STREAM_METHOD) : new ReplaceCollectionStreamFix("Arrays.asList()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD)).register(ENUMSET_OF, call -> ReplaceCollectionStreamFix.isEnumSetReplaceableWithStream(call) ? new ReplaceCollectionStreamFix("EnumSet.of()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD) : null);
        private final String myClassName;
        private final String myMethodName;
        private final String myQualifierCall;

        private ReplaceCollectionStreamFix(String qualifierCall, String className, String methodName) {
            this.myQualifierCall = qualifierCall;
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = this.myQualifierCall + ".stream() can be replaced with " + ClassUtil.extractClassName((String)this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                ReplaceCollectionStreamFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace " + this.myQualifierCall + ".stream() with " + ClassUtil.extractClassName((String)this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                ReplaceCollectionStreamFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            PsiType[] parameters2;
            if (qualifierCall == null) {
                ReplaceCollectionStreamFix.$$$reportNull$$$0(2);
            }
            return (parameters2 = qualifierCall.getMethodExpression().getTypeParameters()).length == 1 ? parameters2[0].getCanonicalText() : null;
        }

        @Override
        @Nullable
        public PsiElement simplify(PsiMethodCallExpression streamCall) {
            PsiMethodCallExpression collectionCall = MethodCallUtils.getQualifierMethodCall(streamCall);
            if (collectionCall == null) {
                return null;
            }
            streamCall.getArgumentList().replace((PsiElement)collectionCall.getArgumentList());
            String typeParameter = this.getTypeParameter(collectionCall);
            String replacement = typeParameter != null ? this.myClassName + ".<" + typeParameter + ">" + this.myMethodName : this.myClassName + "." + this.myMethodName;
            Project project = streamCall.getProject();
            PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(replacement, (PsiElement)streamCall);
            return JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(streamCall.getMethodExpression().replace((PsiElement)newMethodExpression));
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of(COLLECTION_STREAM, methodCall -> COLLECTION_TO_STREAM_MAPPER.mapFirst(MethodCallUtils.getQualifierMethodCall(methodCall)));
        }

        private static boolean isEnumSetReplaceableWithStream(PsiMethodCallExpression call) {
            PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
            if (expressions2.length == 0) {
                return false;
            }
            HashSet<String> names = new HashSet<String>();
            PsiClass enumClass = null;
            for (PsiExpression arg : expressions2) {
                PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiReferenceExpression.class);
                if (ref == null) {
                    return false;
                }
                PsiEnumConstant enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)ref.resolve(), PsiEnumConstant.class);
                if (enumConstant == null || !names.add(enumConstant.getName())) {
                    return false;
                }
                if (enumClass == null) {
                    enumClass = enumConstant.getContainingClass();
                    continue;
                }
                if (enumConstant.getContainingClass() == enumClass) continue;
                return false;
            }
            return true;
        }

        private static boolean hasSingleArrayArgument(PsiMethodCallExpression qualifierCall) {
            PsiType type2;
            PsiExpression[] argumentExpressions = qualifierCall.getArgumentList().getExpressions();
            if (argumentExpressions.length == 1 && (type2 = argumentExpressions[0].getType()) instanceof PsiArrayType) {
                PsiType[] parameters2;
                PsiType methodType = qualifierCall.getType();
                return !(methodType instanceof PsiClassType) || (parameters2 = ((PsiClassType)methodType).getParameters()).length != 1 || !TypeConversionUtil.isAssignable((PsiType)parameters2[0], (PsiType)type2) || TypeConversionUtil.isAssignable((PsiType)parameters2[0], (PsiType)((PsiArrayType)type2).getComponentType());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeParameter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SimplifyCallChainFix
    implements LocalQuickFix {
        private final CallChainFix myFix;

        SimplifyCallChainFix(CallChainFix fix) {
            this.myFix = fix;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myFix.getName();
            if (string == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify stream call chain" == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(1);
            }
            return "Simplify stream call chain";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(3);
            }
            this.myFix.applyFix(project, descriptor.getStartElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface CallChainSimplification
    extends CallChainFix {
        public String getMessage();

        @Override
        default public void applyFix(@NotNull Project project, PsiElement element) {
            PsiMethodCallExpression call;
            if (project == null) {
                CallChainSimplification.$$$reportNull$$$0(0);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false)) != null) {
                this.simplify(call);
            }
        }

        public PsiElement simplify(PsiMethodCallExpression var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainSimplification", "applyFix"));
        }
    }

    static interface CallChainFix {
        public String getName();

        public void applyFix(@NotNull Project var1, PsiElement var2);
    }
}

