/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;

public abstract class ContractValue {
    ContractValue() {
    }

    abstract DfaValue makeDfaValue(DfaValueFactory var1, DfaCallArguments var2);

    public boolean isBoundCheckingCondition() {
        return false;
    }

    public static ContractValue qualifier() {
        return Qualifier.INSTANCE;
    }

    public static ContractValue argument(int index) {
        return new Argument(index);
    }

    public ContractValue specialField(SpecialField field) {
        return new Spec(this, field);
    }

    public static ContractValue constant(Object value2, PsiType type2) {
        return new IndependentValue((Function<DfaValueFactory, DfaValue>)((Function)factory -> factory.getConstFactory().createFromValue(value2, type2, null)), String.valueOf(value2));
    }

    public static ContractValue booleanValue(boolean value2) {
        return value2 ? IndependentValue.TRUE : IndependentValue.FALSE;
    }

    public static ContractValue optionalValue(boolean present) {
        return present ? IndependentValue.OPTIONAL_PRESENT : IndependentValue.OPTIONAL_ABSENT;
    }

    public static ContractValue nullValue() {
        return IndependentValue.NULL;
    }

    public static ContractValue zero() {
        return IndependentValue.ZERO;
    }

    public static ContractValue condition(ContractValue left, DfaRelationValue.RelationType relation, ContractValue right) {
        return new Condition(left, relation, right);
    }

    private static class Condition
    extends ContractValue {
        private final ContractValue myLeft;
        private final ContractValue myRight;
        private final DfaRelationValue.RelationType myRelationType;

        Condition(ContractValue left, DfaRelationValue.RelationType type2, ContractValue right) {
            this.myLeft = left;
            this.myRight = right;
            this.myRelationType = type2;
        }

        @Override
        public boolean isBoundCheckingCondition() {
            switch (this.myRelationType) {
                case LE: 
                case LT: 
                case GE: 
                case GT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return factory.createCondition(this.myLeft.makeDfaValue(factory, arguments), this.myRelationType, this.myRight.makeDfaValue(factory, arguments));
        }

        public String toString() {
            return this.myLeft + " " + (Object)((Object)this.myRelationType) + " " + this.myRight;
        }
    }

    private static class Spec
    extends ContractValue {
        private final ContractValue myQualifier;
        private final SpecialField myField;

        Spec(ContractValue qualifier, SpecialField field) {
            this.myQualifier = qualifier;
            this.myField = field;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return this.myField.createValue(factory, this.myQualifier.makeDfaValue(factory, arguments));
        }

        public String toString() {
            return this.myQualifier + "." + this.myField.getMethodName() + "()";
        }
    }

    private static class IndependentValue
    extends ContractValue {
        static final IndependentValue NULL = new IndependentValue((Function<DfaValueFactory, DfaValue>)((Function)factory -> factory.getConstFactory().getNull()), "null");
        static final IndependentValue TRUE = new IndependentValue((Function<DfaValueFactory, DfaValue>)((Function)factory -> factory.getConstFactory().getTrue()), "true");
        static final IndependentValue FALSE = new IndependentValue((Function<DfaValueFactory, DfaValue>)((Function)factory -> factory.getConstFactory().getFalse()), "false");
        static final IndependentValue OPTIONAL_PRESENT = new IndependentValue((Function<DfaValueFactory, DfaValue>)((Function)factory -> factory.getFactValue(DfaFactType.OPTIONAL_PRESENCE, true)), "present");
        static final IndependentValue OPTIONAL_ABSENT = new IndependentValue((Function<DfaValueFactory, DfaValue>)((Function)factory -> factory.getFactValue(DfaFactType.OPTIONAL_PRESENCE, false)), "empty");
        static final IndependentValue ZERO = new IndependentValue((Function<DfaValueFactory, DfaValue>)((Function)factory -> factory.getInt(0)), "0");
        private final Function<DfaValueFactory, DfaValue> mySupplier;
        private final String myPresentation;

        IndependentValue(Function<DfaValueFactory, DfaValue> supplier, String presentation) {
            this.mySupplier = supplier;
            this.myPresentation = presentation;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return (DfaValue)this.mySupplier.fun((Object)factory);
        }

        public String toString() {
            return this.myPresentation;
        }
    }

    private static class Argument
    extends ContractValue {
        private final int myIndex;

        Argument(int index) {
            this.myIndex = index;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            if (arguments.myArguments.length <= this.myIndex) {
                return DfaUnknownValue.getInstance();
            }
            DfaValue arg = arguments.myArguments[this.myIndex];
            return arg instanceof DfaBoxedValue ? ((DfaBoxedValue)arg).getWrappedValue() : arg;
        }

        public String toString() {
            return "arg#" + this.myIndex;
        }
    }

    private static class Qualifier
    extends ContractValue {
        static final Qualifier INSTANCE = new Qualifier();

        private Qualifier() {
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return arguments.myQualifier;
        }

        public String toString() {
            return "this";
        }
    }
}

