/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaModuleNamingInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaModuleNamingInspection.$$$reportNull$$$0(0);
        }
        Object object = !PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? PsiElementVisitor.EMPTY_VISITOR : new JavaElementVisitor(){

            public void visitModule(PsiJavaModule module) {
                super.visitModule(module);
                PsiJavaModuleReferenceElement name = module.getNameIdentifier();
                Ref newName = Ref.create();
                SyntaxTraverser.psiTraverser().children((Object)name).filter(PsiIdentifier.class).forEach(id -> {
                    String text2;
                    if (holder == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((text2 = id.getText()).length() > 0 && Character.isDigit(text2.charAt(text2.length() - 1))) {
                        String message2 = InspectionsBundle.message((String)"inspection.java.module.naming.terminal.digits", (Object[])new Object[]{text2});
                        if (newName.isNull()) {
                            newName.set((Object)StringUtil.join((Iterable)SyntaxTraverser.psiTraverser().children((Object)name).filter(PsiIdentifier.class).map(i -> JavaModuleNamingInspection.trimDigits(i.getText())), (String)"."));
                        }
                        holder.registerProblem((PsiElement)id, message2, new LocalQuickFix[]{QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)module, (String)newName.get())});
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection$1", "lambda$visitModule$1"));
            }
        };
        if (object == null) {
            JavaModuleNamingInspection.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static String trimDigits(String text2) {
        int p;
        for (p = text2.length(); p > 0 && Character.isDigit(text2.charAt(p - 1)); --p) {
        }
        return text2.substring(0, p);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

