/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefImplicitConstructorImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefClassImpl
extends RefJavaElementImpl
implements RefClass {
    private static final Set<RefElement> EMPTY_SET = Collections.emptySet();
    private static final Set<RefClass> EMPTY_CLASS_SET = Collections.emptySet();
    private static final List<RefMethod> EMPTY_METHOD_LIST = ContainerUtil.emptyList();
    private static final int IS_ANONYMOUS_MASK = 65536;
    private static final int IS_INTERFACE_MASK = 131072;
    private static final int IS_UTILITY_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_APPLET_MASK = 0x200000;
    private static final int IS_SERVLET_MASK = 0x400000;
    private static final int IS_TESTCASE_MASK = 0x800000;
    private static final int IS_LOCAL_MASK = 0x1000000;
    private static final int IS_ANDROID_MASK = 0x2000000;
    private Set<RefClass> myBases;
    private Set<RefClass> mySubClasses;
    private List<RefMethod> myConstructors;
    private RefMethodImpl myDefaultConstructor;
    private List<RefMethod> myOverridingMethods;
    private Set<RefElement> myInTypeReferences;
    private Set<RefElement> myInstanceReferences;
    private List<RefJavaElement> myClassExporters;
    private final RefModule myRefModule;

    RefClassImpl(PsiClass psiClass, RefManager manager) {
        super((PsiModifierListOwner)psiClass, manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        PsiClass applet;
        RefJavaManager refManager;
        RefClassImpl refClassImpl = this;
        synchronized (refClassImpl) {
            this.myDefaultConstructor = null;
        }
        PsiClass psiClass = this.getElement();
        LOG.assertTrue(psiClass != null);
        PsiElement psiParent = psiClass.getParent();
        if (psiParent instanceof PsiFile) {
            if (this.isSyntheticJSP()) {
                RefFileImpl refFile = (RefFileImpl)this.getRefManager().getReference((PsiElement)RefClassImpl.getJspFile(psiClass));
                LOG.assertTrue(refFile != null);
                refFile.add((RefEntity)this);
            } else if (psiParent instanceof PsiJavaFile) {
                PsiJavaFile psiFile = (PsiJavaFile)psiParent;
                String packageName = psiFile.getPackageName();
                if (!packageName.isEmpty()) {
                    ((RefPackageImpl)this.getRefJavaManager().getPackage(packageName)).add((RefEntity)this);
                } else {
                    ((RefPackageImpl)this.getRefJavaManager().getDefaultPackage()).add((RefEntity)this);
                }
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            LOG.assertTrue(module != null);
            RefModuleImpl refModule = (RefModuleImpl)this.getRefManager().getRefModule(module);
            LOG.assertTrue(refModule != null);
            refModule.add((RefEntity)this);
        } else {
            while (!(psiParent instanceof PsiClass || psiParent instanceof PsiMethod || psiParent instanceof PsiField)) {
                psiParent = psiParent.getParent();
            }
            RefElement refParent = this.getRefManager().getReference(psiParent);
            LOG.assertTrue(refParent != null);
            ((RefElementImpl)refParent).add((RefEntity)this);
        }
        this.setAbstract(psiClass.hasModifierProperty("abstract"));
        this.setAnonymous(psiClass instanceof PsiAnonymousClass);
        this.setIsLocal(!this.isAnonymous() && !(psiParent instanceof PsiClass) && !(psiParent instanceof PsiFile));
        this.setInterface(psiClass.isInterface());
        this.initializeSuperReferences(psiClass);
        PsiMethod[] psiMethods = psiClass.getMethods();
        PsiField[] psiFields = psiClass.getFields();
        this.setUtilityClass(psiMethods.length > 0 || psiFields.length > 0);
        for (PsiField psiField : psiFields) {
            this.getRefManager().getReference((PsiElement)psiField);
        }
        if (!this.isApplet()) {
            PsiClass servlet = this.getRefJavaManager().getServlet();
            this.setServlet(servlet != null && psiClass.isInheritor(servlet, true));
        }
        if (!this.isApplet() && !this.isServlet()) {
            boolean isTestClass = TestFrameworks.getInstance().isTestClass(psiClass);
            this.setTestCase(isTestClass);
            if (isTestClass) {
                for (RefClass refBase : this.getBaseClasses()) {
                    ((RefClassImpl)refBase).setTestCase(true);
                }
            }
        }
        if (RefClassImpl.inheritsFrom(psiClass, (refManager = this.getRefJavaManager()).getAndroidActivity()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidService()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidView()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidFragment(false)) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidFragment(true)) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidReceiver()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidContentProvider()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidParcelable()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidBackupAgent()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidActionProvider())) {
            this.setAndroidPublic(true);
        }
        RefMethod varargConstructor = null;
        for (PsiMethod psiMethod : psiMethods) {
            RefMethod refMethod = (RefMethod)this.getRefManager().getReference((PsiElement)psiMethod);
            if (refMethod == null) continue;
            if (psiMethod.isConstructor()) {
                PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
                if (parameters2.length > 0 || !psiMethod.hasModifierProperty("private")) {
                    this.setUtilityClass(false);
                }
                this.addConstructor(refMethod);
                if (parameters2.length == 0) {
                    this.setDefaultConstructor((RefMethodImpl)refMethod);
                    continue;
                }
                if (parameters2.length != 1 || !parameters2[0].isVarArgs()) continue;
                varargConstructor = refMethod;
                continue;
            }
            if (psiMethod.hasModifierProperty("static")) continue;
            this.setUtilityClass(false);
        }
        if (varargConstructor != null && this.getDefaultConstructor() == null) {
            this.setDefaultConstructor((RefMethodImpl)varargConstructor);
        }
        if (this.getConstructors().isEmpty() && !this.isInterface() && !this.isAnonymous()) {
            RefImplicitConstructorImpl refImplicitConstructor = new RefImplicitConstructorImpl(this);
            this.setDefaultConstructor(refImplicitConstructor);
            this.addConstructor(refImplicitConstructor);
        }
        if (this.isInterface()) {
            for (int i = 0; i < psiFields.length && this.isUtilityClass(); ++i) {
                PsiField psiField = psiFields[i];
                if (psiField.hasModifierProperty("static")) continue;
                this.setUtilityClass(false);
            }
        }
        this.setApplet((applet = this.getRefJavaManager().getApplet()) != null && psiClass.isInheritor(applet, true));
        PsiManager psiManager = this.getRefManager().getPsiManager();
        psiManager.dropResolveCaches();
        PsiFile file = psiClass.getContainingFile();
        if (file != null) {
            InjectedLanguageManager.getInstance((Project)file.getProject()).dropFileCaches(file);
        }
    }

    private static boolean inheritsFrom(@NotNull PsiClass c1, @Nullable PsiClass c2) {
        if (c1 == null) {
            RefClassImpl.$$$reportNull$$$0(0);
        }
        return c2 != null && c1.isInheritor(c2, true);
    }

    private static ServerPageFile getJspFile(PsiClass psiClass) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)psiClass);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    private void initializeSuperReferences(PsiClass psiClass) {
        if (!this.isSelfInheritor(psiClass)) {
            for (PsiClass psiSuperClass : psiClass.getSupers()) {
                RefClassImpl refClass;
                if (!this.getRefManager().belongsToScope((PsiElement)psiSuperClass) || (refClass = (RefClassImpl)this.getRefManager().getReference((PsiElement)psiSuperClass)) == null) continue;
                this.addBaseClass(refClass);
                refClass.addSubClass(this);
            }
        }
    }

    public boolean isSelfInheritor(PsiClass psiClass) {
        return RefClassImpl.isSelfInheritor(psiClass, new ArrayList<PsiClass>());
    }

    @Nullable
    public PsiClass getElement() {
        return (PsiClass)super.getElement();
    }

    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    private static boolean isSelfInheritor(PsiClass psiClass, ArrayList<PsiClass> visited) {
        if (visited.contains(psiClass)) {
            return true;
        }
        visited.add(psiClass);
        for (PsiClass aSuper : psiClass.getSupers()) {
            if (!RefClassImpl.isSelfInheritor(aSuper, visited)) continue;
            return true;
        }
        visited.remove(psiClass);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultConstructor(RefMethodImpl defaultConstructor) {
        if (defaultConstructor != null) {
            for (RefClass superClass : this.getBaseClasses()) {
                RefMethodImpl superDefaultConstructor = (RefMethodImpl)superClass.getDefaultConstructor();
                if (superDefaultConstructor == null) continue;
                superDefaultConstructor.addInReference((RefElement)defaultConstructor);
                defaultConstructor.addOutReference((RefElement)superDefaultConstructor);
            }
        }
        RefClassImpl refClassImpl = this;
        synchronized (refClassImpl) {
            this.myDefaultConstructor = defaultConstructor;
        }
    }

    @NotNull
    public String getQualifiedName() {
        PsiClass psiClass = this.getElement();
        if (psiClass == null) {
            String string = super.getQualifiedName();
            if (string == null) {
                RefClassImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        String qName = psiClass.getQualifiedName();
        if (qName == null) {
            String string = super.getQualifiedName();
            if (string == null) {
                RefClassImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = qName;
        if (string == null) {
            RefClassImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void buildReferences() {
        PsiClass psiClass = this.getElement();
        if (psiClass != null) {
            PsiMethod[] psiMethods;
            PsiField[] psiFields;
            for (PsiClassInitializer classInitializer : psiClass.getInitializers()) {
                RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)classInitializer.getBody());
            }
            RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)psiClass.getModifierList());
            for (PsiField psiField : psiFields = psiClass.getFields()) {
                this.getRefManager().getReference((PsiElement)psiField);
                PsiExpression initializer = psiField.getInitializer();
                if (initializer == null) continue;
                RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)initializer);
            }
            for (PsiMethod psiMethod : psiMethods = psiClass.getMethods()) {
                this.getRefManager().getReference((PsiElement)psiMethod);
            }
            RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)psiClass.getExtendsList());
            RefJavaUtil.getInstance().addReferences((PsiModifierListOwner)psiClass, (RefJavaElement)this, (PsiElement)psiClass.getImplementsList());
            this.getRefManager().fireBuildReferences((RefElement)this);
        }
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefClassImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    RefClassImpl.$$$reportNull$$$0(20);
                }
                ((RefJavaVisitor)visitor).visitClass((RefClass)this);
            });
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public synchronized Set<RefClass> getBaseClasses() {
        if (this.myBases == null) {
            Set<RefClass> set = EMPTY_CLASS_SET;
            if (set == null) {
                RefClassImpl.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<RefClass> set = this.myBases;
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    private synchronized void addBaseClass(RefClass refClass) {
        if (this.myBases == null) {
            this.myBases = Collections.singleton(refClass);
            return;
        }
        if (this.myBases.size() == 1) {
            this.myBases = new THashSet(this.myBases);
        }
        this.myBases.add(refClass);
    }

    @NotNull
    public synchronized Set<RefClass> getSubClasses() {
        if (this.mySubClasses == null) {
            Set<RefClass> set = EMPTY_CLASS_SET;
            if (set == null) {
                RefClassImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<RefClass> set = this.mySubClasses;
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    private synchronized void addSubClass(@NotNull RefClass refClass) {
        if (refClass == null) {
            RefClassImpl.$$$reportNull$$$0(9);
        }
        if (this.mySubClasses == null) {
            this.mySubClasses = Collections.singleton(refClass);
            return;
        }
        if (this.mySubClasses.size() == 1) {
            this.mySubClasses = new THashSet(this.mySubClasses);
        }
        this.mySubClasses.add(refClass);
    }

    private synchronized void removeSubClass(RefClass refClass) {
        if (this.mySubClasses == null) {
            return;
        }
        if (this.mySubClasses.size() == 1) {
            this.mySubClasses = null;
        } else {
            this.mySubClasses.remove(refClass);
        }
    }

    @NotNull
    public synchronized List<RefMethod> getConstructors() {
        if (this.myConstructors == null) {
            List<RefMethod> list = EMPTY_METHOD_LIST;
            if (list == null) {
                RefClassImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<RefMethod> list = this.myConstructors;
        if (list == null) {
            RefClassImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public synchronized Set<RefElement> getInTypeReferences() {
        if (this.myInTypeReferences == null) {
            Set<RefElement> set = EMPTY_SET;
            if (set == null) {
                RefClassImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set<RefElement> set = this.myInTypeReferences;
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTypeReference(RefJavaElement from) {
        if (from != null) {
            RefClassImpl refClassImpl = this;
            synchronized (refClassImpl) {
                if (this.myInTypeReferences == null) {
                    this.myInTypeReferences = new THashSet(1);
                }
                this.myInTypeReferences.add((RefElement)from);
            }
            ((RefJavaElementImpl)from).addOutTypeReference(this);
            this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)from, false, false, false);
        }
    }

    @NotNull
    public synchronized Set<RefElement> getInstanceReferences() {
        if (this.myInstanceReferences == null) {
            Set<RefElement> set = EMPTY_SET;
            if (set == null) {
                RefClassImpl.$$$reportNull$$$0(14);
            }
            return set;
        }
        Set<RefElement> set = this.myInstanceReferences;
        if (set == null) {
            RefClassImpl.$$$reportNull$$$0(15);
        }
        return set;
    }

    synchronized void addInstanceReference(RefElement from) {
        if (this.myInstanceReferences == null) {
            this.myInstanceReferences = new THashSet(1);
        }
        this.myInstanceReferences.add(from);
    }

    public synchronized RefMethod getDefaultConstructor() {
        return this.myDefaultConstructor;
    }

    private synchronized void addConstructor(RefMethod refConstructor) {
        if (this.myConstructors == null) {
            this.myConstructors = new ArrayList<RefMethod>(1);
        }
        this.myConstructors.add(refConstructor);
    }

    synchronized void addLibraryOverrideMethod(RefMethod refMethod) {
        if (this.myOverridingMethods == null) {
            this.myOverridingMethods = new ArrayList<RefMethod>(2);
        }
        this.myOverridingMethods.add(refMethod);
    }

    @NotNull
    public synchronized List<RefMethod> getLibraryMethods() {
        if (this.myOverridingMethods == null) {
            List<RefMethod> list = EMPTY_METHOD_LIST;
            if (list == null) {
                RefClassImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<RefMethod> list = this.myOverridingMethods;
        if (list == null) {
            RefClassImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    public boolean isAnonymous() {
        return this.checkFlag(65536L);
    }

    public boolean isInterface() {
        return this.checkFlag(131072L);
    }

    public boolean isSuspicious() {
        return (!this.isUtilityClass() || !this.getOutReferences().isEmpty()) && super.isSuspicious();
    }

    public boolean isUtilityClass() {
        return this.checkFlag(262144L);
    }

    public String getExternalName() {
        String[] result = new String[1];
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass = this.getElement();
            LOG.assertTrue(psiClass != null);
            result[0] = PsiFormatUtil.getExternalName((PsiModifierListOwner)psiClass);
        });
        return result[0];
    }

    @Nullable
    static RefClass classFromExternalName(RefManager manager, String externalName) {
        return (RefClass)manager.getReference((PsiElement)ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)manager.getProject()), (String)externalName));
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        for (RefClass subClass : this.getSubClasses()) {
            ((RefClassImpl)subClass).removeBase(this);
        }
        for (RefClass superClass : this.getBaseClasses()) {
            ((RefClassImpl)superClass).removeSubClass(this);
        }
    }

    private synchronized void removeBase(RefClass superClass) {
        Set<RefClass> baseClasses = this.getBaseClasses();
        if (baseClasses.contains(superClass)) {
            if (baseClasses.size() == 1) {
                this.myBases = null;
                return;
            }
            baseClasses.remove(superClass);
        }
    }

    void methodRemoved(RefMethod method) {
        this.getConstructors().remove(method);
        this.getLibraryMethods().remove(method);
        if (this.getDefaultConstructor() == method) {
            this.setDefaultConstructor(null);
        }
    }

    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    public boolean isApplet() {
        return this.checkFlag(0x200000L);
    }

    public boolean isServlet() {
        return this.checkFlag(0x400000L);
    }

    public boolean isAndroidPublic() {
        return this.checkFlag(0x2000000L);
    }

    public boolean isTestCase() {
        return this.checkFlag(0x800000L);
    }

    public boolean isLocalClass() {
        return this.checkFlag(0x1000000L);
    }

    public boolean isReferenced() {
        if (super.isReferenced()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && !this.getSubClasses().isEmpty();
    }

    public boolean hasSuspiciousCallers() {
        if (super.hasSuspiciousCallers()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && !this.getSubClasses().isEmpty();
    }

    synchronized void addClassExporter(RefJavaElement exporter) {
        if (this.myClassExporters == null) {
            this.myClassExporters = new ArrayList<RefJavaElement>(1);
        }
        if (this.myClassExporters.contains(exporter)) {
            return;
        }
        this.myClassExporters.add(exporter);
    }

    public synchronized List<RefJavaElement> getClassExporters() {
        return this.myClassExporters;
    }

    private void setAnonymous(boolean anonymous) {
        this.setFlag(anonymous, 65536L);
    }

    private void setInterface(boolean anInterface) {
        this.setFlag(anInterface, 131072L);
    }

    private void setUtilityClass(boolean utilityClass) {
        this.setFlag(utilityClass, 262144L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    private void setApplet(boolean applet) {
        this.setFlag(applet, 0x200000L);
    }

    private void setServlet(boolean servlet) {
        this.setFlag(servlet, 0x400000L);
    }

    private void setAndroidPublic(boolean android) {
        this.setFlag(android, 0x2000000L);
    }

    private void setTestCase(boolean testCase) {
        this.setFlag(testCase, 0x800000L);
    }

    private void setIsLocal(boolean isLocal) {
        this.setFlag(isLocal, 0x1000000L);
    }

    @NotNull
    public RefElement getContainingEntry() {
        RefMethod defaultConstructor = this.getDefaultConstructor();
        if (defaultConstructor != null) {
            RefMethod refMethod = defaultConstructor;
            if (refMethod == null) {
                RefClassImpl.$$$reportNull$$$0(18);
            }
            return refMethod;
        }
        RefElement refElement = super.getContainingEntry();
        if (refElement == null) {
            RefClassImpl.$$$reportNull$$$0(19);
        }
        return refElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefClassImpl";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefClassImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClasses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInTypeReferences";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceReferences";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMethods";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inheritsFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSubClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$accept$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

