/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;

public class JavaSdkImpl
extends JavaSdk {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.JavaSdkImpl");
    public static final DataKey<Boolean> KEY = DataKey.create((String)"JavaSdk");
    private static final String VM_EXE_NAME = SystemInfo.isWindows ? "java.exe" : "java";
    private final Map<String, String> myCachedSdkHomeToVersionString = new ConcurrentHashMap<String, String>();
    private final Map<String, JavaVersion> myCachedVersionStringToJdkVersion = new ConcurrentHashMap<String, JavaVersion>();

    public JavaSdkImpl(VirtualFileManager fileManager, final FileTypeManager fileTypeManager) {
        super("JavaSDK");
        fileManager.addVirtualFileListener(new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.updateCache(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.updateCache(event);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.updateCache(event);
            }

            private void updateCache(VirtualFileEvent event) {
                if (FileTypes.ARCHIVE.equals(fileTypeManager.getFileTypeByFileName(event.getFileName()))) {
                    String filePath = event.getFile().getPath();
                    if (JavaSdkImpl.this.myCachedSdkHomeToVersionString.keySet().removeIf(sdkHome -> FileUtil.isAncestor((String)sdkHome, (String)filePath, (boolean)false))) {
                        JavaSdkImpl.this.myCachedVersionStringToJdkVersion.clear();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"sdk.java.name", (Object[])new Object[0]);
        if (string == null) {
            JavaSdkImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.PpJdk;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.java" == null) {
            JavaSdkImpl.$$$reportNull$$$0(1);
        }
        return "reference.project.structure.sdk.java";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = AllIcons.General.AddJdk;
        if (icon == null) {
            JavaSdkImpl.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        JavaSdkVersion version;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(3);
        }
        if ((version = this.getVersion(sdk)) != null) {
            if (version == JavaSdkVersion.JDK_1_5) {
                return "https://docs.oracle.com/javase/1.5.0/docs/api/";
            }
            if (version == JavaSdkVersion.JDK_10) {
                return "https://download.java.net/java/jdk10/docs/api/";
            }
            if (version.isAtLeast(JavaSdkVersion.JDK_1_6)) {
                return "https://docs.oracle.com/javase/" + version.ordinal() + "/docs/api/";
            }
        }
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return "http://www.oracle.com/technetwork/java/javase/downloads/index.html";
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            JavaSdkImpl.$$$reportNull$$$0(4);
        }
        if (sdkModificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(5);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            JavaSdkImpl.$$$reportNull$$$0(6);
        }
        if (additional == null) {
            JavaSdkImpl.$$$reportNull$$$0(7);
        }
    }

    public Comparator<Sdk> versionComparator() {
        return (sdk1, sdk2) -> {
            assert (sdk1.getSdkType() == this) : sdk1;
            assert (sdk2.getSdkType() == this) : sdk2;
            return Comparing.compare((Comparable)this.getJavaVersion((Sdk)sdk1), (Comparable)this.getJavaVersion((Sdk)sdk2));
        };
    }

    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(8);
        }
        return JavaSdkImpl.getConvertedHomePath(sdk) + "bin";
    }

    public String getToolsPath(@NotNull Sdk sdk) {
        String versionString;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(9);
        }
        boolean isJdk1_x = (versionString = sdk.getVersionString()) != null && (versionString.contains("1.0") || versionString.contains("1.1"));
        return JavaSdkImpl.getConvertedHomePath(sdk) + "lib" + File.separator + (isJdk1_x ? "classes.zip" : "tools.jar");
    }

    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(10);
        }
        return this.getBinPath(sdk) + File.separator + VM_EXE_NAME;
    }

    private static String getConvertedHomePath(Sdk sdk) {
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        String path = FileUtil.toSystemDependentName((String)homePath);
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public String suggestHomePath() {
        Collection<String> paths = this.suggestHomePaths();
        return paths.isEmpty() ? null : paths.iterator().next();
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        List<String> list = JavaHomeFinder.suggestHomePaths();
        if (list == null) {
            JavaSdkImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = super.getHomeChooserDescriptor();
        descriptor.putUserData(KEY, (Object)Boolean.TRUE);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            JavaSdkImpl.$$$reportNull$$$0(12);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (homePath == null) {
            JavaSdkImpl.$$$reportNull$$$0(13);
        }
        if (SystemInfo.isMac) {
            File home = new File(homePath, "/Home");
            if (home.exists()) {
                String string = home.getPath();
                if (string == null) {
                    JavaSdkImpl.$$$reportNull$$$0(14);
                }
                return string;
            }
            home = new File(homePath, "Contents/Home");
            if (home.exists()) {
                String string = home.getPath();
                if (string == null) {
                    JavaSdkImpl.$$$reportNull$$$0(15);
                }
                return string;
            }
        }
        String string = homePath;
        if (string == null) {
            JavaSdkImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean isValidSdkHome(String path) {
        return JdkUtil.checkForJdk((String)path);
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        JavaVersion version = JavaVersion.tryParse((String)this.getVersionString(sdkHome));
        if (version == null) {
            return currentSdkName;
        }
        StringBuilder suggested = new StringBuilder();
        if (version.feature < 9) {
            suggested.append("1.");
        }
        suggested.append(version.feature);
        if (version.ea) {
            suggested.append("-ea");
        }
        return suggested.toString();
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(17);
        }
        if (sdkModel == null) {
            JavaSdkImpl.$$$reportNull$$$0(18);
        }
        this.setupSdkPaths(sdk);
        if (sdk.getSdkModificator().getRoots(OrderRootType.CLASSES).length == 0) {
            String title = ProjectBundle.message((String)"sdk.cannot.create", (Object[])new Object[0]);
            String message2 = ProjectBundle.message((String)"sdk.java.no.classes", (Object[])new Object[]{sdk.getHomePath()});
            Messages.showMessageDialog((String)message2, (String)title, (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(19);
        }
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        File jdkHome = new File(homePath);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        List<VirtualFile> classes2 = JavaSdkImpl.findClasses(jdkHome, false);
        LinkedHashSet<VirtualFile> previousRoots = new LinkedHashSet<VirtualFile>(Arrays.asList(sdkModificator.getRoots(OrderRootType.CLASSES)));
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        previousRoots.removeAll(new HashSet<VirtualFile>(classes2));
        for (VirtualFile aClass : classes2) {
            sdkModificator.addRoot(aClass, OrderRootType.CLASSES);
        }
        for (VirtualFile root : previousRoots) {
            sdkModificator.addRoot(root, OrderRootType.CLASSES);
        }
        JavaSdkImpl.addSources(jdkHome, sdkModificator);
        this.addDocs(jdkHome, sdkModificator, sdk);
        JavaSdkImpl.attachJdkAnnotations(sdkModificator);
        sdkModificator.commitChanges();
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        if (modificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(20);
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<String> pathsChecked = new ArrayList<String>();
        String path = FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/java/jdkAnnotations";
        VirtualFile root = lfs.findFileByPath(path);
        pathsChecked.add(path);
        if (root == null) {
            path = FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/community/java/jdkAnnotations";
            root = lfs.findFileByPath(path);
            pathsChecked.add(path);
        }
        if (root == null) {
            String url = "jar://" + FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar!/";
            root = VirtualFileManager.getInstance().findFileByUrl(url);
            pathsChecked.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar");
        }
        if (root == null) {
            StringBuilder msg = new StringBuilder("Paths checked:\n");
            for (String p : pathsChecked) {
                File f = new File(p);
                msg.append(p).append("; ").append(f.exists()).append("; ").append(Arrays.toString(f.getParentFile().list())).append('\n');
            }
            LOG.error("JDK annotations not found", new String[]{msg.toString()});
            return;
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        modificator.removeRoot(root, annoType);
        modificator.addRoot(root, annoType);
    }

    public final String getVersionString(String sdkHome) {
        return this.myCachedSdkHomeToVersionString.computeIfAbsent(sdkHome, k -> {
            JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo((String)k);
            return jdkInfo != null ? JdkVersionDetector.formatVersionString((JavaVersion)jdkInfo.version) : null;
        });
    }

    public JavaSdkVersion getVersion(@NotNull Sdk sdk) {
        JavaVersion version;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(21);
        }
        return (version = this.getJavaVersion(sdk)) != null ? JavaSdkVersion.fromJavaVersion((JavaVersion)version) : null;
    }

    private JavaVersion getJavaVersion(Sdk sdk) {
        String versionString = sdk.getVersionString();
        return versionString != null ? this.myCachedVersionStringToJdkVersion.computeIfAbsent(versionString, JavaVersion::tryParse) : null;
    }

    @Nullable
    public JavaSdkVersion getVersion(@NotNull String versionString) {
        if (versionString == null) {
            JavaSdkImpl.$$$reportNull$$$0(22);
        }
        return JavaSdkVersion.fromVersionString((String)versionString);
    }

    public boolean isOfVersionOrHigher(@NotNull Sdk sdk, @NotNull JavaSdkVersion version) {
        JavaSdkVersion sdkVersion;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(23);
        }
        if (version == null) {
            JavaSdkImpl.$$$reportNull$$$0(24);
        }
        return (sdkVersion = this.getVersion(sdk)) != null && sdkVersion.isAtLeast(version);
    }

    @NotNull
    public Sdk createJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        if (jdkName == null) {
            JavaSdkImpl.$$$reportNull$$$0(25);
        }
        if (home == null) {
            JavaSdkImpl.$$$reportNull$$$0(26);
        }
        ProjectJdkImpl jdk = new ProjectJdkImpl(jdkName, (SdkTypeId)this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        String path = home.replace(File.separatorChar, '/');
        sdkModificator.setHomePath(path);
        sdkModificator.setVersionString(jdkName);
        File jdkHomeFile = new File(home);
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        this.addDocs(jdkHomeFile, sdkModificator, null);
        sdkModificator.commitChanges();
        ProjectJdkImpl projectJdkImpl = jdk;
        if (projectJdkImpl == null) {
            JavaSdkImpl.$$$reportNull$$$0(27);
        }
        return projectJdkImpl;
    }

    @NotNull
    public Sdk createMockJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        if (jdkName == null) {
            JavaSdkImpl.$$$reportNull$$$0(28);
        }
        if (home == null) {
            JavaSdkImpl.$$$reportNull$$$0(29);
        }
        String homePath = PathUtil.toSystemIndependentName((String)home);
        File jdkHomeFile = new File(homePath);
        final MultiMap roots = MultiMap.create();
        SdkModificator sdkModificator = new SdkModificator(){

            public String getName() {
                throw new UnsupportedOperationException();
            }

            public void setName(String name) {
                throw new UnsupportedOperationException();
            }

            public String getHomePath() {
                throw new UnsupportedOperationException();
            }

            public void setHomePath(String path) {
                throw new UnsupportedOperationException();
            }

            public String getVersionString() {
                throw new UnsupportedOperationException();
            }

            public void setVersionString(String versionString) {
                throw new UnsupportedOperationException();
            }

            public SdkAdditionalData getSdkAdditionalData() {
                throw new UnsupportedOperationException();
            }

            public void setSdkAdditionalData(SdkAdditionalData data) {
                throw new UnsupportedOperationException();
            }

            @NotNull
            public VirtualFile[] getRoots(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    2.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException();
            }

            public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                if (root == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (rootType == null) {
                    2.$$$reportNull$$$0(2);
                }
                throw new UnsupportedOperationException();
            }

            public void removeRoots(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    2.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            public void removeAllRoots() {
                throw new UnsupportedOperationException();
            }

            public void commitChanges() {
                throw new UnsupportedOperationException();
            }

            public boolean isWritable() {
                throw new UnsupportedOperationException();
            }

            public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                if (root == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (rootType == null) {
                    2.$$$reportNull$$$0(5);
                }
                roots.putValue((Object)rootType, (Object)root);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootType";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getRoots";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeRoot";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeRoots";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addRoot";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        MockSdk mockSdk = new MockSdk(jdkName, homePath, jdkName, roots, (SdkTypeId)this);
        if (mockSdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(30);
        }
        return mockSdk;
    }

    private static void addClasses(@NotNull File file, @NotNull SdkModificator sdkModificator, boolean isJre) {
        if (file == null) {
            JavaSdkImpl.$$$reportNull$$$0(31);
        }
        if (sdkModificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(32);
        }
        for (VirtualFile virtualFile : JavaSdkImpl.findClasses(file, isJre)) {
            sdkModificator.addRoot(virtualFile, OrderRootType.CLASSES);
        }
    }

    @NotNull
    private static List<VirtualFile> findClasses(@NotNull File file, boolean isJre) {
        if (file == null) {
            JavaSdkImpl.$$$reportNull$$$0(33);
        }
        ArrayList result = ContainerUtil.newArrayList();
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        if (JdkUtil.isExplodedModularRuntime((String)file.getPath())) {
            VirtualFile exploded = fileManager.findFileByUrl("file://" + JavaSdkImpl.getPath(new File(file, "modules")));
            if (exploded != null) {
                ContainerUtil.addAll((Collection)result, (Object[])exploded.getChildren());
            }
        } else if (JdkUtil.isModularRuntime((File)file)) {
            VirtualFile jrt = fileManager.findFileByUrl("jrt://" + JavaSdkImpl.getPath(file) + "!/");
            if (jrt != null) {
                ContainerUtil.addAll((Collection)result, (Object[])jrt.getChildren());
            }
        } else {
            for (File root : JavaSdkUtil.getJdkClassesRoots((File)file, (boolean)isJre)) {
                String url = VfsUtil.getUrlForLibraryRoot((File)root);
                ContainerUtil.addIfNotNull((Collection)result, (Object)fileManager.findFileByUrl(url));
            }
        }
        Collections.sort(result, Comparator.comparing(VirtualFile::getPath));
        ArrayList arrayList = result;
        if (arrayList == null) {
            JavaSdkImpl.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    private static void addSources(@NotNull File jdkHome, @NotNull SdkModificator sdkModificator) {
        VirtualFile fxSrc;
        VirtualFile jdkSrc;
        if (jdkHome == null) {
            JavaSdkImpl.$$$reportNull$$$0(35);
        }
        if (sdkModificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(36);
        }
        if ((jdkSrc = JavaSdkImpl.findSources(jdkHome, "src")) != null) {
            if (jdkSrc.findChild("java.base") != null) {
                Stream.of(jdkSrc.getChildren()).filter(VirtualFile::isDirectory).forEach(root -> {
                    if (sdkModificator == null) {
                        JavaSdkImpl.$$$reportNull$$$0(40);
                    }
                    sdkModificator.addRoot(root, OrderRootType.SOURCES);
                });
            } else {
                sdkModificator.addRoot(jdkSrc, OrderRootType.SOURCES);
            }
        }
        if ((fxSrc = JavaSdkImpl.findSources(jdkHome, "javafx-src")) != null) {
            sdkModificator.addRoot(fxSrc, OrderRootType.SOURCES);
        }
    }

    @Nullable
    private static VirtualFile findSources(File jdkHome, String srcName) {
        File srcArc = new File(jdkHome, srcName + ".jar");
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, srcName + ".zip");
        }
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, "lib/" + srcName + ".zip");
        }
        if (srcArc.exists()) {
            VirtualFile srcRoot = JavaSdkImpl.findInJar(srcArc, "src");
            if (srcRoot == null) {
                srcRoot = JavaSdkImpl.findInJar(srcArc, "");
            }
            return srcRoot;
        }
        File srcDir = new File(jdkHome, "src");
        if (srcDir.isDirectory()) {
            return LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(srcDir));
        }
        return null;
    }

    private void addDocs(File jdkHome, SdkModificator sdkModificator, @Nullable Sdk sdk) {
        OrderRootType docRootType = JavadocOrderRootType.getInstance();
        VirtualFile apiDocs = JavaSdkImpl.findDocs(jdkHome, "docs/api");
        if (apiDocs != null) {
            sdkModificator.addRoot(apiDocs, docRootType);
        } else if (SystemInfo.isMac) {
            VirtualFile appleDocs;
            VirtualFile commonDocs = JavaSdkImpl.findDocs(jdkHome, "docs");
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "doc/api");
            }
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "docs/api");
            }
            if (commonDocs != null) {
                sdkModificator.addRoot(commonDocs, docRootType);
            }
            if ((appleDocs = JavaSdkImpl.findDocs(jdkHome, "appledocs")) == null) {
                appleDocs = JavaSdkImpl.findInJar(new File(jdkHome, "appledocs.jar"), "appledoc/api");
            }
            if (appleDocs != null) {
                sdkModificator.addRoot(appleDocs, docRootType);
            }
        }
        if (sdk != null && sdkModificator.getRoots(docRootType).length == 0 && sdkModificator.getRoots(OrderRootType.SOURCES).length == 0) {
            VirtualFile fxDocUrl;
            VirtualFile onlineDoc;
            String docUrl = this.getDefaultDocumentationUrl(sdk);
            if (docUrl != null && (onlineDoc = VirtualFileManager.getInstance().findFileByUrl(docUrl)) != null) {
                sdkModificator.addRoot(onlineDoc, docRootType);
            }
            if (this.getVersion(sdk) == JavaSdkVersion.JDK_1_7 && (fxDocUrl = VirtualFileManager.getInstance().findFileByUrl("http://docs.oracle.com/javafx/2/api/")) != null) {
                sdkModificator.addRoot(fxDocUrl, docRootType);
            }
        }
    }

    @Nullable
    private static VirtualFile findDocs(@NotNull File jdkHome, @NotNull String relativePath) {
        File docDir;
        if (jdkHome == null) {
            JavaSdkImpl.$$$reportNull$$$0(37);
        }
        if (relativePath == null) {
            JavaSdkImpl.$$$reportNull$$$0(38);
        }
        return (docDir = new File(jdkHome.getAbsolutePath(), relativePath)).isDirectory() ? LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(docDir)) : null;
    }

    private static VirtualFile findInJar(File jarFile, String relativePath) {
        if (!jarFile.exists()) {
            return null;
        }
        String url = "jar://" + JavaSdkImpl.getPath(jarFile) + "!/" + relativePath;
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    private static String getPath(File jarFile) {
        return FileUtil.toSystemIndependentName((String)jarFile.getAbsolutePath());
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type2) {
        if (type2 == null) {
            JavaSdkImpl.$$$reportNull$$$0(39);
        }
        return type2 == OrderRootType.CLASSES || type2 == OrderRootType.SOURCES || type2 == JavadocOrderRootType.getInstance() || type2 == AnnotationOrderRootType.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaSdkImpl";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 5: 
            case 32: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaSdkImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createJdk";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockJdk";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "attachJdkAnnotations";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isOfVersionOrHigher";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createMockJdk";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addSources";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findDocs";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSources$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

