/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaCodeStyleSettings
extends CustomCodeStyleSettings
implements ImportsLayoutSettings {
    @NonNls
    private static final String REPEAT_ANNOTATIONS = "REPEAT_ANNOTATIONS";
    public String FIELD_NAME_PREFIX = "";
    public String STATIC_FIELD_NAME_PREFIX = "";
    public String PARAMETER_NAME_PREFIX = "";
    public String LOCAL_VARIABLE_NAME_PREFIX = "";
    public String TEST_NAME_PREFIX = "";
    public String SUBCLASS_NAME_PREFIX = "";
    public String FIELD_NAME_SUFFIX = "";
    public String STATIC_FIELD_NAME_SUFFIX = "";
    public String PARAMETER_NAME_SUFFIX = "";
    public String LOCAL_VARIABLE_NAME_SUFFIX = "";
    public String TEST_NAME_SUFFIX = "Test";
    public String SUBCLASS_NAME_SUFFIX = "Impl";
    public boolean PREFER_LONGER_NAMES = true;
    public boolean GENERATE_FINAL_LOCALS;
    public boolean GENERATE_FINAL_PARAMETERS;
    public String VISIBILITY = "public";
    public CodeStyleSettings.TypeToNameMap FIELD_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
    public CodeStyleSettings.TypeToNameMap STATIC_FIELD_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
    public CodeStyleSettings.TypeToNameMap PARAMETER_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
    public CodeStyleSettings.TypeToNameMap LOCAL_VARIABLE_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
    public boolean USE_EXTERNAL_ANNOTATIONS;
    public boolean INSERT_OVERRIDE_ANNOTATION = true;
    public boolean REPEAT_SYNCHRONIZED = true;
    private List<String> myRepeatAnnotations = new ArrayList<String>();
    public boolean REPLACE_INSTANCEOF = false;
    public boolean REPLACE_CAST = false;
    public boolean REPLACE_NULL_CHECK = true;
    public boolean SPACES_WITHIN_ANGLE_BRACKETS;
    public boolean SPACE_AFTER_CLOSING_ANGLE_BRACKET_IN_TYPE_ARGUMENT;
    public boolean SPACE_BEFORE_OPENING_ANGLE_BRACKET_IN_TYPE_PARAMETER;
    public boolean SPACE_AROUND_TYPE_BOUNDS_IN_TYPE_PARAMETERS = true;
    public boolean DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION;
    public int ANNOTATION_PARAMETER_WRAP = 0;
    public boolean ALIGN_MULTILINE_ANNOTATION_PARAMETERS;
    public int BLANK_LINES_AROUND_INITIALIZER = 1;
    public static final int FULLY_QUALIFY_NAMES_IF_NOT_IMPORTED = 1;
    public static final int FULLY_QUALIFY_NAMES_ALWAYS = 2;
    public static final int SHORTEN_NAMES_ALWAYS_AND_ADD_IMPORT = 3;
    public int CLASS_NAMES_IN_JAVADOC = 1;
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
    public boolean USE_FQ_CLASS_NAMES;
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    public boolean INSERT_INNER_CLASS_IMPORTS;
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    public PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
    public PackageEntryTable IMPORT_LAYOUT_TABLE = new PackageEntryTable();
    public boolean ENABLE_JAVADOC_FORMATTING = true;
    public boolean JD_ALIGN_PARAM_COMMENTS = true;
    public boolean JD_ALIGN_EXCEPTION_COMMENTS = true;
    public boolean JD_ADD_BLANK_AFTER_PARM_COMMENTS;
    public boolean JD_ADD_BLANK_AFTER_RETURN;
    public boolean JD_ADD_BLANK_AFTER_DESCRIPTION = true;
    public boolean JD_P_AT_EMPTY_LINES = true;
    public boolean JD_KEEP_INVALID_TAGS = true;
    public boolean JD_KEEP_EMPTY_LINES = true;
    public boolean JD_DO_NOT_WRAP_ONE_LINE_COMMENTS;
    public boolean JD_USE_THROWS_NOT_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_PARAMETER = true;
    public boolean JD_KEEP_EMPTY_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_RETURN = true;
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED = true;
    public boolean JD_PRESERVE_LINE_FEEDS;
    public boolean JD_PARAM_DESCRIPTION_ON_NEW_LINE;
    public boolean JD_INDENT_ON_CONTINUATION = false;

    public JavaCodeStyleSettings(CodeStyleSettings container) {
        super("JavaCodeStyleSettings", container);
        this.initTypeToName();
        this.initImportsByDefault();
    }

    public List<String> getRepeatAnnotations() {
        return this.myRepeatAnnotations;
    }

    public void setRepeatAnnotations(List<String> repeatAnnotations) {
        this.myRepeatAnnotations.clear();
        this.myRepeatAnnotations.addAll(repeatAnnotations);
    }

    public boolean useFqNamesInJavadocAlways() {
        return this.CLASS_NAMES_IN_JAVADOC == 2;
    }

    public boolean isLayoutStaticImportsSeparately() {
        return this.LAYOUT_STATIC_IMPORTS_SEPARATELY;
    }

    public void setLayoutStaticImportsSeparately(boolean value2) {
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = value2;
    }

    public int getNamesCountToUseImportOnDemand() {
        return this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setNamesCountToUseImportOnDemand(int value2) {
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = value2;
    }

    public int getClassCountToUseImportOnDemand() {
        return this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setClassCountToUseImportOnDemand(int value2) {
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = value2;
    }

    public boolean isInsertInnerClassImports() {
        return this.INSERT_INNER_CLASS_IMPORTS;
    }

    public void setInsertInnerClassImports(boolean value2) {
        this.INSERT_INNER_CLASS_IMPORTS = value2;
    }

    public boolean isUseSingleClassImports() {
        return this.USE_SINGLE_CLASS_IMPORTS;
    }

    public void setUseSingleClassImports(boolean value2) {
        this.USE_SINGLE_CLASS_IMPORTS = value2;
    }

    public boolean isUseFqClassNames() {
        return this.USE_FQ_CLASS_NAMES;
    }

    public void setUseFqClassNames(boolean value2) {
        this.USE_FQ_CLASS_NAMES = value2;
    }

    public PackageEntryTable getImportLayoutTable() {
        return this.IMPORT_LAYOUT_TABLE;
    }

    public PackageEntryTable getPackagesToUseImportOnDemand() {
        return this.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
    }

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    public boolean isGenerateFinalLocals() {
        return this.GENERATE_FINAL_LOCALS;
    }

    public boolean isGenerateFinalParameters() {
        return this.GENERATE_FINAL_PARAMETERS;
    }

    private static void initGeneralLocalVariable(@NonNls CodeStyleSettings.TypeToNameMap map) {
        map.addPair("int", "i");
        map.addPair("byte", "b");
        map.addPair("char", "c");
        map.addPair("long", "l");
        map.addPair("short", "i");
        map.addPair("boolean", "b");
        map.addPair("double", "v");
        map.addPair("float", "v");
        map.addPair("java.lang.Object", "o");
        map.addPair("java.lang.String", "s");
    }

    private void initTypeToName() {
        JavaCodeStyleSettings.initGeneralLocalVariable(this.PARAMETER_TYPE_TO_NAME);
        JavaCodeStyleSettings.initGeneralLocalVariable(this.LOCAL_VARIABLE_TYPE_TO_NAME);
        this.PARAMETER_TYPE_TO_NAME.addPair("*Exception", "e");
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(0);
        }
        this.USE_EXTERNAL_ANNOTATIONS = rootSettings.USE_EXTERNAL_ANNOTATIONS;
        this.INSERT_OVERRIDE_ANNOTATION = rootSettings.INSERT_OVERRIDE_ANNOTATION;
        this.REPEAT_SYNCHRONIZED = rootSettings.REPEAT_SYNCHRONIZED;
        this.setRepeatAnnotations(rootSettings.getRepeatAnnotations());
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = rootSettings.LAYOUT_STATIC_IMPORTS_SEPARATELY;
        this.USE_FQ_CLASS_NAMES = rootSettings.USE_FQ_CLASS_NAMES;
        this.USE_SINGLE_CLASS_IMPORTS = rootSettings.USE_SINGLE_CLASS_IMPORTS;
        this.INSERT_INNER_CLASS_IMPORTS = rootSettings.INSERT_INNER_CLASS_IMPORTS;
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = rootSettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = rootSettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(rootSettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.IMPORT_LAYOUT_TABLE.copyFrom(rootSettings.IMPORT_LAYOUT_TABLE);
        this.REPLACE_INSTANCEOF = rootSettings.REPLACE_INSTANCEOF;
        this.REPLACE_CAST = rootSettings.REPLACE_CAST;
        this.REPLACE_NULL_CHECK = rootSettings.REPLACE_NULL_CHECK;
        this.FIELD_NAME_PREFIX = rootSettings.FIELD_NAME_PREFIX;
        this.STATIC_FIELD_NAME_PREFIX = rootSettings.STATIC_FIELD_NAME_PREFIX;
        this.PARAMETER_NAME_PREFIX = rootSettings.PARAMETER_NAME_PREFIX;
        this.LOCAL_VARIABLE_NAME_PREFIX = rootSettings.LOCAL_VARIABLE_NAME_PREFIX;
        this.FIELD_NAME_SUFFIX = rootSettings.FIELD_NAME_SUFFIX;
        this.STATIC_FIELD_NAME_SUFFIX = rootSettings.STATIC_FIELD_NAME_SUFFIX;
        this.PARAMETER_NAME_SUFFIX = rootSettings.PARAMETER_NAME_SUFFIX;
        this.LOCAL_VARIABLE_NAME_SUFFIX = rootSettings.LOCAL_VARIABLE_NAME_SUFFIX;
        this.PREFER_LONGER_NAMES = rootSettings.PREFER_LONGER_NAMES;
        this.GENERATE_FINAL_LOCALS = rootSettings.GENERATE_FINAL_LOCALS;
        this.GENERATE_FINAL_PARAMETERS = rootSettings.GENERATE_FINAL_PARAMETERS;
        this.VISIBILITY = rootSettings.VISIBILITY;
        this.FIELD_TYPE_TO_NAME.copyFrom(rootSettings.FIELD_TYPE_TO_NAME);
        this.LOCAL_VARIABLE_TYPE_TO_NAME.copyFrom(rootSettings.LOCAL_VARIABLE_TYPE_TO_NAME);
        this.PARAMETER_TYPE_TO_NAME.copyFrom(rootSettings.PARAMETER_TYPE_TO_NAME);
        this.STATIC_FIELD_TYPE_TO_NAME.copyFrom(rootSettings.STATIC_FIELD_TYPE_TO_NAME);
        this.ENABLE_JAVADOC_FORMATTING = rootSettings.ENABLE_JAVADOC_FORMATTING;
        this.JD_ALIGN_PARAM_COMMENTS = rootSettings.JD_ALIGN_PARAM_COMMENTS;
        this.JD_ALIGN_EXCEPTION_COMMENTS = rootSettings.JD_ALIGN_EXCEPTION_COMMENTS;
        this.JD_ADD_BLANK_AFTER_PARM_COMMENTS = rootSettings.JD_ADD_BLANK_AFTER_PARM_COMMENTS;
        this.JD_ADD_BLANK_AFTER_RETURN = rootSettings.JD_ADD_BLANK_AFTER_RETURN;
        this.JD_ADD_BLANK_AFTER_DESCRIPTION = rootSettings.JD_ADD_BLANK_AFTER_DESCRIPTION;
        this.JD_P_AT_EMPTY_LINES = rootSettings.JD_P_AT_EMPTY_LINES;
        this.JD_KEEP_INVALID_TAGS = rootSettings.JD_KEEP_INVALID_TAGS;
        this.JD_KEEP_EMPTY_LINES = rootSettings.JD_KEEP_EMPTY_LINES;
        this.JD_DO_NOT_WRAP_ONE_LINE_COMMENTS = rootSettings.JD_DO_NOT_WRAP_ONE_LINE_COMMENTS;
        this.JD_USE_THROWS_NOT_EXCEPTION = rootSettings.JD_USE_THROWS_NOT_EXCEPTION;
        this.JD_KEEP_EMPTY_PARAMETER = rootSettings.JD_KEEP_EMPTY_PARAMETER;
        this.JD_KEEP_EMPTY_EXCEPTION = rootSettings.JD_KEEP_EMPTY_EXCEPTION;
        this.JD_KEEP_EMPTY_RETURN = rootSettings.JD_KEEP_EMPTY_RETURN;
        this.JD_LEADING_ASTERISKS_ARE_ENABLED = rootSettings.JD_LEADING_ASTERISKS_ARE_ENABLED;
        this.JD_PRESERVE_LINE_FEEDS = rootSettings.JD_PRESERVE_LINE_FEEDS;
        this.JD_PARAM_DESCRIPTION_ON_NEW_LINE = rootSettings.JD_PARAM_DESCRIPTION_ON_NEW_LINE;
        this.JD_INDENT_ON_CONTINUATION = rootSettings.JD_INDENT_ON_CONTINUATION;
        if (rootSettings.WRAP_COMMENTS) {
            rootSettings.getCommonSettings((Language)JavaLanguage.INSTANCE).WRAP_COMMENTS = rootSettings.WRAP_COMMENTS;
        }
    }

    public Object clone() {
        JavaCodeStyleSettings cloned = (JavaCodeStyleSettings)((Object)super.clone());
        cloned.myRepeatAnnotations = new ArrayList<String>();
        cloned.setRepeatAnnotations(this.getRepeatAnnotations());
        cloned.FIELD_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
        cloned.FIELD_TYPE_TO_NAME.copyFrom(this.FIELD_TYPE_TO_NAME);
        cloned.STATIC_FIELD_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
        cloned.STATIC_FIELD_TYPE_TO_NAME.copyFrom(this.STATIC_FIELD_TYPE_TO_NAME);
        cloned.PARAMETER_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
        cloned.PARAMETER_TYPE_TO_NAME.copyFrom(this.PARAMETER_TYPE_TO_NAME);
        cloned.LOCAL_VARIABLE_TYPE_TO_NAME = new CodeStyleSettings.TypeToNameMap();
        cloned.LOCAL_VARIABLE_TYPE_TO_NAME.copyFrom(this.LOCAL_VARIABLE_TYPE_TO_NAME);
        cloned.PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
        cloned.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(this.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        cloned.IMPORT_LAYOUT_TABLE = new PackageEntryTable();
        cloned.IMPORT_LAYOUT_TABLE.copyFrom(this.IMPORT_LAYOUT_TABLE);
        return cloned;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        Element child = parentElement.getChild(this.getTagName());
        if (child != null) {
            this.myRepeatAnnotations.clear();
            Element annotations2 = child.getChild(REPEAT_ANNOTATIONS);
            if (annotations2 != null) {
                for (Element anno : annotations2.getChildren("ANNO")) {
                    this.myRepeatAnnotations.add(anno.getAttributeValue("name"));
                }
            }
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(1);
        }
        super.writeExternal(parentElement, parentSettings);
        if (!this.myRepeatAnnotations.isEmpty()) {
            Element child = parentElement.getChild(this.getTagName());
            if (child == null) {
                child = new Element(this.getTagName());
            }
            Element annos = new Element(REPEAT_ANNOTATIONS);
            for (String annotation : this.myRepeatAnnotations) {
                annos.addContent(new Element("ANNO").setAttribute("name", annotation));
            }
            child.addContent(annos);
        }
    }

    public static JavaCodeStyleSettings getInstance(@NotNull PsiFile file) {
        if (file == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(2);
        }
        return (JavaCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, JavaCodeStyleSettings.class);
    }

    public static JavaCodeStyleSettings getInstance(@NotNull Project project) {
        if (project == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(3);
        }
        return (JavaCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/JavaCodeStyleSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "importLegacySettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

