/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.arrangement.MemberOrderService;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiImplementationHelperImpl
extends JavaPsiImplementationHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.JavaPsiImplementationHelperImpl");
    private final Project myProject;

    public JavaPsiImplementationHelperImpl(@NotNull Project project) {
        if (project == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public PsiClass getOriginalClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(1);
        }
        PsiClass psiClass2 = this.findCompiledElement(psiClass, scope -> {
            String fqn;
            if (psiClass == null) {
                JavaPsiImplementationHelperImpl.$$$reportNull$$$0(24);
            }
            return (fqn = psiClass.getQualifiedName()) != null ? Arrays.asList(JavaPsiFacade.getInstance((Project)this.myProject).findClasses(fqn, scope)) : Collections.emptyList();
        });
        if (psiClass2 == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(2);
        }
        return psiClass2;
    }

    @Override
    @NotNull
    public PsiJavaModule getOriginalModule(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(3);
        }
        PsiJavaModule psiJavaModule = this.findCompiledElement(module, scope -> {
            if (module == null) {
                JavaPsiImplementationHelperImpl.$$$reportNull$$$0(23);
            }
            return JavaFileManager.getInstance(this.myProject).findModules(module.getName(), (GlobalSearchScope)scope);
        });
        if (psiJavaModule == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(4);
        }
        return psiJavaModule;
    }

    private <T extends PsiElement> T findCompiledElement(T original, Function<GlobalSearchScope, Collection<T>> candidateFinder) {
        PsiCompiledElement cls = (PsiCompiledElement)original.getUserData(ClsElementImpl.COMPILED_ELEMENT);
        if (cls != null && cls.isValid()) {
            PsiCompiledElement t = cls;
            return (T)t;
        }
        if (!DumbService.isDumb((Project)this.myProject)) {
            VirtualFile vFile = original.getContainingFile().getVirtualFile();
            ProjectFileIndex idx = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (vFile != null && idx.isInLibrarySource(vFile)) {
                GlobalSearchScope librariesScope = LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope();
                HashSet originalEntries = ContainerUtil.newHashSet((Iterable)idx.getOrderEntriesForFile(vFile));
                for (PsiElement candidate : candidateFinder.apply(librariesScope)) {
                    VirtualFile candidateVFile;
                    PsiFile candidateFile = candidate.getContainingFile();
                    if (candidateFile == null || (candidateVFile = candidateFile.getVirtualFile()) == null) continue;
                    for (OrderEntry candidateEntry : idx.getOrderEntriesForFile(candidateVFile)) {
                        if (!originalEntries.contains(candidateEntry)) continue;
                        return (T)candidate;
                    }
                }
            }
        }
        return original;
    }

    @Override
    @NotNull
    public PsiElement getClsFileNavigationElement(@NotNull PsiJavaFile clsFile) {
        if (clsFile == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(5);
        }
        Function<VirtualFile, VirtualFile> finder = null;
        PsiClass[] classes2 = clsFile.getClasses();
        if (classes2.length > 0) {
            String sourceFileName = ((ClsClassImpl)classes2[0]).getSourceFileName();
            String packageName = clsFile.getPackageName();
            String relativePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
            finder = root -> root.findFileByRelativePath(relativePath);
        } else {
            PsiJavaModule module = clsFile.getModuleDeclaration();
            if (module != null) {
                String moduleName = module.getName();
                finder = root -> moduleName.equals(root.getName()) ? root.findChild("module-info.java") : null;
            }
        }
        if (finder == null) {
            PsiJavaFile psiJavaFile = clsFile;
            if (psiJavaFile == null) {
                JavaPsiImplementationHelperImpl.$$$reportNull$$$0(6);
            }
            return psiJavaFile;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)clsFile.getProject());
        PsiElement psiElement = (PsiElement)this.findSourceRoots(index, clsFile.getContainingFile().getVirtualFile()).map(finder).filter(source -> source != null && source.isValid()).map(arg_0 -> ((PsiManager)clsFile.getManager()).findFile(arg_0)).filter(PsiClassOwner.class::isInstance).findFirst().orElse((PsiFile)clsFile);
        if (psiElement == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @NotNull
    private Stream<VirtualFile> findSourceRoots(@NotNull ProjectFileIndex index, @NotNull VirtualFile virtualFile) {
        if (index == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(9);
        }
        Stream rootsByProjectModel = index.getOrderEntriesForFile(virtualFile).stream().filter(entry -> entry instanceof LibraryOrSdkOrderEntry && entry.isValid()).flatMap(entry -> Stream.of(entry.getFiles(OrderRootType.SOURCES)));
        Stream syntheticLibraryRoots = Stream.of(Extensions.getExtensions((ExtensionPointName)AdditionalLibraryRootsProvider.EP_NAME)).flatMap(provider -> provider.getAdditionalProjectLibraries(this.myProject).stream()).filter(syntheticLibrary -> {
            if (virtualFile == null) {
                JavaPsiImplementationHelperImpl.$$$reportNull$$$0(22);
            }
            return syntheticLibrary.contains(virtualFile, false, true);
        }).flatMap(lib -> lib.getSourceRoots().stream());
        Stream<VirtualFile> stream = Stream.concat(rootsByProjectModel, syntheticLibraryRoots);
        if (stream == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel level;
        if (virtualFile == null || this.myProject.isDefault()) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((Project)this.myProject);
            if (languageLevel == null) {
                JavaPsiImplementationHelperImpl.$$$reportNull$$$0(11);
            }
            return languageLevel;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent != null && (level = (LanguageLevel)parent.getUserData(LanguageLevel.KEY)) != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                JavaPsiImplementationHelperImpl.$$$reportNull$$$0(12);
            }
            return languageLevel;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        Module module = index.getModuleForFile(virtualFile);
        if (module != null && index.isInSourceContent(virtualFile)) {
            LanguageLevel languageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
            if (languageLevel == null) {
                JavaPsiImplementationHelperImpl.$$$reportNull$$$0(13);
            }
            return languageLevel;
        }
        LanguageLevel classesLanguageLevel = this.getClassesLanguageLevel(virtualFile);
        LanguageLevel languageLevel = classesLanguageLevel != null ? classesLanguageLevel : PsiUtil.getLanguageLevel((Project)this.myProject);
        if (languageLevel == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(14);
        }
        return languageLevel;
    }

    @Nullable
    private LanguageLevel getClassesLanguageLevel(VirtualFile virtualFile) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
        VirtualFile folder = virtualFile.getParent();
        if (sourceRoot != null && sourceRoot.isDirectory() && folder != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)folder, (VirtualFile)sourceRoot, (char)'/');
            if (relativePath == null) {
                LOG.error("Null relative path: folder=" + folder + "; root=" + sourceRoot);
                return null;
            }
            String className = virtualFile.getNameWithoutExtension();
            HashSet visitedRoots = ContainerUtil.newHashSet();
            for (OrderEntry entry : index.getOrderEntriesForFile(virtualFile)) {
                for (VirtualFile rootFile : entry.getFiles(OrderRootType.CLASSES)) {
                    PsiJavaFile javaFile;
                    if (!visitedRoots.add(rootFile)) continue;
                    VirtualFile classFile = rootFile.findFileByRelativePath(relativePath);
                    PsiJavaFile psiJavaFile = javaFile = classFile == null ? null : this.getPsiFileInRoot(classFile, className);
                    if (javaFile == null) continue;
                    return javaFile.getLanguageLevel();
                }
            }
            return LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel();
        }
        return null;
    }

    @Nullable
    private PsiJavaFile getPsiFileInRoot(VirtualFile dirFile, @Nullable String className) {
        VirtualFile[] children;
        PsiFile psiFile;
        VirtualFile classFile;
        if (className != null && (classFile = dirFile.findChild(StringUtil.getQualifiedName((String)className, (String)StdFileTypes.CLASS.getDefaultExtension()))) != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(classFile)) instanceof PsiJavaFile) {
            return (PsiJavaFile)psiFile;
        }
        for (VirtualFile child : children = dirFile.getChildren()) {
            PsiFile psiFile2;
            if (!StdFileTypes.CLASS.equals(child.getFileType()) || !child.isValid() || !((psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(child)) instanceof PsiJavaFile)) continue;
            return (PsiJavaFile)psiFile2;
        }
        return null;
    }

    @Override
    public ASTNode getDefaultImportAnchor(@NotNull PsiImportList list, @NotNull PsiImportStatementBase statement) {
        if (list == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(15);
        }
        if (statement == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(16);
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)list.getProject());
        ImportHelper importHelper = new ImportHelper(settings);
        return importHelper.getDefaultAnchor(list, statement);
    }

    @Override
    @Nullable
    public PsiElement getDefaultMemberAnchor(@NotNull PsiClass aClass, @NotNull PsiMember member) {
        PsiElement lBrace;
        if (aClass == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(17);
        }
        if (member == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(18);
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)aClass.getProject());
        MemberOrderService service = (MemberOrderService)ServiceManager.getService(MemberOrderService.class);
        PsiElement anchor = service.getAnchor((PsiElement)member, settings.getCommonSettings((Language)JavaLanguage.INSTANCE), (PsiElement)aClass);
        PsiElement newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor);
        if (newAnchor != null) {
            return newAnchor;
        }
        if (anchor != null && anchor != aClass) {
            anchor = anchor.getNextSibling();
            while (anchor instanceof PsiJavaToken && (anchor.getText().equals(",") || anchor.getText().equals(";"))) {
                boolean afterComma = anchor.getText().equals(",");
                anchor = anchor.getNextSibling();
                if (!afterComma || (newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor)) == null) continue;
                return newAnchor;
            }
            if (anchor != null) {
                return anchor;
            }
        }
        if ((lBrace = aClass.getLBrace()) != null) {
            PsiElement result = lBrace.getNextSibling();
            while (result instanceof PsiWhiteSpace) {
                result = result.getNextSibling();
            }
            return result;
        }
        return aClass.getRBrace();
    }

    private static PsiElement skipWhitespaces(PsiClass aClass, PsiElement anchor) {
        if (anchor != null && PsiTreeUtil.skipWhitespacesForward((PsiElement)anchor) == aClass.getRBrace()) {
            return aClass.getRBrace();
        }
        return null;
    }

    @Override
    public void setupCatchBlock(@NotNull String exceptionName, @NotNull PsiType exceptionType, PsiElement context, @NotNull PsiCatchSection catchSection) {
        PsiDirectory directory;
        FileTemplate template;
        if (exceptionName == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(19);
        }
        if (exceptionType == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(20);
        }
        if (catchSection == null) {
            JavaPsiImplementationHelperImpl.$$$reportNull$$$0(21);
        }
        if ((template = FileTemplateManager.getInstance((Project)catchSection.getProject()).getCodeTemplate("Catch Statement Body.java")) == null) {
            throw new IncorrectOperationException("Missing template: Catch Statement Body.java");
        }
        Properties props = FileTemplateManager.getInstance((Project)this.myProject).getDefaultProperties();
        props.setProperty("EXCEPTION", exceptionName);
        props.setProperty("EXCEPTION_TYPE", exceptionType.getCanonicalText());
        if (context != null && context.isPhysical() && (directory = context.getContainingFile().getContainingDirectory()) != null) {
            JavaTemplateUtil.setPackageNameAttribute(props, directory);
        }
        try {
            PsiCodeBlock block = PsiElementFactory.SERVICE.getInstance((Project)this.myProject).createCodeBlockFromText("{\n" + template.getText(props) + "\n}", null);
            Objects.requireNonNull(catchSection.getCatchBlock()).replace((PsiElement)block);
        }
        catch (ProcessCanceledException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Incorrect file template", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/JavaPsiImplementationHelperImpl";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clsFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchSection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/JavaPsiImplementationHelperImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClsFileNavigationElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceRoots";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalClass";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalModule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClsFileNavigationElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSourceRoots";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultImportAnchor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMemberAnchor";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setupCatchBlock";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSourceRoots$8";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOriginalModule$1";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOriginalClass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

