/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaModuleReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaModuleImpl
extends ClsRepositoryPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    private final PsiJavaModuleReferenceElement myReference;

    public ClsJavaModuleImpl(PsiJavaModuleStub stub) {
        super(stub);
        this.myReference = new ClsJavaModuleReferenceElementImpl((PsiElement)this, stub.getName());
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.REQUIRES_STATEMENT, (PsiElement[])PsiRequiresStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.EXPORTS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.OPENS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.USES_STATEMENT, (PsiElement[])PsiUsesStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.PROVIDES_STATEMENT, (PsiElement[])PsiProvidesStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(5);
        }
        ClsJavaModuleImpl.appendText((PsiElement)this.getModifierList(), indentLevel, buffer);
        buffer.append("module ").append(this.getName()).append(" {\n");
        int newIndentLevel = indentLevel + this.getIndentSize();
        int start = buffer.length();
        ClsJavaModuleImpl.appendChildren(this.getRequires(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getExports(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getOpens(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getUses(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getProvides(), buffer, newIndentLevel, start);
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indentLevel);
        buffer.append('}');
    }

    private static void appendChildren(Iterable<? extends PsiElement> children, StringBuilder buffer, int indentLevel, int start) {
        ArrayList statements = ContainerUtil.newArrayList(children);
        if (!statements.isEmpty()) {
            if (buffer.length() > start) {
                buffer.append('\n');
            }
            for (PsiElement statement : statements) {
                ClsJavaModuleImpl.appendText(statement, indentLevel, buffer);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(6);
        }
        this.setMirrorCheckingType(element, JavaElementType.MODULE);
        PsiJavaModule mirror = (PsiJavaModule)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        ClsJavaModuleImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsJavaModuleImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsJavaModuleImpl.setMirrors(this.getRequires(), mirror.getRequires());
        ClsJavaModuleImpl.setMirrors(this.getExports(), mirror.getExports());
        ClsJavaModuleImpl.setMirrors(this.getOpens(), mirror.getOpens());
        ClsJavaModuleImpl.setMirrors(this.getUses(), mirror.getUses());
        ClsJavaModuleImpl.setMirrors(this.getProvides(), mirror.getProvides());
    }

    private static <T extends PsiElement> void setMirrors(Iterable<T> stubs, Iterable<T> mirrors) {
        ClsJavaModuleImpl.setMirrors(ContainerUtil.newArrayList(stubs), ContainerUtil.newArrayList(mirrors));
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.myReference;
        if (psiJavaModuleReferenceElement == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(7);
        }
        return psiJavaModuleReferenceElement;
    }

    @NotNull
    public String getName() {
        String string = this.myReference.getReferenceText();
        if (string == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(9);
        }
        throw ClsJavaModuleImpl.cannotModifyException(this);
    }

    public PsiModifierList getModifierList() {
        StubElement childStub = ((PsiJavaModuleStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        return childStub != null ? (PsiModifierList)childStub.getPsi() : null;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        PsiModifierList modifierList;
        if (name == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(10);
        }
        return (modifierList = this.getModifierList()) != null && modifierList.hasModifierProperty(name);
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiJavaModule module;
        PsiElement file;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClassOwner && (file = parent.getNavigationElement()) != parent && file instanceof PsiJavaFile && (module = ((PsiJavaFile)file).getModuleDeclaration()) != null) {
            PsiJavaModule psiJavaModule = module;
            if (psiJavaModule == null) {
                ClsJavaModuleImpl.$$$reportNull$$$0(11);
            }
            return psiJavaModule;
        }
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.getNameIdentifier();
        if (psiJavaModuleReferenceElement == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(12);
        }
        return psiJavaModuleReferenceElement;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ClsJavaModuleImpl.$$$reportNull$$$0(13);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModule((PsiJavaModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsJavaModuleImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequires";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvides";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsJavaModuleImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

