/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create((String)"LANGUAGE_LEVEL", file -> file.getLanguageLevelInner());

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new MyCacheBuilder(this), false);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @NotNull
    public PsiClass[] getClasses() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiClass[] psiClassArray = (PsiClass[])stub.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(0);
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(1);
        }
        return psiClassArray;
    }

    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getPackageName();
            if (string == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String name = this.myPackageName;
        if (name == null) {
            PsiPackageStatement statement = this.getPackageStatement();
            name = statement == null ? "" : statement.getPackageName();
            this.myPackageName = name;
        }
        String string = name;
        if (string == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile((PsiFile)this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace((PsiElement)factory.createReferenceFromText(packageName, (PsiElement)packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            PsiElement anchor = this.getFirstChild();
            if ("package-info.java".equals(this.getName())) {
                while (anchor instanceof PsiWhiteSpace || anchor instanceof PsiComment) {
                    anchor = anchor.getNextSibling();
                }
            }
            this.addBefore((PsiElement)factory.createPackageStatement(packageName), anchor);
        }
    }

    public PsiImportList getImportList() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType((IElementType)JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            if (nodes.length == 0) {
                return null;
            }
            this.reportStubAstMismatch(stub + "; " + stub.getChildrenStubs(), this.getStubTree());
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
    }

    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(6);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(7);
        }
        return psiClassArray;
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, (PsiElement)aClass)) continue;
                return statement.getImportReference();
            }
        }
        return null;
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(8);
        }
        return IMPLICIT_IMPORTS;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences((PsiManager)this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(9);
        }
        return psiJavaCodeReferenceElementArray;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(10);
        }
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(12);
        }
        assert (this.isValid());
        if (processor instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor;
            String name = hint.getName(state);
            MostlySingularMultiMap cache = (MostlySingularMultiMap)this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor, state);
            return name != null ? cache.processForKey((Object)name, (Processor)cacheProcessor) : cache.processAllValues((Processor)cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    /*
     * WARNING - void declaration
     */
    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiElement resolved;
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(13);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint != null ? nameHint.getName(state) : null;
        PsiImportList importList = this.getImportList();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            void var14_21;
            PsiClass[] classes2;
            for (PsiClass aClass : classes2 = this.getClasses()) {
                if (processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
            PsiImportStatement[] importStatements = importList != null ? importList.getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
            for (PsiImportStaticStatement psiImportStaticStatement : importStatements) {
                String refText;
                if (psiImportStaticStatement.isOnDemand() || name != null && ((refText = psiImportStaticStatement.getQualifiedName()) == null || !refText.endsWith(name)) || !((resolved = psiImportStaticStatement.resolve()) instanceof PsiClass)) continue;
                processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)psiImportStaticStatement);
                PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
                if (!(containingClass != null && containingClass.hasTypeParameters() ? !processor.execute(resolved, state.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass))) : !processor.execute(resolved, state))) continue;
                return false;
            }
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(this.getPackageName());
            if (aPackage != null && !PsiJavaFileBaseImpl.processPackageDeclarations(processor, state, place, aPackage)) {
                return false;
            }
            PsiImportStatement[] psiImportStatementArray = importStatements;
            int n = psiImportStatementArray.length;
            boolean bl = false;
            while (var14_21 < n) {
                PsiElement resolved2;
                PsiImportStatement statement2 = psiImportStatementArray[var14_21];
                if (statement2.isOnDemand() && (resolved2 = statement2.resolve()) != null) {
                    processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement2);
                    PsiJavaFileBaseImpl.processOnDemandTarget(resolved2, processor, state, place);
                }
                ++var14_21;
            }
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStaticStatements = importList != null ? importList.getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        if (importStaticStatements.length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor);
            for (PsiImportStaticStatement psiImportStaticStatement : importStaticStatements) {
                JavaResolveResult[] results;
                PsiJavaCodeReferenceElement reference;
                if (psiImportStaticStatement.isOnDemand() || (reference = psiImportStaticStatement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStaticStatement);
                String referenceName = psiImportStaticStatement.getReferenceName();
                for (JavaResolveResult result : results) {
                    staticImportProcessor.registerSingleStaticImportHiding(result, referenceName);
                    PsiElement element = result.getElement();
                    if (element == null || staticImportProcessor.execute(element, state)) continue;
                    return false;
                }
            }
            for (PsiImportStaticStatement psiImportStaticStatement : importStaticStatements) {
                PsiClass targetElement;
                if (!psiImportStaticStatement.isOnDemand() || (targetElement = psiImportStaticStatement.resolveTargetClass()) == null) continue;
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStaticStatement);
                if (targetElement.processDeclarations((PsiScopeProcessor)staticImportProcessor, state, lastParent, place)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiJavaCodeReferenceElement[] implicitlyImported = this.getImplicitlyImportedPackageReferences();
            for (PsiImportStaticStatement psiImportStaticStatement : implicitlyImported) {
                resolved = psiImportStaticStatement.resolve();
                if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processPackageDeclarations(PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement place, @NotNull PsiPackage aPackage) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(14);
        }
        if (aPackage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(15);
        }
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor = new DelegatingScopeProcessor((PsiScopeProcessor)processor){

                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)new ElementClassHint(){

                            @Override
                            public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
                                return kind2 == ElementClassHint.DeclarationKind.CLASS;
                            }
                        };
                    }
                    return (T)super.getHint(hintKey);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "getHint"));
                }
            };
        }
        return aPackage.processDeclarations(processor, state, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)containingClass);
        if (psiSubstitutor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(16);
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!PsiJavaFileBaseImpl.processPackageDeclarations(processor, substitutor, place, (PsiPackage)target)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor = substitutor.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor.execute((PsiElement)inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.error((Object)target);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(17);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(18);
        }
        return javaLanguage;
    }

    public boolean importClass(PsiClass aClass) {
        return JavaCodeStyleManager.getInstance((Project)this.getProject()).addImport((PsiJavaFile)this, aClass);
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = (LanguageLevel)LANGUAGE_LEVEL_KEY.getValue((UserDataHolder)this);
        if (languageLevel == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(19);
        }
        return languageLevel;
    }

    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    public void clearCaches() {
        super.clearCaches();
        this.putUserData((Key)LANGUAGE_LEVEL_KEY, null);
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(20);
        }
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = (LanguageLevel)this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project = this.getProject();
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevel.HIGHEST;
        }
        return JavaPsiImplementationHelper.getInstance(project).getEffectiveLanguageLevel(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsNoGuess";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor, ResolveState state) {
            this.myProcessor = processor;
            this.myState = state;
        }

        public boolean process(SymbolCollectingProcessor.ResultWithContext result) {
            PsiClass containingClass;
            PsiElement context = result.getFileContext();
            this.myProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)context);
            PsiNamedElement element = result.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute((PsiElement)element, this.myState.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute((PsiElement)element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        public MyCacheBuilder(PsiJavaFileBaseImpl file) {
            this.myFile = file;
        }

        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), (PsiElement)this.myFile, (PsiElement)this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myFile});
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenFieldNames = new HashSet<String>();
        private final Collection<String> myHiddenMethodNames = new HashSet<String>();
        private final Collection<String> myHiddenTypeNames = new HashSet<String>();
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        public StaticImportFilteringProcessor(PsiScopeProcessor delegate) {
            this.myDelegate = delegate;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(0);
            }
            return (T)this.myDelegate.getHint(hintKey);
        }

        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (event == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(1);
            }
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event) && associated instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
            }
            this.myDelegate.handleEvent(event, associated);
        }

        private void registerSingleStaticImportHiding(JavaResolveResult result, String referenceName) {
            this.getHiddenMembers(result.getElement()).add(referenceName);
        }

        private Collection<String> getHiddenMembers(PsiElement element) {
            if (element instanceof PsiField) {
                return this.myHiddenFieldNames;
            }
            return element instanceof PsiClass ? this.myHiddenTypeNames : this.myHiddenMethodNames;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand) {
                    String name = ((PsiNamedElement)element).getName();
                    if (this.getHiddenMembers(element).contains(name)) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleEvent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

