/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiSwitchLabelStatementImpl
extends CompositePsiElement
implements PsiSwitchLabelStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiSwitchLabelStatementImpl");

    public PsiSwitchLabelStatementImpl() {
        super(SWITCH_LABEL_STATEMENT);
    }

    public boolean isDefaultCase() {
        return this.findChildByRoleAsPsiElement(85) != null;
    }

    public PsiExpression getCaseValue() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(86);
    }

    public PsiSwitchStatement getEnclosingSwitchStatement() {
        CompositeElement guessedSwitch = this.getTreeParent().getTreeParent();
        return guessedSwitch != null && guessedSwitch.getElementType() == SWITCH_STATEMENT ? (PsiSwitchStatement)SourceTreeToPsiMap.treeElementToPsi((ASTNode)guessedSwitch) : null;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 84: {
                return this.findChildByType(CASE_KEYWORD);
            }
            case 85: {
                return this.findChildByType(DEFAULT_KEYWORD);
            }
            case 86: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 87: 
        }
        return this.findChildByType(COLON);
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == CASE_KEYWORD) {
            return 84;
        }
        if (i == DEFAULT_KEYWORD) {
            return 85;
        }
        if (i == COLON) {
            return 87;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 86;
        }
        return 0;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass aClass;
        PsiExpression expression2;
        if (processor == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(2);
        }
        if (lastParent == null) {
            return true;
        }
        PsiSwitchStatement switchStatement = this.getEnclosingSwitchStatement();
        if (switchStatement != null && (expression2 = switchStatement.getExpression()) != null && expression2.getType() instanceof PsiClassType && (aClass = ((PsiClassType)expression2.getType()).resolve()) != null) {
            aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.ENUM_CONST, processor), state, (PsiElement)this, place);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSwitchLabelStatement((PsiSwitchLabelStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiSwitchLabelStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

