/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubsHierarchy.impl.StubClassAnchor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.IntIntHashMap;
import gnu.trove.TByteArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import org.jetbrains.annotations.NotNull;

class AnchorRepository {
    private static final int MAX_BYTE_VALUE = 255;
    private final TIntArrayList myFileIds = new TIntArrayList(80000);
    private final TByteArrayList myShortStubIds = new TByteArrayList(80000);
    private final TIntIntHashMap myLongStubIds = new IntIntHashMap();

    AnchorRepository() {
    }

    int registerClass(int fileId, int stubId) {
        int anchorId = this.myFileIds.size();
        this.myFileIds.add(fileId);
        if (stubId < 255) {
            this.myShortStubIds.add((byte)stubId);
        } else {
            this.myShortStubIds.add((byte)-1);
            this.myLongStubIds.put(anchorId, stubId);
        }
        return anchorId;
    }

    StubClassAnchor getAnchor(int anchorId) {
        return new StubClassAnchor(anchorId, this.getFileId(anchorId), this.getStubId(anchorId));
    }

    int getFileId(int anchorId) {
        return this.myFileIds.get(anchorId);
    }

    int getStubId(int anchorId) {
        int stubId = Byte.toUnsignedInt(this.myShortStubIds.get(anchorId));
        return stubId < 255 ? stubId : this.myLongStubIds.get(anchorId);
    }

    int size() {
        return this.myFileIds.size();
    }

    void trimToSize() {
        this.myFileIds.trimToSize();
        this.myShortStubIds.trimToSize();
        this.myLongStubIds.trimToSize();
    }

    @NotNull
    static VirtualFile retrieveFile(int fileId) {
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.assertNotNull((Object)PersistentFS.getInstance().findFileById(fileId));
        if (virtualFile == null) {
            AnchorRepository.$$$reportNull$$$0(0);
        }
        return virtualFile;
    }

    static String anchorToString(int stubId, int fileId) {
        return stubId + " in " + AnchorRepository.retrieveFile(fileId).getPath();
    }

    @NotNull
    PsiClass retrieveClass(@NotNull Project project, int anchorId) {
        if (project == null) {
            AnchorRepository.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = AnchorRepository.retrieveClass(project, this.getFileId(anchorId), this.getStubId(anchorId));
        if (psiClass == null) {
            AnchorRepository.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    @NotNull
    static PsiClass retrieveClass(@NotNull Project project, int fileId, int stubId) {
        if (project == null) {
            AnchorRepository.$$$reportNull$$$0(3);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(AnchorRepository.retrieveFile(fileId));
        assert (psiFile != null) : AnchorRepository.anchorToString(stubId, fileId);
        PsiElement element = ((PsiFileWithStubSupport)psiFile).getStubbedSpine().getStubPsi(stubId);
        if (!(element instanceof PsiClass)) {
            throw new AssertionError((Object)(AnchorRepository.anchorToString(stubId, fileId) + "; " + psiFile));
        }
        PsiClass psiClass = (PsiClass)element;
        if (psiClass == null) {
            AnchorRepository.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubsHierarchy/impl/AnchorRepository";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubsHierarchy/impl/AnchorRepository";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "retrieveClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

