/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoImpl
implements JavaParameterInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ParameterInfoImpl");
    public int oldParameterIndex;
    private boolean useAnySingleVariable;
    private String name = "";
    private CanonicalTypes.Type myType;
    String defaultValue = "";

    public ParameterInfoImpl(int oldParameterIndex) {
        this.oldParameterIndex = oldParameterIndex;
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name, PsiType aType) {
        this.setName(name);
        this.oldParameterIndex = oldParameterIndex;
        this.setType(aType);
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name, PsiType aType, @NonNls String defaultValue) {
        this(oldParameterIndex, name, aType, defaultValue, false);
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name, PsiType aType, @NonNls String defaultValue, boolean useAnyVariable) {
        this(oldParameterIndex, name, aType);
        this.defaultValue = defaultValue;
        this.useAnySingleVariable = useAnyVariable;
    }

    public ParameterInfoImpl(int oldParameterIndex, String name, CanonicalTypes.Type typeWrapper, String defaultValue) {
        this.setName(name);
        this.oldParameterIndex = oldParameterIndex;
        this.myType = typeWrapper;
        this.defaultValue = defaultValue;
    }

    public int getOldIndex() {
        return this.oldParameterIndex;
    }

    public void setUseAnySingleVariable(boolean useAnySingleVariable) {
        this.useAnySingleVariable = useAnySingleVariable;
    }

    public void updateFromMethod(PsiMethod method) {
        if (this.getTypeWrapper() != null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        LOG.assertTrue(this.oldParameterIndex >= 0 && this.oldParameterIndex < parameters2.length);
        PsiParameter parameter2 = parameters2[this.oldParameterIndex];
        this.setName(parameter2.getName());
        this.setType(parameter2.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterInfoImpl)) {
            return false;
        }
        ParameterInfoImpl parameterInfo = (ParameterInfoImpl)o;
        if (this.oldParameterIndex != parameterInfo.oldParameterIndex) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(parameterInfo.defaultValue) : parameterInfo.defaultValue != null) {
            return false;
        }
        if (!this.getName().equals(parameterInfo.getName())) {
            return false;
        }
        return this.getTypeText().equals(parameterInfo.getTypeText());
    }

    public int hashCode() {
        String name = this.getName();
        int result = name != null ? name.hashCode() : 0;
        result = 29 * result + this.getTypeText().hashCode();
        return result;
    }

    @Override
    public String getTypeText() {
        if (this.getTypeWrapper() != null) {
            return this.getTypeWrapper().getTypeText();
        }
        return "";
    }

    @Override
    public PsiType createType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
        if (this.getTypeWrapper() != null) {
            return this.getTypeWrapper().getType(context, manager);
        }
        return null;
    }

    @Override
    public void setType(PsiType type2) {
        this.myType = CanonicalTypes.createTypeWrapper(type2);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public CanonicalTypes.Type getTypeWrapper() {
        return this.myType;
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    @Override
    public boolean isVarargType() {
        return this.getTypeText().endsWith("...");
    }

    public static ParameterInfoImpl[] fromMethod(PsiMethod method) {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            result.add(new ParameterInfoImpl(i, parameter2.getName(), parameter2.getType()));
        }
        return result.toArray(new ParameterInfoImpl[0]);
    }

    @Override
    @Nullable
    public PsiExpression getValue(PsiCallExpression expr) throws IncorrectOperationException {
        if (StringUtil.isEmpty((String)this.defaultValue)) {
            return null;
        }
        PsiExpression expression2 = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory().createExpressionFromText(this.defaultValue, (PsiElement)expr);
        return (PsiExpression)JavaCodeStyleManager.getInstance((Project)expr.getProject()).shortenClassReferences((PsiElement)expression2);
    }

    public boolean isUseAnySingleVariable() {
        return this.useAnySingleVariable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

