/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

abstract class FragmentNode
extends DefaultMutableTreeNode
implements Comparable<FragmentNode> {
    private final TextChunk[] myTextChunks;
    private final int myOffset;

    protected FragmentNode(PsiElement start, PsiElement end) {
        this.myTextChunks = this.createTextChunks(start, end);
        this.myOffset = start.getTextRange().getStartOffset();
        this.setAllowsChildren(false);
    }

    public TextChunk[] getTextChunks() {
        return this.myTextChunks;
    }

    protected TextChunk[] createTextChunks(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            FragmentNode.$$$reportNull$$$0(0);
        }
        if (end == null) {
            FragmentNode.$$$reportNull$$$0(1);
        }
        UsageInfo2UsageAdapter usageStartAdapter = new UsageInfo2UsageAdapter(new UsageInfo(start));
        String text2 = start.getText();
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        Document document = PsiDocumentManager.getInstance((Project)start.getProject()).getDocument(start.getContainingFile());
        if (document != null) {
            int endLine;
            int startLine = FragmentNode.getLineNumber(document, start.getTextRange().getStartOffset()) + 1;
            String lineText = startLine == (endLine = FragmentNode.getLineNumber(document, end.getTextRange().getEndOffset()) + 1) ? Integer.toString(startLine) : startLine + ".." + endLine;
            EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
            chunks.add(new TextChunk(colorsScheme.getAttributes(UsageTreeColors.USAGE_LOCATION), lineText));
        }
        return ChunkExtractor.getExtractor((PsiFile)start.getContainingFile()).createTextChunks(usageStartAdapter, (CharSequence)text2, 0, text2.length(), true, chunks);
    }

    protected Navigatable getNavigatable() {
        return null;
    }

    public boolean isExcluded() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    private static int getLineNumber(@NotNull Document document, int offset) {
        if (document == null) {
            FragmentNode.$$$reportNull$$$0(2);
        }
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (offset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(offset);
    }

    @Override
    public int compareTo(@NotNull FragmentNode o) {
        if (o == null) {
            FragmentNode.$$$reportNull$$$0(3);
        }
        return this.myOffset - o.myOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/FragmentNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTextChunks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineNumber";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

