/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessorBase;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorReflectionAccessor
extends ReflectionAccessorBase<ConstructorDescriptor> {
    private static final Logger LOG = Logger.getInstance(ConstructorReflectionAccessor.class);

    protected ConstructorReflectionAccessor(@NotNull PsiClass psiClass, @NotNull PsiElementFactory elementFactory) {
        if (psiClass == null) {
            ConstructorReflectionAccessor.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            ConstructorReflectionAccessor.$$$reportNull$$$0(1);
        }
        super(psiClass, elementFactory);
    }

    @Override
    protected List<ConstructorDescriptor> findItemsToReplace(@NotNull PsiElement element) {
        if (element == null) {
            ConstructorReflectionAccessor.$$$reportNull$$$0(2);
        }
        final ArrayList<ConstructorDescriptor> result = new ArrayList<ConstructorDescriptor>();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                super.visitNewExpression(expression2);
                if (expression2.getAnonymousClass() != null || expression2.getArrayInitializer() != null) {
                    return;
                }
                ConstructorDescriptor descriptor = ConstructorDescriptor.createIfInaccessible(expression2);
                if (descriptor != null) {
                    result.add(descriptor);
                }
            }
        });
        return result;
    }

    @Override
    protected void grantAccess(@NotNull ConstructorDescriptor descriptor) {
        if (descriptor == null) {
            ConstructorReflectionAccessor.$$$reportNull$$$0(3);
        }
        String className = ClassUtil.getJVMClassName((PsiClass)descriptor.psiClass);
        String returnType = PsiReflectionAccessUtil.getAccessibleReturnType(descriptor.psiClass);
        PsiExpressionList argumentList = descriptor.newExpression.getArgumentList();
        if (className == null || argumentList == null || returnType == null) {
            LOG.warn("code is incomplete: " + descriptor.newExpression);
            return;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(this.getOuterClass(), "new" + className);
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(methodName);
        methodBuilder.accessedConstructor(className).setStatic(this.getOuterClass().hasModifierProperty("static")).setReturnType(returnType);
        if (descriptor.constructor != null) {
            methodBuilder.addParameters(descriptor.constructor.getParameterList());
        }
        PsiMethod newPsiMethod = methodBuilder.build(this.getElementFactory(), (PsiElement)this.getOuterClass());
        this.getOuterClass().add((PsiElement)newPsiMethod);
        String args = StreamEx.of((Object[])argumentList.getExpressions()).map(x -> x.getText()).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        String newCallExpression = newPsiMethod.getName() + args;
        descriptor.newExpression.replace((PsiElement)this.getElementFactory().createExpressionFromText(newCallExpression, (PsiElement)descriptor.newExpression));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ConstructorReflectionAccessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findItemsToReplace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "grantAccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ConstructorDescriptor
    implements ItemToReplaceDescriptor {
        public final PsiNewExpression newExpression;
        public final PsiClass psiClass;
        @Nullable
        public final PsiMethod constructor;

        @Nullable
        public static ConstructorDescriptor createIfInaccessible(@NotNull PsiNewExpression expression2) {
            PsiMethod constructor;
            if (expression2 == null) {
                ConstructorDescriptor.$$$reportNull$$$0(0);
            }
            if ((constructor = expression2.resolveConstructor()) != null) {
                PsiClass containingClass = constructor.getContainingClass();
                if (containingClass != null && !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)constructor)) {
                    return new ConstructorDescriptor(expression2, constructor, containingClass);
                }
            } else {
                PsiElement referent;
                PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
                PsiElement psiElement = referent = classReference2 != null ? classReference2.resolve() : null;
                if (referent instanceof PsiClass && !PsiReflectionAccessUtil.isAccessible((PsiClass)referent)) {
                    return new ConstructorDescriptor(expression2, null, (PsiClass)referent);
                }
            }
            return null;
        }

        public ConstructorDescriptor(@NotNull PsiNewExpression expression2, @Nullable PsiMethod constructor, PsiClass psiClass) {
            if (expression2 == null) {
                ConstructorDescriptor.$$$reportNull$$$0(1);
            }
            this.newExpression = expression2;
            this.constructor = constructor;
            this.psiClass = psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ConstructorReflectionAccessor$ConstructorDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createIfInaccessible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

