/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiReflectionAccessUtil {
    PsiReflectionAccessUtil() {
    }

    public static boolean isAccessibleMember(@NotNull PsiMember classMember) {
        if (classMember == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(0);
        }
        return classMember.hasModifierProperty("public") && PsiReflectionAccessUtil.isAccessible(classMember.getContainingClass());
    }

    @Contract(value="null -> false")
    public static boolean isAccessible(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (PsiReflectionAccessUtil.isArrayClass(psiClass)) {
            return true;
        }
        while (psiClass != null) {
            if (!psiClass.hasModifierProperty("public")) {
                return false;
            }
            psiClass = psiClass.getContainingClass();
        }
        return true;
    }

    @Nullable
    public static String extractQualifier(@NotNull PsiReferenceExpression referenceExpression) {
        PsiExpression qualifierExpression2;
        if (referenceExpression == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(1);
        }
        PsiType expressionType = (qualifierExpression2 = referenceExpression.getQualifierExpression()) != null ? qualifierExpression2.getType() : null;
        return expressionType == null ? null : qualifierExpression2.getText();
    }

    @Contract(value="null -> true")
    public static boolean isQualifierAccessible(@Nullable PsiExpression qualifierExpression2) {
        if (qualifierExpression2 == null) {
            return true;
        }
        PsiType type2 = qualifierExpression2.getType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        return psiClass == null || PsiReflectionAccessUtil.isAccessible(psiClass);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiClass nearestAccessedClass(@Nullable PsiClass psiClass) {
        while (psiClass != null && !psiClass.hasModifierProperty("public")) {
            psiClass = psiClass.getSuperClass();
        }
        return psiClass;
    }

    @Nullable
    public static String getAccessibleReturnType(@Nullable PsiType type2) {
        PsiClass psiClass = PsiReflectionAccessUtil.nearestAccessedClass(PsiUtil.resolveClassInType((PsiType)type2));
        if (psiClass != null) {
            return psiClass.getQualifiedName();
        }
        return type2 != null ? type2.getCanonicalText() : null;
    }

    @Nullable
    public static String getAccessibleReturnType(@Nullable PsiClass psiClass) {
        return (psiClass = PsiReflectionAccessUtil.nearestAccessedClass(psiClass)) == null ? null : psiClass.getQualifiedName();
    }

    @NotNull
    @Contract(pure=true)
    public static String classForName(@NotNull String typeName) {
        if (typeName == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(2);
        }
        String string = TypeConversionUtil.isPrimitive((String)typeName) ? typeName + ".class" : "java.lang.Class.forName(\"" + typeName + "\")";
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getUniqueMethodName(@NotNull PsiClass psiClass, @NotNull String prefix) {
        String name;
        if (psiClass == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(5);
        }
        if (!StringUtil.isJavaIdentifier((String)prefix)) {
            throw new IllegalArgumentException("prefix must be a correct java identifier: " + prefix);
        }
        int i = 1;
        do {
            name = prefix + i;
            ++i;
        } while (psiClass.findMethodsByName(name, false).length != 0);
        String string = name;
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isArrayClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(7);
        }
        Project project = psiClass.getProject();
        PsiClass arrayClass = JavaPsiFacade.getElementFactory((Project)project).getArrayClass(PsiUtil.getLanguageLevel((PsiElement)psiClass));
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)psiClass, (PsiElement)arrayClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "classForName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleMember";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractQualifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classForName";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueMethodName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

