/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.MemberHidesStaticImportUsageInfo;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameJavaMemberProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.SubmemberHidesMemberUsageInfo;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameJavaMethodProcessor
extends RenameJavaMemberProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameJavaMethodProcessor");

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PsiMethod;
    }

    public void renameElement(@NotNull PsiElement psiElement, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiAnnotation annotation;
        PsiElement element;
        if (psiElement == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(3);
        }
        PsiMethod method = (PsiMethod)psiElement;
        HashSet<PsiMethod> methodAndOverriders = new HashSet<PsiMethod>();
        HashSet<PsiClass> containingClasses = new HashSet<PsiClass>();
        LinkedHashSet<PsiElement> renamedReferences = new LinkedHashSet<PsiElement>();
        ArrayList<MemberHidesOuterMemberUsageInfo> outerHides = new ArrayList<MemberHidesOuterMemberUsageInfo>();
        ArrayList<MemberHidesStaticImportUsageInfo> staticImportHides = new ArrayList<MemberHidesStaticImportUsageInfo>();
        methodAndOverriders.add(method);
        containingClasses.add(method.getContainingClass());
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (element == null) continue;
            if (usage instanceof MemberHidesStaticImportUsageInfo) {
                staticImportHides.add((MemberHidesStaticImportUsageInfo)usage);
                continue;
            }
            if (usage instanceof MemberHidesOuterMemberUsageInfo) {
                PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)element;
                PsiMethod resolved = (PsiMethod)collidingRef.resolve();
                outerHides.add(new MemberHidesOuterMemberUsageInfo(element, (PsiMember)resolved));
                continue;
            }
            if (!(element instanceof PsiMethod)) {
                PsiElement e;
                PsiReference ref = usage instanceof MoveRenameUsageInfo ? usage.getReference() : element.getReference();
                if (ref instanceof PsiImportStaticReferenceElement && ((PsiImportStaticReferenceElement)ref).multiResolve(false).length > 1 || ref == null || (e = this.processRef(ref, newName)) == null) continue;
                renamedReferences.add(e);
                continue;
            }
            PsiMethod overrider = (PsiMethod)element;
            methodAndOverriders.add(overrider);
            containingClasses.add(overrider.getContainingClass());
        }
        method.setName(newName);
        for (UsageInfo usage : usages) {
            element = usage.getElement();
            if (!(element instanceof PsiMethod)) continue;
            ((PsiMethod)element).setName(newName);
        }
        if (listener != null) {
            listener.elementRenamed((PsiElement)method);
        }
        for (PsiElement element2 : renamedReferences) {
            RenameJavaMethodProcessor.fixNameCollisionsWithInnerClassMethod(element2, newName, methodAndOverriders, containingClasses, method.hasModifierProperty("static"));
        }
        RenameJavaMethodProcessor.qualifyOuterMemberReferences(outerHides);
        RenameJavaMethodProcessor.qualifyStaticImportReferences(staticImportHides);
        if (!method.isConstructor() && method.isPhysical() && method.findDeepestSuperMethods().length == 0 && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{"java.lang.Override"})) != null && annotation.isPhysical()) {
            annotation.delete();
        }
    }

    @Nullable
    protected PsiElement processRef(PsiReference ref, String newName) {
        return ref.handleElementRename(newName);
    }

    private static void fixNameCollisionsWithInnerClassMethod(PsiElement element, String newName, Set<PsiMethod> methodAndOverriders, Set<PsiClass> containingClasses, boolean isStatic) throws IncorrectOperationException {
        PsiMethod actualMethod;
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement elem = ((PsiReferenceExpression)element).resolve();
        if (elem instanceof PsiMethod && !methodAndOverriders.contains(actualMethod = (PsiMethod)elem)) {
            PsiClass outerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            while (outerClass != null) {
                PsiClass finalOuterClass = outerClass;
                if (containingClasses.stream().anyMatch(psiClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)finalOuterClass, (PsiClass)psiClass, (boolean)true))) {
                    RenameJavaMethodProcessor.qualifyMember(element, newName, outerClass, isStatic);
                    break;
                }
                outerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)outerClass, PsiClass.class);
            }
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(4);
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
        Collection collection = MethodReferencesSearch.search((PsiMethod)((PsiMethod)element), (SearchScope)projectScope, (boolean)true).findAll();
        if (collection == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(7);
        }
        if (allRenames == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(8);
        }
        if (result == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(9);
        }
        PsiMethod methodToRename = (PsiMethod)element;
        RenameJavaMethodProcessor.findSubmemberHidesMemberCollisions(methodToRename, newName, result);
        RenameJavaMethodProcessor.findMemberHidesOuterMemberCollisions((PsiMember)((PsiMethod)element), newName, result);
        RenameJavaMethodProcessor.findCollisionsAgainstNewName((PsiMember)methodToRename, newName, result);
        this.findHidingMethodWithOtherSignature(methodToRename, newName, result);
        PsiClass containingClass = methodToRename.getContainingClass();
        if (containingClass != null) {
            PsiMethod patternMethod = (PsiMethod)methodToRename.copy();
            try {
                patternMethod.setName(newName);
                final PsiMethod methodInBaseClass = containingClass.findMethodBySignature(patternMethod, true);
                if (methodInBaseClass != null && methodInBaseClass.getContainingClass() != containingClass && methodInBaseClass.hasModifierProperty("final")) {
                    result.add((UsageInfo)new UnresolvableCollisionUsageInfo((PsiElement)methodInBaseClass, (PsiElement)methodToRename){

                        public String getDescription() {
                            return "Renaming method will override final \"" + RefactoringUIUtil.getDescription((PsiElement)methodInBaseClass, (boolean)true) + "\"";
                        }
                    });
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void findHidingMethodWithOtherSignature(PsiMethod methodToRename, String newName, List<UsageInfo> result) {
        PsiClass containingClass = methodToRename.getContainingClass();
        if (containingClass != null) {
            PsiMethod prototype = RenameJavaMethodProcessor.getPrototypeWithNewName(methodToRename, newName);
            if (prototype == null || containingClass.findMethodBySignature(prototype, true) != null) {
                return;
            }
            PsiMethod[] methodsByName = containingClass.findMethodsByName(newName, true);
            if (methodsByName.length > 0) {
                for (UsageInfo info : result) {
                    PsiReferenceExpression copyRef;
                    PsiElement element = info.getElement();
                    if (!(element instanceof PsiReferenceExpression) || ((PsiReferenceExpression)element).resolve() != methodToRename) continue;
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression copy = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText(parent.getText(), element);
                        copyRef = copy.getMethodExpression();
                    } else {
                        LOG.assertTrue(element instanceof PsiMethodReferenceExpression, (Object)element.getText());
                        copyRef = (PsiReferenceExpression)element.copy();
                    }
                    PsiReferenceExpression expression2 = (PsiReferenceExpression)this.processRef((PsiReference)copyRef, newName);
                    if (expression2 == null) continue;
                    JavaResolveResult resolveResult = expression2.advancedResolve(true);
                    final PsiMember resolveResultElement = (PsiMember)resolveResult.getElement();
                    if (!resolveResult.isValidResult() || resolveResultElement == null) continue;
                    result.add((UsageInfo)new UnresolvableCollisionUsageInfo(element, (PsiElement)methodToRename){

                        public String getDescription() {
                            return "Method call would be linked to \"" + RefactoringUIUtil.getDescription((PsiElement)resolveResultElement, (boolean)true) + "\" after rename";
                        }
                    });
                    break;
                }
            }
        }
    }

    private static PsiMethod getPrototypeWithNewName(PsiMethod methodToRename, String newName) {
        PsiMethod prototype = (PsiMethod)methodToRename.copy();
        try {
            prototype.setName(newName);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
        return prototype;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(10);
        }
        if (newName == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(11);
        }
        if (conflicts == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(12);
        }
        if (element instanceof PsiCompiledElement) {
            return;
        }
        PsiMethod refactoredMethod = (PsiMethod)element;
        if (newName.equals(refactoredMethod.getName())) {
            return;
        }
        PsiMethod prototype = RenameJavaMethodProcessor.getPrototypeWithNewName(refactoredMethod, newName);
        if (prototype == null) {
            return;
        }
        ConflictsUtil.checkMethodConflicts(refactoredMethod.getContainingClass(), refactoredMethod, prototype, conflicts);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        PsiMethod method;
        PsiMethod[] siblings;
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(13);
        }
        if (newName == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(14);
        }
        if (allRenames == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(16);
        }
        if ((siblings = (PsiMethod[])(method = (PsiMethod)element).getUserData(SuperMethodWarningUtil.SIBLINGS)) == null) {
            siblings = new PsiMethod[]{method};
        }
        for (PsiMethod sibling : siblings) {
            if (sibling != method) {
                allRenames.put((PsiElement)sibling, newName);
            }
            OverridingMethodsSearch.search((PsiMethod)sibling, (SearchScope)scope, (boolean)true).forEach(overrider -> {
                String baseName;
                PsiElement prototype;
                if (newName == null) {
                    RenameJavaMethodProcessor.$$$reportNull$$$0(29);
                }
                if (allRenames == null) {
                    RenameJavaMethodProcessor.$$$reportNull$$$0(30);
                }
                if (overrider instanceof PsiMirrorElement && (prototype = ((PsiMirrorElement)overrider).getPrototype()) instanceof PsiMethod) {
                    overrider = (PsiMethod)prototype;
                }
                if (overrider instanceof SyntheticElement) {
                    return true;
                }
                String overriderName = overrider.getName();
                String newOverriderName = RefactoringUtil.suggestNewOverriderName(overriderName, baseName = sibling.getName(), newName);
                if (newOverriderName != null) {
                    RenameProcessor.assertNonCompileElement((PsiElement)overrider);
                    allRenames.put((PsiElement)overrider, newOverriderName);
                }
                return true;
            });
        }
    }

    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameMethod";
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(17);
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(18);
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = enabled;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, Editor editor) {
        PsiMethod psiMethod;
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(19);
        }
        if ((psiMethod = (PsiMethod)element).isConstructor()) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            if (Comparing.strEqual((String)psiMethod.getName(), (String)containingClass.getName())) {
                element = containingClass;
                if (!PsiElementRenameHandler.canRename((Project)element.getProject(), (Editor)editor, (PsiElement)element)) {
                    return null;
                }
                return element;
            }
        }
        return SuperMethodWarningUtil.checkSuperMethod(psiMethod, RefactoringBundle.message((String)"to.rename"));
    }

    public void substituteElementToRename(@NotNull PsiElement element, final @NotNull Editor editor, final @NotNull Pass<PsiElement> renameCallback) {
        PsiMethod psiMethod;
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(21);
        }
        if (renameCallback == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(22);
        }
        if ((psiMethod = (PsiMethod)element).isConstructor()) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!Comparing.strEqual((String)psiMethod.getName(), (String)containingClass.getName())) {
                renameCallback.pass((Object)psiMethod);
                return;
            }
            super.substituteElementToRename(element, editor, renameCallback);
        } else {
            SuperMethodWarningUtil.checkSuperMethod(psiMethod, "Rename", new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod method) {
                    if (method == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!PsiElementRenameHandler.canRename((Project)method.getProject(), (Editor)editor, (PsiElement)method)) {
                        return false;
                    }
                    renameCallback.pass((Object)method);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/rename/RenameJavaMethodProcessor$3", "execute"));
                }
            }, editor);
        }
    }

    private static void findSubmemberHidesMemberCollisions(PsiMethod method, String newName, List<UsageInfo> result) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (method.hasModifierProperty("private")) {
            return;
        }
        Collection inheritors = ClassInheritorsSearch.search((PsiClass)containingClass).findAll();
        MethodSignature oldSignature = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignature newSignature = MethodSignatureUtil.createMethodSignature((String)newName, (PsiType[])oldSignature.getParameterTypes(), (PsiTypeParameter[])oldSignature.getTypeParameters(), (PsiSubstitutor)oldSignature.getSubstitutor(), (boolean)method.isConstructor());
        block0: for (PsiClass inheritor : inheritors) {
            PsiMethod[] methodsByName;
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (PsiMethod conflictingMethod : methodsByName = inheritor.findMethodsByName(newName, false)) {
                if (!newSignature.equals(conflictingMethod.getSignature(superSubstitutor))) continue;
                result.add((UsageInfo)new SubmemberHidesMemberUsageInfo((PsiElement)conflictingMethod, (PsiElement)method));
                continue block0;
            }
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(23);
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(24);
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = enabled;
    }

    @NotNull
    public UsageInfo createUsageInfo(final @NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(25);
        }
        if (ref == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(26);
        }
        if (referenceElement == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(27);
        }
        MoveRenameUsageInfo moveRenameUsageInfo = new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref).multiResolve(true).length <= 0)){

            public boolean equals(Object o) {
                return super.equals(o) && o instanceof MoveRenameUsageInfo && element.equals(((MoveRenameUsageInfo)o).getReferencedElement());
            }

            public int hashCode() {
                return 29 * super.hashCode() + element.hashCode();
            }
        };
        if (moveRenameUsageInfo == null) {
            RenameJavaMethodProcessor.$$$reportNull$$$0(28);
        }
        return moveRenameUsageInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameJavaMethodProcessor";
                break;
            }
            case 8: 
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameJavaMethodProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 5: 
            case 28: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareRenaming$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

